/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.views;

import fr.cnav.autocontrol.export.Activator;
import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.IndividualHelper;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.providers.AnomalieLabelProvider;
import fr.cnav.autocontrole.providers.IndividualLabelProvider;
import fr.cnav.autocontrole.providers.detail.IndividualDetailProvider;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.providers.MessageIndividualContentProvider;
import fr.cnav.autocontrole.ui.providers.MessageIndividualLabelProvider;
import fr.cnav.autocontrole.ui.providers.MessageIndividualTreeObject;
import fr.cnav.autocontrole.ui.views.HelperScroll;
import fr.cnav.autocontrole.ui.views.PrincipaleView;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.validator.message.api.IMessageElement;
import java.math.BigInteger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class IndividualView
extends ViewPart {
    private static final String INDIVIDUAL_GROUP_NAME = "Individual";
    public static final String ID = "fr.cnav.autocontrole.ui.views.IndividualView";
    private Text text1;
    private Text text2;
    private Text text3;
    private Text text4;
    private Text textDetail;
    private FilteredTree table;
    private TreeViewer treeViewer;
    private TreeViewerColumn tableViewerColumn;
    private TreeViewerColumn tableViewerValueColumn;
    private IndividualDetailProvider individualDetailProvider = new IndividualDetailProvider();
    private Composite parent;
    private ComposedAdapterFactory adapterFactory;
    boolean initializeDataMode = false;
    private Anomaly anomaly;

    public void createPartControl(Composite parent) {
        try {
            this.parent = parent;
            parent.setLayout((Layout)new GridLayout(1, false));
            this.initGroupIndividual(parent);
            SashForm sashForm = new SashForm(parent, 2560);
            sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.initGroupRubrique((Composite)sashForm);
            this.initGroupDetail((Composite)sashForm);
            sashForm.setWeights(new int[]{252, 115});
            this.createActions();
            this.initializeToolBar();
            this.initializeMenu();
            this.initializeData(null);
            if (StandardHelper.getInstance().getMessageDescriptor() != null) {
                this.setPartName(StandardHelper.getInstance().getMessageDescriptor().getIndividualLabel());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_INDIVIDUAL_VIEW_INITIALIZATION.getMessage(), t));
        }
    }

    public boolean isObjectAlreadySelected(Object anomalieElt) {
        if (IndividualHelper.isAnomaly((Object)anomalieElt)) {
            return (Anomaly)anomalieElt == this.anomaly;
        }
        return false;
    }

    public void initializeData(Object anomalieElt) {
        block24: {
            try {
                IWorkbenchPage page;
                IViewPart viewPPl;
                this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                SaturneItemProviderAdapterFactory saturneFactory = new SaturneItemProviderAdapterFactory();
                this.adapterFactory.addAdapterFactory((AdapterFactory)saturneFactory);
                this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
                this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
                if (MessageFile.getInstance() == null || !((viewPPl = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findView("fr.cnav.autocontrole.ui.views.PrincipaleView")) instanceof PrincipaleView)) break block24;
                this.treeViewer.setContentProvider((IContentProvider)new MessageIndividualContentProvider());
                this.treeViewer.setLabelProvider((IBaseLabelProvider)new MessageIndividualLabelProvider((AdapterFactory)this.adapterFactory));
                if (IndividualHelper.isAnomaly((Object)anomalieElt)) {
                    this.anomaly = (Anomaly)anomalieElt;
                    this.initializeDataMode = true;
                    Object normeElt = null;
                    IndividualLabelProvider individualLabelProvider = new IndividualLabelProvider(anomalieElt);
                    if (individualLabelProvider.getIndividual() != null) {
                        this.treeViewer.setInput((Object)new MessageIndividualTreeObject((IMessageElement)individualLabelProvider.getIndividual().getMessageBlock(), individualLabelProvider.getIndividual().getDeclaration()));
                    }
                    if (individualLabelProvider.getIndividual() != null) {
                        normeElt = individualLabelProvider.getNormeElt();
                    }
                    if (normeElt != null) {
                        this.treeViewer.expandToLevel(normeElt, -1);
                        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)new MessageIndividualTreeObject((IMessageElement)normeElt, null)));
                        if (this.text1 != null) {
                            try {
                                this.text1.setText(individualLabelProvider.getText(0));
                            }
                            catch (AutoCtrlException e) {
                                e.printStackTrace();
                                Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", e.getMessage(), (Throwable)e));
                                this.text1.setText("");
                            }
                        }
                        if (this.text2 != null) {
                            try {
                                this.text2.setText(individualLabelProvider.getText(1));
                            }
                            catch (AutoCtrlException e) {
                                e.printStackTrace();
                                Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", e.getMessage(), (Throwable)e));
                                this.text2.setText("");
                            }
                        }
                        if (this.text3 != null) {
                            try {
                                this.text3.setText(individualLabelProvider.getText(2));
                            }
                            catch (AutoCtrlException e) {
                                e.printStackTrace();
                                Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", e.getMessage(), (Throwable)e));
                                this.text3.setText("");
                            }
                        }
                        if (this.text4 != null) {
                            try {
                                this.text4.setText(individualLabelProvider.getText(3));
                            }
                            catch (AutoCtrlException e) {
                                e.printStackTrace();
                                Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", e.getMessage(), (Throwable)e));
                                this.text4.setText("");
                            }
                        }
                        break block24;
                    }
                    if (this.text1 != null) {
                        this.text1.setText("");
                    }
                    if (this.text2 != null) {
                        this.text2.setText("");
                    }
                    if (this.text3 != null) {
                        this.text3.setText("");
                    }
                    if (this.text4 != null) {
                        this.text4.setText("");
                    }
                    this.resetData();
                    break block24;
                }
                this.resetData();
            }
            catch (Throwable t) {
                t.printStackTrace();
                Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_INDIVIDUAL_VIEW_REFRESH.getMessage(), t));
                MessageDialog.openError((Shell)this.parent.getShell(), (String)Messages.OpenViewIndividualHandler_0, (String)String.format(ExceptionKind.ERROR_INDIVIDUAL_VIEW_REFRESH.getMessage(), new Object[0]));
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                    Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_OPENING_ERROR_LOG.getMessage(), (Throwable)e));
                }
            }
        }
    }

    public void resetData() {
        if (this.text1 != null) {
            this.text1.setText("");
        }
        if (this.text2 != null) {
            this.text2.setText("");
        }
        if (this.text3 != null) {
            this.text3.setText("");
        }
        if (this.text4 != null) {
            this.text4.setText("");
        }
        this.treeViewer.setContentProvider((IContentProvider)new MessageIndividualContentProvider());
        this.treeViewer.setInput(null);
        this.textDetail.setText("");
    }

    private void initGroupDetail(Composite sashForm) {
        Group grpDetail = new Group(sashForm, 0);
        grpDetail.setLayout((Layout)new GridLayout(1, false));
        grpDetail.setText(Messages.IndividualView_8);
        this.textDetail = new Text((Composite)grpDetail, 2816);
        this.textDetail.setEditable(false);
        GridData gd_textDetail = new GridData(4, 4, true, true, 1, 1);
        gd_textDetail.minimumHeight = 80;
        gd_textDetail.heightHint = 80;
        this.textDetail.setLayoutData((Object)gd_textDetail);
        Font font = new Font((Device)sashForm.getDisplay(), "Courier New", 10, 0);
        this.textDetail.setFont(font);
    }

    private void initGroupRubrique(Composite sashForm) {
        Group grpRubriques = new Group(sashForm, 0);
        grpRubriques.setLayout((Layout)new GridLayout(1, false));
        grpRubriques.setText(Messages.IndividualView_5);
        PatternFilter filter = new PatternFilter();
        this.table = new FilteredTree((Composite)grpRubriques, 68356, filter, true);
        this.treeViewer = this.table.getViewer();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn tblclmnRubrique = this.tableViewerColumn.getColumn();
        tblclmnRubrique.setAlignment(0x1000000);
        tblclmnRubrique.setWidth(600);
        tblclmnRubrique.setText(Messages.IndividualView_6);
        this.tableViewerValueColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn tblclmnValeur = this.tableViewerValueColumn.getColumn();
        tblclmnValeur.setWidth(200);
        tblclmnValeur.setText(Messages.IndividualView_7);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void initGroupIndividual(Composite parent) {
        Group grpSalarie = new Group(parent, 0);
        grpSalarie.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpSalarie.setLayout((Layout)new GridLayout(4, false));
        if (StandardHelper.getInstance().getMessageDescriptor() != null) {
            grpSalarie.setText(StandardHelper.getInstance().getMessageDescriptor().getIndividualLabel());
        } else {
            grpSalarie.setText(INDIVIDUAL_GROUP_NAME);
        }
        if (IndividualLabelProvider.getTitle((int)0) != null) {
            Label lblText1 = new Label((Composite)grpSalarie, 0);
            lblText1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblText1.setText(IndividualLabelProvider.getTitle((int)0));
            this.text1 = new Text((Composite)grpSalarie, 2048);
            this.text1.setEditable(false);
            this.text1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        if (IndividualLabelProvider.getTitle((int)1) != null) {
            Label lblText2 = new Label((Composite)grpSalarie, 0);
            lblText2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblText2.setText(IndividualLabelProvider.getTitle((int)1));
            this.text2 = new Text((Composite)grpSalarie, 2048);
            this.text2.setEditable(false);
            this.text2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        if (IndividualLabelProvider.getTitle((int)2) != null) {
            Label lblText3 = new Label((Composite)grpSalarie, 0);
            lblText3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblText3.setText(IndividualLabelProvider.getTitle((int)2));
            this.text3 = new Text((Composite)grpSalarie, 2048);
            this.text3.setEditable(false);
            this.text3.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        if (IndividualLabelProvider.getTitle((int)3) != null) {
            Label lblText4 = new Label((Composite)grpSalarie, 0);
            lblText4.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblText4.setText(IndividualLabelProvider.getTitle((int)3));
            this.text4 = new Text((Composite)grpSalarie, 2048);
            this.text4.setEditable(false);
            this.text4.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
    }

    private void createActions() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    IWorkbenchPage page;
                    IViewPart viewPPl;
                    if (event.getSelection() instanceof StructuredSelection && (viewPPl = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findView("fr.cnav.autocontrole.ui.views.PrincipaleView")) instanceof PrincipaleView) {
                        PrincipaleView principaleView = (PrincipaleView)viewPPl;
                        String anomalie = "";
                        Object selectedObject = ((StructuredSelection)event.getSelection()).getFirstElement();
                        if (selectedObject != null && selectedObject instanceof MessageIndividualTreeObject) {
                            IMessageElement element = ((MessageIndividualTreeObject)selectedObject).getElement();
                            AnomalieLabelProvider anomalieLabelProvider = new AnomalieLabelProvider();
                            if (IndividualView.this.initializeDataMode) {
                                anomalie = anomalieLabelProvider.getText(8, principaleView.getSelectedObject());
                                IndividualView.this.textDetail.setText(IndividualView.this.individualDetailProvider.getText((Object)element, anomalie));
                                IndividualView.this.updateScroll();
                            } else if (IndividualHelper.isRubrique((Object)element)) {
                                BigInteger targetLine = IndividualHelper.getLineNumber((Object)element);
                                IndividualView.this.initializeDataMode = true;
                                principaleView.selectFistAnomalieWithLine(targetLine);
                                anomalie = anomalieLabelProvider.getText(8, principaleView.getSelectedObject());
                                IndividualView.this.textDetail.setText(IndividualView.this.individualDetailProvider.getText((Object)element, anomalie));
                                IndividualView.this.updateScroll();
                            } else if (IndividualHelper.isSousGroupe((Object)element)) {
                                IndividualView.this.textDetail.setText(IndividualView.this.individualDetailProvider.getText((Object)element, anomalie));
                                IndividualView.this.updateScroll();
                            }
                        }
                        IndividualView.this.initializeDataMode = false;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_INDIVIDUAL_VIEW_REFRESH.getMessage(), t));
                    MessageDialog.openError((Shell)IndividualView.this.parent.getShell(), (String)Messages.OpenViewIndividualHandler_0, (String)String.format(ExceptionKind.ERROR_INDIVIDUAL_VIEW_REFRESH.getMessage(), new Object[0]));
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                        Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_OPENING_ERROR_LOG.getMessage(), (Throwable)e));
                    }
                }
            }
        });
        this.textDetail.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                IndividualView.this.updateScroll();
            }
        });
    }

    private void updateScroll() {
        HelperScroll.updateScolls(this.textDetail);
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
        this.parent.setFocus();
        this.treeViewer.getControl().setFocus();
    }
}

