/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.metacontrol;

import fr.cnav.saturne.dsl.formules.And;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.Or;
import fr.cnav.saturne.dsl.metacontrol.DSLStringTransformation;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractMetacontrolValidation {
    protected String getStringExpression(Expression clause) {
        String clauseExpression = new DSLStringTransformation().expressionAsString(clause);
        return clauseExpression;
    }

    protected Expression getAtomFromLiteral(Expression literal) {
        if (literal instanceof Not) {
            return ((Not)literal).getOperand();
        }
        return literal;
    }

    protected ArrayList<Expression> getLiteralsFromClause(Expression clause) {
        ArrayList<Expression> literals = new ArrayList<Expression>();
        if (clause instanceof Or) {
            literals.addAll((Collection<Expression>)((Or)clause).getOperands());
        } else {
            literals.add(clause);
        }
        return literals;
    }

    protected ArrayList<Expression> getClausesFromCnfExpression(Expression cnfExpression) {
        ArrayList<Expression> clauses = new ArrayList<Expression>();
        if (cnfExpression instanceof Nary && ((Nary)cnfExpression).getOperands().size() == 0) {
            return clauses;
        }
        if (cnfExpression instanceof And) {
            clauses.addAll((Collection<Expression>)((And)cnfExpression).getOperands());
        } else {
            clauses.add(cnfExpression);
        }
        return clauses;
    }

    public boolean areClausesDuplicate(Expression clause1, Expression clause2) {
        boolean areClausesDuplicate = false;
        if (clause1 instanceof Nary && clause2 instanceof Nary) {
            EList<Expression> operands1 = ((Nary)clause1).getOperands();
            EList<Expression> operands2 = ((Nary)clause2).getOperands();
            if (operands1.size() == operands2.size()) {
                for (Expression exp1 : operands1) {
                    ArrayList<Expression> duplicateExpressionFound = new ArrayList<Expression>();
                    boolean isRedundant = false;
                    for (Expression exp2 : operands2) {
                        if (isRedundant || !this.areClausesDuplicate(exp1, exp2) || duplicateExpressionFound.contains(exp2)) continue;
                        isRedundant = true;
                        duplicateExpressionFound.add(exp2);
                    }
                    if (isRedundant) continue;
                    return false;
                }
                areClausesDuplicate = true;
            }
        } else {
            areClausesDuplicate = EcoreUtil.equals((EObject)clause1, (EObject)clause2);
        }
        return areClausesDuplicate;
    }
}

