/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.p03v01.all.rules;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import n4ds.dsn.p03v01.all.rules.ChaineUtil;

public class LigneDistributionControleurUtil {
    private static final String POINT = ".";
    private static final String APOSTROPHE = "'";
    private static final String ESPACE = " ";
    private static final String TRAIT_UNION = "-";
    private final String msg_0 = "Pr\u00e9sence d'un ou plusieurs caract\u00e8res non autoris\u00e9s par la norme";
    private final String msg_1 = "Caract\u00e8res non autoris\u00e9s pour les adresses postales";
    private final String msg_2 = "Les caract\u00e8res apostrophe, espace, trait d'union et point ne peuvent \u00eatre utilis\u00e9s en d\u00e9but de rubrique";
    private final String msg_3 = "Les caract\u00e8res apostrophe, espace, trait d'union et point ne peuvent \u00eatre utilis\u00e9s en fin de rubrique";
    private final String msg_4 = "Les caract\u00e8res apostrophe, espace, trait d'union et point doivent \u00eatre utilis\u00e9s de mani\u00e8re isol\u00e9e";
    private final String msg_5 = "Le num\u00e9ro doit se composer de 5 caract\u00e8res maximum";
    private final String msg_6 = "Le num\u00e9ro doit se composer de 3 caract\u00e8res num\u00e9riques maximum, d'un espace et d'un caract\u00e8re alphanum\u00e9rique";
    private final String msg_8 = "Le num\u00e9ro doit se composer \u00e9ventuellement de 4 caract\u00e8res num\u00e9riques et d'un caract\u00e8re alphanum\u00e9rique";
    private final String msg_7 = "Pas de num\u00e9ro dans la ligne de distribution";
    private ArrayList<String> messagesRetourControle = new ArrayList();
    private boolean resultatRetourControle;
    private ArrayList<String> tabCombinaisonPointApostropheEspaceTrait = new ArrayList();
    private ArrayList<String> tabCaractereDebutFin = new ArrayList();

    public LigneDistributionControleurUtil() {
        this.tabCombinaisonPointApostropheEspaceTrait.add("..");
        this.tabCombinaisonPointApostropheEspaceTrait.add(".-");
        this.tabCombinaisonPointApostropheEspaceTrait.add(".'");
        this.tabCombinaisonPointApostropheEspaceTrait.add(" .");
        this.tabCombinaisonPointApostropheEspaceTrait.add(" -");
        this.tabCombinaisonPointApostropheEspaceTrait.add(" '");
        this.tabCombinaisonPointApostropheEspaceTrait.add("  ");
        this.tabCombinaisonPointApostropheEspaceTrait.add("-.");
        this.tabCombinaisonPointApostropheEspaceTrait.add("--");
        this.tabCombinaisonPointApostropheEspaceTrait.add("- ");
        this.tabCombinaisonPointApostropheEspaceTrait.add("-'");
        this.tabCombinaisonPointApostropheEspaceTrait.add("'.");
        this.tabCombinaisonPointApostropheEspaceTrait.add("' ");
        this.tabCombinaisonPointApostropheEspaceTrait.add("'-");
        this.tabCombinaisonPointApostropheEspaceTrait.add("''");
        this.tabCaractereDebutFin.add(APOSTROPHE);
        this.tabCaractereDebutFin.add(ESPACE);
        this.tabCaractereDebutFin.add(POINT);
        this.tabCaractereDebutFin.add(TRAIT_UNION);
        this.resultatRetourControle = true;
    }

    public void controleLigneDistribution(String ligne) {
        Pattern ligneDistribPattern = Pattern.compile("[\\x21]|[\\x23-\\x25]|[\\x3b-\\x3c]|[\\x3e-\\x3f]|[\\x5b-\\x5e]|[\\x7b-\\x7e]|[\\xa0-\\xaa]|[\\xac-\\xaf]|[\\xb1-\\xba]|[\\xbc-\\xbf]|[\\xc6]|[\\xd0]|[\\xd7-\\xd8]|[\\xde-\\xdf]|[\\xe6]|[\\xf0]|[\\xf7-\\xf8]|[\\xfe]");
        Matcher ligneDistribMatcher = ligneDistribPattern.matcher(ligne);
        if (ligneDistribMatcher.find()) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Pr\u00e9sence d'un ou plusieurs caract\u00e8res non autoris\u00e9s par la norme");
        }
        if ((ligneDistribMatcher = (ligneDistribPattern = Pattern.compile("[(\\x21-\\x26)(\\x28-\\x2c)(\\x2f)(\\x3a-\\x40)(\\x5b-\\x60)(\\x7b-\\x7e)+(\\xa0-\\xbf)(\\xc6)(\\xd0)(\\xd7-\\xd8)(\\xde-\\xdf)(\\xe6)(\\xf0)(\\xf7-\\xf8)(\\xfe)]")).matcher(ligne)).find()) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Caract\u00e8res non autoris\u00e9s pour les adresses postales");
        }
        if (ChaineUtil.arrayExistsAtPos(this.tabCaractereDebutFin, ligne, "P")) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Les caract\u00e8res apostrophe, espace, trait d'union et point ne peuvent \u00eatre utilis\u00e9s en d\u00e9but de rubrique");
        }
        if (ChaineUtil.arrayExistsAtPos(this.tabCaractereDebutFin, ligne, "d")) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Les caract\u00e8res apostrophe, espace, trait d'union et point ne peuvent \u00eatre utilis\u00e9s en fin de rubrique");
        }
        if (ChaineUtil.arrayExistsAtPos(this.tabCombinaisonPointApostropheEspaceTrait, ligne, "i")) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Les caract\u00e8res apostrophe, espace, trait d'union et point doivent \u00eatre utilis\u00e9s de mani\u00e8re isol\u00e9e");
        }
    }

    public ArrayList<String> getMessagesRetourControle() {
        return this.messagesRetourControle;
    }

    public void setMessagesRetourControle(ArrayList<String> messagesRetourControle) {
        this.messagesRetourControle = messagesRetourControle;
    }

    public boolean getResultatRetourControle() {
        return this.resultatRetourControle;
    }

    public void setResultatRetourControle(boolean resultatRetourControle) {
        this.resultatRetourControle = resultatRetourControle;
    }

    public String messagesRetourControleToString() {
        String res = "";
        for (String msg : this.getMessagesRetourControle()) {
            if (this.getMessagesRetourControle().size() == 1) {
                res = res.concat(String.valueOf(msg) + POINT);
            }
            if (this.getMessagesRetourControle().size() <= 1) continue;
            res = this.getMessagesRetourControle().indexOf(msg) != this.getMessagesRetourControle().size() - 1 ? res.concat(String.valueOf(msg) + ". ") : res.concat(String.valueOf(msg) + POINT);
        }
        return res;
    }
}

