/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.engine;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.MessageDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ILoggingComponent;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.engine.IExecutorAndCleanerRunner;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.syntax.Cst02SyntaxControl;
import fr.cnav.saturne.validator.syntax.SyntacticControlCode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorWithCleaner
implements ITreeAndDeclarationConsumer,
ILoggingComponent {
    public static final String NULL_RULE_REGISTRY_MSG = "The rule registry of the standard must be necessarily supplied.";
    public static final String NULL_STANDARD_MSG = "The standard must be necessarily supplied.";
    public static final String NULL_REPORT_MSG = "The report logger must be necessarily supplied.";
    protected static final String PREFIX_LOGGER = "[Saturne] ";
    private final Logger logger = LoggerFactory.getLogger(ValidatorWithCleaner.class);
    private final OptionMap optionMap = new OptionMap();
    private IReportLogger reportLogger;
    private List<IMessageBlock> blockBeforeDeclaration;
    private DeclarationDescription declaration;
    private IExecutorAndCleanerRunner executorAndCleanerRunner;
    private boolean validateSyntactic;
    private boolean validateSemantic;
    private boolean unloadingActivated;
    private IMessageBlock declarationBlock;
    private ControlMessages controlMessage;

    public ValidatorWithCleaner(StandardAccessor modelAccessor, IReportLogger reportLogger, IExecutorAndCleanerRunner executorAndCleanerRunner, boolean validateSyntactic, boolean validateSemantic, boolean unloadingActivated, ControlMessages controlMessage) {
        if (reportLogger == null) {
            throw new IllegalArgumentException(NULL_REPORT_MSG);
        }
        this.reportLogger = reportLogger;
        this.executorAndCleanerRunner = executorAndCleanerRunner;
        this.validateSyntactic = validateSyntactic;
        this.validateSemantic = validateSemantic;
        this.unloadingActivated = unloadingActivated;
        this.blockBeforeDeclaration = new ArrayList<IMessageBlock>();
        this.controlMessage = controlMessage;
    }

    @Override
    public void startTree() throws TreeProcessingException {
    }

    @Override
    public void endTree() throws TreeProcessingException {
        if (!this.blockBeforeDeclaration.isEmpty()) {
            this.executeRulesBlockBeforeDeclaration();
        }
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        String blocName = block.getStandardBlockDescription().getName();
        if (blocName == null) {
            throw new TreeProcessingException("An exception has occured while reading the bloc name for the mesageBlock.");
        }
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
        if (!(block.getStandardBlockDescription() instanceof BlockDescription)) {
            if (block.getStandardBlockDescription() instanceof MessageDescription && this.validateSyntactic) {
                Cst02SyntaxControl rule = new Cst02SyntaxControl(0, SyntacticControlCode.CST_02.getCode(), (BlockDescription)((MessageDescription)block.getStandardBlockDescription()).getHeaderBlock(), this.controlMessage, this.declaration);
                this.checkRule(rule, block);
                rule = new Cst02SyntaxControl(1, SyntacticControlCode.CST_02.getCode(), ((MessageDescription)block.getStandardBlockDescription()).getFooterBlock(), this.controlMessage, this.declaration);
                this.checkRule(rule, block);
            }
            return;
        }
        if (this.declaration == null) {
            this.blockBeforeDeclaration.add(block);
        } else {
            if (!this.blockBeforeDeclaration.isEmpty()) {
                this.executeRulesBlockBeforeDeclaration();
            }
            this.executeRules(block);
        }
        if (block == this.declarationBlock) {
            this.declaration = null;
            this.declarationBlock = null;
        }
    }

    private void executeRulesBlockBeforeDeclaration() throws TreeProcessingException {
        for (IMessageBlock messageBlock : this.blockBeforeDeclaration) {
            this.executeRules(messageBlock);
        }
        this.blockBeforeDeclaration.clear();
    }

    private void executeRules(IMessageBlock block) throws TreeProcessingException {
        this.logger.debug("[Saturne] Start rules execution for " + block.getStandardBlockDescription().getFullQualifiedId() + " (start line : " + block.getFirstLine() + ")");
        this.executorAndCleanerRunner.runRules(block, this.declaration, this.reportLogger, this.validateSyntactic, this.validateSemantic, this.unloadingActivated);
        this.logger.debug("[Saturne] End rules execution for " + block.getStandardBlockDescription().getFullQualifiedId() + " (end line : " + block.getLastLine() + ")");
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
    }

    @Override
    public IReportLogger getReportLogger() {
        return this.reportLogger;
    }

    @Override
    public OptionMap getOptions() {
        return this.optionMap;
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription theDeclaration) throws TreeProcessingException {
        this.declaration = theDeclaration;
        this.declarationBlock = block;
    }

    private void checkRule(IRule rule, IMessageBlock messageBlock) throws TreeProcessingException {
        IRuleResult result = null;
        try {
            result = rule.run(messageBlock);
        }
        catch (Exception e) {
            this.logger.error("[Saturne] Problem with the executed rule " + rule.getClass().getSimpleName() + " - " + e.getClass().getName() + ", message = " + e.getMessage());
            if (e.getCause() != null && e.getCause() != e) {
                this.logger.error(PREFIX_LOGGER + e.getCause().getClass().getName() + ", message = " + e.getCause().getMessage());
            }
            this.logger.warn("[Saturne] EXC-3 : The rule ''" + rule.getCode() + "'' cause an unexpected exception : " + e.getMessage(), (Throwable)e);
        }
        this.reportResult(result);
    }

    private void reportResult(IRuleResult result) throws TreeProcessingException {
        Boolean resultSuccess;
        if (result != null && !(resultSuccess = (Boolean)result.getResult()).booleanValue()) {
            try {
                this.reportLogger.logResult(result);
            }
            catch (TooManyAnomaliesException e) {
                throw new TreeProcessingException(e);
            }
        }
    }
}

