/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.Date;

public final class DateUtil {
    public static final String DATE_FORMAT_XML = "uuuu-MM-dd";
    public static final DateTimeFormatter DATE_FORMATER_XML = DateTimeFormatter.ofPattern("uuuu-MM-dd").withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final String DATE_FORMAT_DSL = "ddMMuuuu";
    public static final DateTimeFormatter DATE_FORMATER_DSL = DateTimeFormatter.ofPattern("ddMMuuuu").withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    private static ZoneId defaultZoneId = ZoneId.systemDefault();

    private DateUtil() {
    }

    public static Date dateFromXML(String dateStr) throws IllegalArgumentException {
        LocalDate localDate = LocalDate.parse(dateStr, DATE_FORMATER_XML);
        return Date.from(localDate.atStartOfDay(defaultZoneId).toInstant());
    }

    public static String formatDateToXmlStandard(Date dateValue) {
        LocalDate localDate = Instant.ofEpochMilli(dateValue.getTime()).atZone(defaultZoneId).toLocalDate();
        return localDate.format(DATE_FORMATER_XML);
    }

    public static Date parseDateFromDsl(String dslDateStr) throws IllegalArgumentException {
        String dateStr = dslDateStr.toLowerCase().endsWith("d") ? dslDateStr.substring(0, dslDateStr.length() - 1) : dslDateStr;
        LocalDate localDate = LocalDate.parse(dateStr, DATE_FORMATER_DSL);
        return Date.from(localDate.atStartOfDay(defaultZoneId).toInstant());
    }
}

