/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractBlockSyntaxControl;
import fr.cnav.saturne.validator.syntax.MessageExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Cst08SyntaxControl
extends AbstractBlockSyntaxControl {
    private final String aBlockFullQualifiedId;
    private final StandardDescription aStandard;

    public Cst08SyntaxControl(int id, String code, BlockDescription target, String blockFullQualifiedId, StandardDescription aStandard, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
        this.aBlockFullQualifiedId = blockFullQualifiedId;
        this.aStandard = aStandard;
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public IRuleResult run(IMessageBlock context) {
        IRuleResult result = IRule.SUCCESS;
        List<BlockDescription> blockList = this.getAllBlockInStandard();
        boolean exists = false;
        for (BlockDescription bundleSubGroup : blockList) {
            if (bundleSubGroup.getFullQualifiedId() == null || !bundleSubGroup.getFullQualifiedId().equals(this.aBlockFullQualifiedId)) continue;
            exists = true;
        }
        if (!exists) {
            IMessageField<?> firstFiedInContext = MessageExtractor.getFirstField(context);
            String message = this.controlMessage.getMessage("syntactic.messages.CST08", new Object[]{this.aBlockFullQualifiedId});
            result = new RuleFailure(this, firstFiedInContext, firstFiedInContext.getParent(), message);
        }
        return result;
    }

    private List<BlockDescription> getAllBlockInStandard() {
        ArrayList<BlockDescription> result = new ArrayList<BlockDescription>();
        result.addAll(this.getAllBlockInStandard((BlockDescription)this.aStandard.getMessage().getHeaderBlock()));
        result.addAll(this.getAllBlockInStandard(this.aStandard.getMessage().getFooterBlock()));
        return result;
    }

    private List<BlockDescription> getAllBlockInStandard(BlockDescription block) {
        ArrayList<BlockDescription> result = new ArrayList<BlockDescription>();
        result.add(block);
        for (BlockDescription block2 : block.getChildrenBlocks()) {
            result.addAll(this.getAllBlockInStandard(block2));
        }
        return result;
    }
}

