/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.impl.IDSNExportProvider;
import java.util.List;
import java.util.TreeMap;

public class DSNExportProvider
implements IDSNExportProvider {
    private static final int EIGHT = 8;
    private static final int SEVEN = 7;
    private static final String EMPLOYEE_LABEL_1 = "Nom";
    private static final String EMPLOYEE_LABEL_2 = "Pr\u00e9nom";
    private static final String EMPLOYEE_LABEL_3 = "Nom d'usage";
    private static final String EMPLOYEE_LABEL_4 = "NIR / Mat";
    private static final String EMPLOYEE_SUBGROUP_LABEL = "Salari\u00e9s";
    private static final String SEPARATOR = "/";
    private final IReportLogger reportLogger;
    private String siret;

    public DSNExportProvider(IReportLogger reportLogger) {
        this.reportLogger = reportLogger;
    }

    @Override
    public TreeMap<Integer, Object> getExportData(Object anomalie, boolean isDeclarationAnomaly) {
        if (anomalie instanceof Anomaly && isDeclarationAnomaly) {
            return this.getExportDataDeclarationAnomaly((Anomaly)anomalie);
        }
        if (anomalie instanceof Anomaly && !isDeclarationAnomaly) {
            return this.getExportDataEnvoiAnomaly((Anomaly)anomalie);
        }
        return new TreeMap<Integer, Object>();
    }

    protected TreeMap<Integer, Object> getExportDataEnvoiAnomaly(Anomaly envoiAnomaly) {
        return this.getExportValues(envoiAnomaly);
    }

    protected TreeMap<Integer, Object> getExportDataDeclarationAnomaly(Anomaly declAnomaly) {
        return this.getExportValues(declAnomaly);
    }

    protected TreeMap<Integer, Object> getExportValues(Anomaly anomaly) {
        TreeMap<Integer, Object> intToValue = new TreeMap<Integer, Object>();
        intToValue.put(0, anomaly.getCode() != null ? anomaly.getCode() : "");
        intToValue.put(1, anomaly.getFieldId() != null ? anomaly.getFieldId() : "");
        intToValue.put(2, anomaly.getFieldLabel() != null ? anomaly.getFieldLabel() : "");
        intToValue.put(3, anomaly.getFieldValue() != null ? anomaly.getFieldValue() : "");
        intToValue.put(4, String.valueOf(anomaly.getFieldLocalizer().getLineNumber()) != null ? String.valueOf(anomaly.getFieldLocalizer().getLineNumber()) : "");
        intToValue.put(5, String.valueOf(anomaly.getFieldLocalizer().getLineNumber()) != null ? String.valueOf(anomaly.getNumber()) : "");
        intToValue.put(6, anomaly.getMessage() != null ? anomaly.getMessage() : "");
        return intToValue;
    }

    @Override
    public TreeMap<Integer, Object> getHeaderExportDataFromSalarieContext(Context employeeContext) {
        if (employeeContext == null) {
            return this.getHeaderExportValues();
        }
        return this.getExportHeaderSalarieData(employeeContext);
    }

    @Override
    public TreeMap<Integer, Object> getHeaderExportData(Context declaration) {
        if (declaration == null) {
            return this.getHeaderExportValues();
        }
        return this.getExportHeaderDeclarationAnomalieData(declaration);
    }

    protected TreeMap<Integer, Object> getExportHeaderDeclarationAnomalieData(Context declaration) {
        List<ContextField> secondLevelFieldContexts = declaration.getContextFields();
        TreeMap<Integer, Object> intToValue = new TreeMap<Integer, Object>();
        intToValue.put(0, declaration.getRank());
        for (ContextField secondLevelContext : secondLevelFieldContexts) {
            if ("nature".equals(secondLevelContext.getReportSerializationName())) {
                intToValue.put(1, secondLevelContext.getValue());
                continue;
            }
            if ("type".equals(secondLevelContext.getReportSerializationName())) {
                intToValue.put(2, secondLevelContext.getValue());
                continue;
            }
            if ("SIREN".equals(secondLevelContext.getReportSerializationName())) {
                intToValue.put(3, secondLevelContext.getValue());
                continue;
            }
            if (!"nic_siege".equals(secondLevelContext.getReportSerializationName())) continue;
            intToValue.put(4, secondLevelContext.getValue());
        }
        return intToValue;
    }

    protected TreeMap<Integer, Object> getExportHeaderSalarieData(Context thirdLevelContext) {
        TreeMap<Integer, Object> intToValue = new TreeMap<Integer, Object>();
        intToValue.put(0, EMPLOYEE_SUBGROUP_LABEL);
        intToValue.put(1, EMPLOYEE_LABEL_1);
        intToValue.put(2, EMPLOYEE_LABEL_2);
        intToValue.put(3, EMPLOYEE_LABEL_3);
        intToValue.put(4, EMPLOYEE_LABEL_4);
        intToValue.put(5, "");
        intToValue.put(6, "");
        intToValue.put(7, "");
        intToValue.put(8, "");
        List<ContextField> thirdLevelContexts = thirdLevelContext.getContextFields();
        String nir = "";
        String matricule = "";
        for (ContextField thirdLevelFieldContext : thirdLevelContexts) {
            if ("nom_famille".equals(thirdLevelFieldContext.getReportSerializationName())) {
                intToValue.put(5, thirdLevelFieldContext.getValue());
                continue;
            }
            if ("prenoms".equals(thirdLevelFieldContext.getReportSerializationName())) {
                intToValue.put(6, thirdLevelFieldContext.getValue());
                continue;
            }
            if ("nom_usage".equals(thirdLevelFieldContext.getReportSerializationName())) {
                intToValue.put(7, thirdLevelFieldContext.getValue());
                continue;
            }
            if ("NIR".equals(thirdLevelFieldContext.getReportSerializationName())) {
                nir = thirdLevelFieldContext.getValue();
                continue;
            }
            if (!"matricule".equals(thirdLevelFieldContext.getReportSerializationName())) continue;
            matricule = thirdLevelFieldContext.getValue();
        }
        intToValue.put(8, String.valueOf(nir) + SEPARATOR + matricule);
        return intToValue;
    }

    public String getIndividualValue(IMessageBlock msgBlock, List<String> employeeFieldsQualifiedIds) {
        String finalValue = "";
        if (msgBlock != null && employeeFieldsQualifiedIds != null) {
            String individualValue = this.getIndividualValue(msgBlock, employeeFieldsQualifiedIds.get(0));
            if (individualValue != null) {
                finalValue = String.valueOf(finalValue) + individualValue;
            }
            if (employeeFieldsQualifiedIds.size() >= 2) {
                finalValue = String.valueOf(finalValue) + SEPARATOR;
                individualValue = this.getIndividualValue(msgBlock, employeeFieldsQualifiedIds.get(1));
                if (individualValue != null) {
                    finalValue = String.valueOf(finalValue) + individualValue;
                }
            }
            return finalValue;
        }
        return "";
    }

    public String getIndividualValue(IMessageBlock individualMsgBlock, String employeeFieldQualifiedId) {
        String resultValue = null;
        if (individualMsgBlock != null && employeeFieldQualifiedId != null) {
            List<List<IMessageBlock>> children = individualMsgBlock.getChildren();
            for (List<IMessageBlock> list : children) {
                for (IMessageBlock messageBlock : list) {
                    List<IMessageField<?>> fields = messageBlock.getFields();
                    for (IMessageField<?> messageField : fields) {
                        if (employeeFieldQualifiedId.equals(messageField.getStandardFieldDescription().getFullQualifiedId())) {
                            return messageField.getValueAsString();
                        }
                        resultValue = this.getIndividualValue(messageBlock, employeeFieldQualifiedId);
                        if (resultValue == null) continue;
                        return resultValue;
                    }
                }
            }
        }
        return resultValue;
    }

    public TreeMap<Integer, Object> getHeaderExportValues() {
        TreeMap<Integer, Object> intToValue = new TreeMap<Integer, Object>();
        intToValue.put(0, this.reportLogger.getReport().getValidationId());
        intToValue.put(1, this.getState(this.getBlockingAnomalyNumber(this.reportLogger.getReport().getRootContext())));
        intToValue.put(2, String.valueOf(this.reportLogger.getAnomaliesNumber()));
        intToValue.put(3, String.valueOf(this.reportLogger.getReport().getRootContext().getContextChildren().size()));
        intToValue.put(4, String.valueOf(this.getThirdLevelContextNumber(this.reportLogger.getReport().getRootContext())));
        intToValue.put(5, this.getSiret(this.reportLogger.getReport().getRootContext()) != null ? this.getSiret(this.reportLogger.getReport().getRootContext()) : "");
        return intToValue;
    }

    private String getSiret(Context rootContext) {
        if (this.siret != null) {
            return this.siret;
        }
        String siren = "";
        String nic = "";
        List<ContextField> contextFields = rootContext.getContextFields();
        for (ContextField contextField : contextFields) {
            if ("siren".equals(contextField.getReportSerializationName())) {
                siren = contextField.getValue();
                continue;
            }
            if (!"nic".equals(contextField.getReportSerializationName())) continue;
            nic = contextField.getValue();
        }
        this.siret = String.valueOf(siren) + nic;
        return this.siret;
    }

    private int getThirdLevelContextNumber(Context rootContext) {
        List<Context> secondLevelContexts = rootContext.getContextChildren();
        int thirdLevelContextNumber = 0;
        for (Context secondLevelContext : secondLevelContexts) {
            thirdLevelContextNumber += secondLevelContext.getContextChildren().size();
        }
        return thirdLevelContextNumber;
    }

    public String getState(int nb) {
        if (nb > 0) {
            return "KO";
        }
        return "OK";
    }

    private int getBlockingAnomalyNumber(Context context) {
        int blockingAnomaliesNumber = 0;
        List<Anomaly> anomalies = context.getAnomalies();
        for (Anomaly anomaly : anomalies) {
            blockingAnomaliesNumber += anomaly.getNumber();
        }
        List<Context> subContextChildren = context.getContextChildren();
        for (Context subContext : subContextChildren) {
            blockingAnomaliesNumber += this.getBlockingAnomalyNumber(subContext);
        }
        return blockingAnomaliesNumber;
    }

    @Override
    public TreeMap<Integer, Object> getFooterExportData(Object objet) {
        return new TreeMap<Integer, Object>();
    }
}

