/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.report.model.Report;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.ReportContextCalculationException;
import fr.cnav.saturne.validator.report.ReportContextHandler;
import fr.cnav.saturne.validator.report.impl.ReportContextDescriptor;
import fr.cnav.saturne.validator.xml.XMLReader;
import java.io.InputStream;
import java.util.Map;

public class ReportContextCalculator {
    private final ReportContextDescriptor reportContextDescriptor;
    private final StandardAccessor modelAccessor;
    private final InputStream messageConvertedInputStream;

    public ReportContextCalculator(StandardAccessor modelAccessor, ReportContextDescriptor reportContextDescriptor, InputStream messageConvertedInputStream) {
        this.reportContextDescriptor = reportContextDescriptor;
        this.modelAccessor = modelAccessor;
        this.messageConvertedInputStream = messageConvertedInputStream;
    }

    public void calculateReportContexts(IReportLogger reportLogger, Map<String, String> xmlTag2QualifiedId, boolean xmlNoPrefix) {
        try {
            Report report = reportLogger.getReport();
            if (report != null && report.getRootContext() != null) {
                if (report.getRootContext().getAnomalies().size() <= 0 || !"99".equals(report.getRootContext().getAnomalies().get(report.getRootContext().getAnomalies().size() - 1).getCode())) {
                    if (this.reportContextDescriptor.doAddValidationIdContext() && report.getValidationId() != null) {
                        report.getRootContext().addContextField(new ContextField("validationID", report.getValidationId()));
                    }
                    if (this.reportContextDescriptor.doAddValidationTimeStampContext() && report.getValidationTimeStamp() != null) {
                        report.getRootContext().addContextField(new ContextField("validation_execution_date", report.getValidationTimeStamp()));
                    }
                }
                XMLReader xmlReader = new XMLReader(reportLogger, new OptionMap(), this.modelAccessor, xmlTag2QualifiedId, new ControlMessages(null), false, xmlNoPrefix);
                ReportContextHandler reportContextHandler = new ReportContextHandler(this.reportContextDescriptor, report);
                xmlReader.addConsumer(reportContextHandler);
                xmlReader.read(this.messageConvertedInputStream);
            }
        }
        catch (Exception e) {
            throw new ReportContextCalculationException("An exception occurred during the context information recuperation.", e);
        }
    }
}

