/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.registry.norm.impl;

import fr.cnav.saturne.validator.registry.ExceptionRegistryKind;
import fr.cnav.saturne.validator.registry.INormSerializerRegistry;
import fr.cnav.saturne.validator.registry.NormRegistryException;
import fr.cnav.saturne.validator.report.IReportSerializer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class NormSerializerRegistryImpl
implements INormSerializerRegistry {
    private String normLabel;
    private String serializerLabel;
    private String serializerContentType;
    private String serializerExtension;
    private IConfigurationElement normConfigurationElement;
    private String serializerClassName;

    public NormSerializerRegistryImpl(IConfigurationElement normConfigurationElement, String normLabel) {
        this.normConfigurationElement = normConfigurationElement;
        this.normLabel = normLabel;
        this.serializerClassName = normConfigurationElement.getAttribute("serializerClass");
    }

    @Override
    public String getLabel() {
        if (this.serializerLabel == null) {
            this.serializerLabel = this.normConfigurationElement.getAttribute("label");
        }
        return this.serializerLabel;
    }

    @Override
    public String getSerializerClassName() {
        return this.serializerClassName;
    }

    @Override
    public String getContentType() {
        if (this.serializerContentType == null) {
            this.serializerContentType = this.normConfigurationElement.getAttribute("contentType");
        }
        return this.serializerContentType;
    }

    @Override
    public String getExtension() {
        if (this.serializerExtension == null) {
            this.serializerExtension = this.normConfigurationElement.getAttribute("extension");
        }
        return this.serializerExtension;
    }

    @Override
    public IReportSerializer getNewIReportSerializer() throws NormRegistryException {
        Object o = null;
        IReportSerializer normSerializer = null;
        try {
            o = this.normConfigurationElement.createExecutableExtension("serializerClass");
        }
        catch (CoreException e) {
            throw new NormRegistryException(ExceptionRegistryKind.ERROR_CANNOT_INSTANCIATE_SERIALIZER, (Throwable)e, this.normLabel);
        }
        if (!(o instanceof IReportSerializer)) {
            throw new NormRegistryException(ExceptionRegistryKind.ERROR_CLASS_INSTANCIATED_IS_NOT_SERIALIZER, this.normLabel);
        }
        normSerializer = (IReportSerializer)o;
        return normSerializer;
    }
}

