/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.custom;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.validator.positional.EmptyDefinition;
import fr.cnav.saturne.validator.positional.FieldSpecification;
import fr.cnav.saturne.validator.positional.FooterSpecification;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.HeaderSpecification;
import fr.cnav.saturne.validator.positional.RecordIdSpecification;
import fr.cnav.saturne.validator.positional.RecordSpecification;
import fr.cnav.saturne.validator.positional.util.PositionalValidator;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class PositionalValidatorCustom
extends PositionalValidator {
    private static final String SPACE = " ";
    private static final String MESSAGE_VALIDATION_FORMAT_SPECIFICATION_END_POSITION_INVALID = "The FormatSpecification record end position should be greater than start position";
    private static final String MESSAGE_VALIDATION_FORMAT_SPECIFICATION_START_POSITION_INVALID = "The FormatSpecification record start position should be greater than 0 or equals to -1";
    private static final String MESSAGE_VALIDATION_RECORD_SPECIFICATION_SAME_RECORD_TYPE = "The Format specification element contains at least two RecordSpecification concerning a same record type. This is forbidden.";
    private static final String MESSAGE_VALIDATION_FOOTER_SPECIFICATION_SAME_CALCULATED_FIELD_TYPE = "The FormatSpecification element contains at least two FooterSpecification concerning a same type of calculated field. This is forbidden.";
    private static final String MESSAGE_VALIDATION_HEADER_SPECIFICATION_SAME_CALCULATED_FIELD_TYPE = "The FormatSpecification element contains at least two HeaderSpecification concerning a same type of calculated field. This is forbidden.";
    private static final String MESSAGE_VALIDATION_ABSENT_DEFINITION_SAME_DATATYPE = "The Format specification element contains at least two AbsentDefinition concerning a same data type. This is forbidden.";
    private static final String MESSAGE_VALIDATION_FIELD_SPECIFICATION_START_POSITION_INVALID = "The FieldSpecification' start position should be greater than 0. ";
    private static final String MESSAGE_VALIDATION_FIELD_SPECIFICATION_END_POSITION_INVALID = "The FieldSpecification's end position should be greater than start position";
    private static final String MESSAGE_VALIDATION_FIELD_SPECIFICATION_END_POSITION_OUT_OF_BOUNDS = "The FieldSpecification's end position should be lesser or equals than record's length+1";
    private static final String MESSAGE_VALIDATION_FIELD_SPECIFICATION_INVALID_FIELD = "The FieldSpecification's field is not contained in the record Specification's block.";
    private static final String MESSAGE_VALIDATION_FIELD_SPECIFICATION_INVALID_FORMAT = "The FieldSpecification's position is not consistent with length of field's datatype.";
    private static final String MESSAGE_VALIDATION_RECORD_SPECIFICATION_LENGTH_INCLUDES_RECORD_POSITION = "The RecordSpecification element has a length that cannot contains the RecordIdSpecification positions.";
    private static final String MESSAGE_VALIDATION_NO_FIELD_POSITION_OVERLAPPING = "The RecordSpecification element contains fields with overlapping positions.";
    private static final String MESSAGE_VALIDATION_RECORD_ID_POSITION_OVERLAPPING = "The FormatSpecficiation element contains RecordIdSpecification with overlapping positions.";
    private static final String MESSAGE_VALIDATION_FORMAT_SPECIFICATION_END_POSITION_INVALID_2 = "The FormatSpecification record end position should be greater than 0 or equals to -1";
    private static final String MESSAGE_VALIDATION_RECORD_SPECIFICATION_INVALID_RECORD_TYPE_REGEX = "The record type regex of the RecordSpecification is not valid.";
    private static final String MESSAGE_VALIDATION_SAME_FIELD_ID_ERROR = "Two field specifications share the same id which is forbidden. The id is the following : ";
    private static final String MESSAGE_VALIDATION_SAME_RECORD_ID_ERROR = "Two record specifications share the same id which is forbidden. The id is the following : ";
    private static final String MESSAGE_VALIDATION_TRIM_CHAR_ERROR = "The format Specification has a trimmingCharacter which is not a character.";
    private static final String MESSAGE_VALIDATION_SOME_RECORDID_NOT_DEFINED_AFTER_FIRST_ONE = "The format Specification can not have some recordIdSpecification with end position equals to -1 if the first RecordSpecification is well defined.";
    private static final String MESSAGE_VALIDATION_MULTIPLE_RECORD_AND_ONE_RECORDID_NOT_DEFINED = "The format Specification can not have multiple recordSpecification and only one recordIdSpecification with end position equals to -1.";
    private static final String MESSAGE_VALIDATION_RECORD_SPECIFICATION_NO_RECORD_TYPE_REGEX = "The record specification has no record type regex. It is forbidden.";
    private static final String MESSAGE_VALIDATION_FORMAT_SPECIFICATION_NO_FORMAT_NAME = "The format specification has no format name set. It is forbidden.";
    private static final String MESSAGE_VALIDATION_FORMAT_SPECIFICATION_NO_FILE_EXTENSION = "The format specification has no file extension set. It is forbidden.";

    @Override
    public boolean validateFormatSpecification_noAbsentDefinitionsWithSameNature(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        EmptyDefinition firstFaultyEmptyDefinition = null;
        EList<EmptyDefinition> emptyDefinitions = formatSpecification.getEmptyDefinitions();
        for (EmptyDefinition emptyDefinition1 : emptyDefinitions) {
            for (EmptyDefinition emptyDefinition2 : emptyDefinitions) {
                if (emptyDefinition2 == emptyDefinition1 || emptyDefinition1.getNature() == null || !emptyDefinition1.getNature().equals((Object)emptyDefinition2.getNature())) continue;
                isValid = false;
                firstFaultyEmptyDefinition = emptyDefinition1;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_ABSENT_DEFINITION_SAME_DATATYPE, new Object[]{firstFaultyEmptyDefinition});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFormatSpecification_noHeaderSpecificationsWithSameValue(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        EList<HeaderSpecification> headerSpecifications = formatSpecification.getHeaderSpecifications();
        HeaderSpecification firstFaultyHeader = null;
        for (HeaderSpecification headerSpecifications1 : headerSpecifications) {
            for (HeaderSpecification headerSpecifications2 : headerSpecifications) {
                if (headerSpecifications2 == headerSpecifications1 || headerSpecifications1.getCalculatedFieldType() == null || !headerSpecifications1.getCalculatedFieldType().equals((Object)headerSpecifications2.getCalculatedFieldType())) continue;
                isValid = false;
                firstFaultyHeader = headerSpecifications1;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_HEADER_SPECIFICATION_SAME_CALCULATED_FIELD_TYPE, new Object[]{firstFaultyHeader});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFormatSpecification_noFooterSpecificationsWithSameValue(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        EList<FooterSpecification> footerSpecifications = formatSpecification.getFooterSpecifications();
        FooterSpecification firstFaultyFooter = null;
        for (FooterSpecification footerSpecifications1 : footerSpecifications) {
            for (FooterSpecification footerSpecifications2 : footerSpecifications) {
                if (footerSpecifications2 == footerSpecifications1 || footerSpecifications1.getCalculatedFieldType() == null || !footerSpecifications1.getCalculatedFieldType().equals((Object)footerSpecifications2.getCalculatedFieldType())) continue;
                isValid = false;
                firstFaultyFooter = footerSpecifications1;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_FOOTER_SPECIFICATION_SAME_CALCULATED_FIELD_TYPE, new Object[]{firstFaultyFooter});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFormatSpecification_noDuplicatedBlock(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        RecordSpecification recordSpecification = null;
        Iterator recordIte1 = formatSpecification.getRecords().iterator();
        while (recordIte1.hasNext() && isValid) {
            recordSpecification = (RecordSpecification)recordIte1.next();
            Iterator recordIte2 = formatSpecification.getRecords().iterator();
            while (recordIte2.hasNext() && isValid) {
                RecordSpecification recordSpecification2 = (RecordSpecification)recordIte2.next();
                if (recordSpecification == recordSpecification2 || !this.haveTheSameBlockReferenced(recordSpecification, recordSpecification2)) continue;
                isValid = false;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)recordSpecification, context)) + SPACE + MESSAGE_VALIDATION_SAME_RECORD_ID_ERROR, new Object[]{recordSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFormatSpecification_noStringAtTrimmingCharacter(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        String trimmingCharacter = formatSpecification.getTrimmingCharacter();
        if (trimmingCharacter != null && !trimmingCharacter.isEmpty()) {
            boolean bl = isValid = trimmingCharacter.length() == 1;
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_TRIM_CHAR_ERROR, new Object[]{formatSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFormatSpecification_noRecordIdSpecNotDefinedAfterFirstOneGood(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        EList<RecordIdSpecification> idSpecifications = formatSpecification.getIdSpecifications();
        if (idSpecifications.size() > 1 && ((RecordIdSpecification)idSpecifications.get(0)).getRecordTypeEndPosition() != -1) {
            int i = 1;
            while (i < idSpecifications.size()) {
                if (((RecordIdSpecification)idSpecifications.get(i)).getRecordTypeEndPosition() == -1) {
                    isValid = false;
                }
                ++i;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_SOME_RECORDID_NOT_DEFINED_AFTER_FIRST_ONE, new Object[]{formatSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFormatSpecification_noMultipleRecordWithOneRecordIdNotDefined(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        EList<RecordIdSpecification> idSpecifications = formatSpecification.getIdSpecifications();
        if (!idSpecifications.isEmpty() && ((RecordIdSpecification)idSpecifications.get(0)).getRecordTypeEndPosition() == -1) {
            boolean bl = isValid = formatSpecification.getRecords().size() <= 1;
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_MULTIPLE_RECORD_AND_ONE_RECORDID_NOT_DEFINED, new Object[]{formatSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    private boolean haveTheSameBlockReferenced(RecordSpecification record1, RecordSpecification record2) {
        if (record1 != null && record2 != null) {
            Block block1 = record1.getBlock();
            Block block2 = record2.getBlock();
            if (block1 != null && block2 != null) {
                String idBlock1 = block1.getId();
                String idBlock2 = block2.getId();
                if (idBlock1 != null && idBlock2 != null) {
                    return idBlock1.equals(idBlock2);
                }
            }
        }
        return false;
    }

    @Override
    public boolean validateRecordSpecification_noDuplicatedField(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        FieldSpecification fieldSpecification = null;
        Iterator fieldIte1 = recordSpecification.getFields().iterator();
        while (fieldIte1.hasNext() && isValid) {
            fieldSpecification = (FieldSpecification)fieldIte1.next();
            Iterator fieldIte2 = recordSpecification.getFields().iterator();
            while (fieldIte2.hasNext() && isValid) {
                FieldSpecification fieldSpecification2 = (FieldSpecification)fieldIte2.next();
                if (fieldSpecification == fieldSpecification2 || !this.haveTheSameFieldReferenced(fieldSpecification, fieldSpecification2)) continue;
                isValid = false;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)recordSpecification, context)) + SPACE + MESSAGE_VALIDATION_SAME_FIELD_ID_ERROR + fieldSpecification.getField().getFullQualifiedId(), new Object[]{fieldSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    private boolean haveTheSameFieldReferenced(FieldSpecification fieldSpecification1, FieldSpecification fieldSpecification2) {
        if (fieldSpecification1 != null && fieldSpecification2 != null) {
            Field field1 = fieldSpecification1.getField();
            Field field2 = fieldSpecification2.getField();
            if (field1 != null && field2 != null) {
                String idField1 = field1.getFullQualifiedId();
                String idField2 = field2.getFullQualifiedId();
                if (idField1 != null && idField2 != null) {
                    return idField1.equals(idField2);
                }
            }
        }
        return false;
    }

    @Override
    public boolean validateRecordSpecification_isRegexRecordTypeValid(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        String recordTypeRegex = recordSpecification.getRecordTypeRegex();
        if (recordTypeRegex != null) {
            try {
                Pattern.compile(recordTypeRegex);
            }
            catch (Exception exception) {
                isValid = false;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)recordSpecification, context)) + SPACE + MESSAGE_VALIDATION_RECORD_SPECIFICATION_INVALID_RECORD_TYPE_REGEX, new Object[]{recordSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFormatSpecification_noRecordSpecificaionWithSameRecordType(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        EList<RecordSpecification> records = formatSpecification.getRecords();
        RecordSpecification firstFaultyRecordSpecification = null;
        for (RecordSpecification recordSpecifications1 : records) {
            for (RecordSpecification recordSpecifications2 : records) {
                if (recordSpecifications2 == recordSpecifications1 || recordSpecifications1.getRecordTypeRegex() == null || !recordSpecifications1.getRecordTypeRegex().equals(recordSpecifications2.getRecordTypeRegex())) continue;
                isValid = false;
                firstFaultyRecordSpecification = recordSpecifications1;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_RECORD_SPECIFICATION_SAME_RECORD_TYPE, new Object[]{firstFaultyRecordSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateRecordIdSpecification_validRecordTypePosition(RecordIdSpecification recordIdSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        String messageValidation = "";
        if (recordIdSpecification.getRecordTypeEndPosition() != -1 || recordIdSpecification.getRecordTypeStartPosition() != -1) {
            if (recordIdSpecification.getRecordTypeStartPosition() <= 0) {
                isValid = false;
                messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)recordIdSpecification, context)) + SPACE + MESSAGE_VALIDATION_FORMAT_SPECIFICATION_START_POSITION_INVALID;
            } else if (recordIdSpecification.getRecordTypeEndPosition() < recordIdSpecification.getRecordTypeStartPosition()) {
                isValid = false;
                messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)recordIdSpecification, context)) + SPACE + MESSAGE_VALIDATION_FORMAT_SPECIFICATION_END_POSITION_INVALID;
            } else if (recordIdSpecification.getRecordTypeEndPosition() <= 0) {
                isValid = false;
                messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)recordIdSpecification, context)) + SPACE + MESSAGE_VALIDATION_FORMAT_SPECIFICATION_END_POSITION_INVALID_2;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, messageValidation, new Object[]{recordIdSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFormatSpecification_validRecordIdSpecification(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        String messageValidation = "";
        EList<RecordIdSpecification> idSpecifications = formatSpecification.getIdSpecifications();
        Iterator iterator = idSpecifications.iterator();
        RecordIdSpecification recordIdSpecification = null;
        while (iterator.hasNext() && isValid) {
            recordIdSpecification = (RecordIdSpecification)iterator.next();
            Iterator iterator2 = idSpecifications.iterator();
            while (iterator2.hasNext() && isValid) {
                RecordIdSpecification recordIdSpecification2 = (RecordIdSpecification)iterator2.next();
                if (!this.checkRecIdSpec(recordIdSpecification, recordIdSpecification2)) continue;
                isValid = false;
                messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_RECORD_ID_POSITION_OVERLAPPING;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, messageValidation, new Object[]{recordIdSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    private boolean checkRecIdSpec(RecordIdSpecification recIdSpec1, RecordIdSpecification recIdSpec2) {
        return recIdSpec1 != recIdSpec2 && (recIdSpec2.getRecordTypeStartPosition() <= recIdSpec1.getRecordTypeStartPosition() && recIdSpec2.getRecordTypeEndPosition() >= recIdSpec1.getRecordTypeStartPosition() || recIdSpec2.getRecordTypeStartPosition() <= recIdSpec1.getRecordTypeEndPosition() && recIdSpec2.getRecordTypeEndPosition() >= recIdSpec1.getRecordTypeEndPosition());
    }

    @Override
    public boolean validateFieldSpecification_validPosition(FieldSpecification fieldSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        String messageValidation = "";
        if (fieldSpecification.getStartPosition() <= 0) {
            isValid = false;
            messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)fieldSpecification, context)) + SPACE + MESSAGE_VALIDATION_FIELD_SPECIFICATION_START_POSITION_INVALID;
        } else if (fieldSpecification.getEndPosition() < fieldSpecification.getStartPosition()) {
            isValid = false;
            messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)fieldSpecification, context)) + SPACE + MESSAGE_VALIDATION_FIELD_SPECIFICATION_END_POSITION_INVALID;
        } else if (fieldSpecification.getEndPosition() > ((RecordSpecification)fieldSpecification.eContainer()).getRecordLength()) {
            isValid = false;
            messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)fieldSpecification, context)) + SPACE + MESSAGE_VALIDATION_FIELD_SPECIFICATION_END_POSITION_OUT_OF_BOUNDS;
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, messageValidation, new Object[]{fieldSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFieldSpecification_validField(FieldSpecification fieldSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        RecordSpecification recordSpecification;
        Block block;
        boolean isValid = true;
        Field field = fieldSpecification.getField();
        if (field != null && (block = (recordSpecification = (RecordSpecification)fieldSpecification.eContainer()).getBlock()) != null) {
            isValid = block.getChildrenFields().contains((Object)field);
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, MESSAGE_VALIDATION_FIELD_SPECIFICATION_INVALID_FIELD, new Object[]{fieldSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFieldSpecification_validFormat(FieldSpecification fieldSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int maxLength;
        int startPosition = fieldSpecification.getStartPosition();
        int endPosition = fieldSpecification.getEndPosition();
        int stringLength = endPosition - startPosition + 1;
        if (stringLength != (maxLength = fieldSpecification.getField().getDataType().getMaxLength())) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, MESSAGE_VALIDATION_FIELD_SPECIFICATION_INVALID_FORMAT, new Object[]{fieldSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateRecordSpecification_recordLengthIncludesRecordTypePosition(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        String messageValidation = "";
        FormatSpecification formatSpecification = (FormatSpecification)recordSpecification.eContainer();
        Iterator iterator = formatSpecification.getIdSpecifications().iterator();
        while (iterator.hasNext() && isValid) {
            RecordIdSpecification recordIdSpecification = (RecordIdSpecification)iterator.next();
            if (recordSpecification.getRecordLength() >= recordIdSpecification.getRecordTypeEndPosition()) continue;
            isValid = false;
            messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)recordSpecification, context)) + SPACE + MESSAGE_VALIDATION_RECORD_SPECIFICATION_LENGTH_INCLUDES_RECORD_POSITION;
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, messageValidation, new Object[]{recordSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateRecordSpecification_validateAttributeCardinality(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        String messageValidation = "";
        if (recordSpecification.getRecordTypeRegex() == null || "".equals(recordSpecification.getRecordTypeRegex())) {
            isValid = false;
            messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)recordSpecification, context)) + SPACE + MESSAGE_VALIDATION_RECORD_SPECIFICATION_NO_RECORD_TYPE_REGEX;
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, messageValidation, new Object[]{recordSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateFormatSpecification_validateAttributeCardinality(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        String messageValidation = "";
        if (formatSpecification.getFormatName() == null || "".equals(formatSpecification.getFormatName())) {
            isValid = false;
            messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_FORMAT_SPECIFICATION_NO_FORMAT_NAME;
        } else if (formatSpecification.getFileExtension() == null || "".equals(formatSpecification.getFileExtension())) {
            isValid = false;
            messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)formatSpecification, context)) + SPACE + MESSAGE_VALIDATION_FORMAT_SPECIFICATION_NO_FILE_EXTENSION;
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, messageValidation, new Object[]{formatSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validateRecordSpecification_noOverlappingOfFieldPositionForRecord(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        FieldSpecification fieldSpecification = null;
        String messageValidation = "";
        Iterator fieldIterator = recordSpecification.getFields().iterator();
        while (fieldIterator.hasNext() && isValid) {
            fieldSpecification = (FieldSpecification)fieldIterator.next();
            for (FieldSpecification fieldSpecification2 : recordSpecification.getFields()) {
                if (!this.checkFieldSepcValid(fieldSpecification, fieldSpecification2)) continue;
                isValid = false;
                messageValidation = String.valueOf(PositionalValidatorCustom.getObjectLabel((EObject)fieldSpecification, context)) + SPACE + MESSAGE_VALIDATION_NO_FIELD_POSITION_OVERLAPPING;
            }
        }
        if (!isValid) {
            if (diagnostics != null) {
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "fr.cnav.saturne.validator.positional", 0, messageValidation, new Object[]{fieldSpecification});
                diagnostics.add((Diagnostic)basicDiagnostic);
            }
            return false;
        }
        return true;
    }

    private boolean checkFieldSepcValid(FieldSpecification fieldSpec1, FieldSpecification fieldSpec2) {
        return fieldSpec1 != fieldSpec2 && (fieldSpec2.getStartPosition() <= fieldSpec1.getStartPosition() && fieldSpec2.getEndPosition() >= fieldSpec1.getStartPosition() || fieldSpec2.getStartPosition() <= fieldSpec1.getEndPosition() && fieldSpec2.getEndPosition() >= fieldSpec1.getEndPosition());
    }
}

