/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.csv;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import fr.cnav.saturne.validator.positional.csv.Encoding;
import java.io.IOException;
import java.io.InputStream;

public class CharsetUtils {
    public static final int MAX_ASCII_CODE = 127;
    private static final String UTF8 = "UTF-8";
    private static final String ISO8859 = "ISO-8859";
    private static final String CP1252 = "CP1252";

    public static boolean isASCII(byte[] text) {
        byte[] byArray = text;
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int intVal = b & 0xFF;
            if (intVal > 127) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static byte[] doubleSize(byte[] array) {
        byte[] result = new byte[array.length * 2];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    private static byte[] readStream(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("input stream can't be null.");
        }
        int i = 0;
        byte[] buffer = new byte[256];
        int value = stream.read();
        while (stream.available() > 0) {
            if (buffer.length == i) {
                buffer = CharsetUtils.doubleSize(buffer);
            }
            buffer[i++] = (byte)value;
            value = (byte)stream.read();
        }
        byte[] result = new byte[i];
        System.arraycopy(buffer, 0, result, 0, i);
        return result;
    }

    public static boolean isUTF8(InputStream input) throws IOException {
        return CharsetUtils.isUTF8(CharsetUtils.readStream(input));
    }

    public static boolean isUTF8(byte[] text) {
        if (CharsetUtils.isASCII(text)) {
            return true;
        }
        CharsetDetector detector = new CharsetDetector();
        detector.setText(text);
        CharsetMatch match = detector.detect();
        return match.getName().equals(UTF8);
    }

    public static boolean isISO8859(InputStream input) throws IOException {
        return CharsetUtils.isISO8859(CharsetUtils.readStream(input));
    }

    public static boolean isISO8859(byte[] text) {
        if (CharsetUtils.isASCII(text)) {
            return true;
        }
        CharsetDetector detector = new CharsetDetector();
        detector.setText(text);
        CharsetMatch match = detector.detect();
        return match.getName().startsWith(ISO8859);
    }

    public static boolean isCP1252(InputStream input) throws IOException {
        return CharsetUtils.isCP1252(CharsetUtils.readStream(input));
    }

    public static boolean isCP1252(byte[] text) {
        if (CharsetUtils.isASCII(text)) {
            return true;
        }
        CharsetDetector detector = new CharsetDetector();
        detector.setText(text);
        CharsetMatch match = detector.detect();
        return match.getName().equals(CP1252);
    }

    private static boolean isParamEncoding(byte[] text, Encoding paramEncoding) {
        if (CharsetUtils.isASCII(text)) {
            return true;
        }
        CharsetDetector detector = new CharsetDetector();
        detector.setText(text);
        CharsetMatch match = detector.detect();
        String encodingValue = paramEncoding.getValue();
        return match.getName().equals(encodingValue) || match.getName().startsWith(encodingValue);
    }

    public static Encoding getEncoding(InputStream input) throws IOException {
        return CharsetUtils.getEncoding(CharsetUtils.readStream(input));
    }

    public static Encoding getEncoding(byte[] text) {
        Encoding[] encodingArray = Encoding.values();
        int n = encodingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Encoding p = encodingArray[n2];
            if (CharsetUtils.isParamEncoding(text, p)) {
                return p;
            }
            ++n2;
        }
        return Encoding.getDefault();
    }
}

