/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.conversion;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import fr.cnav.saturne.validator.positional.FieldSpecification;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.RecordIdSpecification;
import fr.cnav.saturne.validator.positional.RecordSpecification;
import fr.cnav.saturne.validator.positional.conversion.PositionalFixSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class PositionalFixStreamSerializer
extends PositionalFixSerializer {
    private RecordSpecification currentRecordSpecification;
    private StringBuffer currentLine;
    private MessageElementDescription currentBlock;
    private List<FieldDescription> visitedFieldDescriptionList = new ArrayList<FieldDescription>();

    public PositionalFixStreamSerializer(Standard theStandard, FormatSpecification theFormatSpecification, OutputStream outputStream, String encoding) throws ConversionSerializationException {
        super(theStandard, theFormatSpecification, outputStream, encoding);
    }

    public PositionalFixStreamSerializer(Standard theStandard, FormatSpecification theFormatSpecification, Writer parent, String encoding) throws ConversionSerializationException {
        super(theStandard, theFormatSpecification, parent, encoding);
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        this.finishWritePreviousBlock();
        this.currentBlock = block.getStandardBlockDescription();
        if (block.getStandardBlockDescription() instanceof BlockDescription) {
            this.currentRecordSpecification = null;
            for (RecordSpecification recordSpecification : this.formatSpecification.getRecords()) {
                if (!recordSpecification.getBlock().getId().equals(block.getStandardBlockDescription().getFullQualifiedId())) continue;
                this.currentRecordSpecification = recordSpecification;
            }
            if (this.currentRecordSpecification == null && !this.blockIsInHeaderOrFooterPxfBlock(block)) {
                throw new TreeProcessingException("The Block " + block.getStandardBlockDescription().getFullQualifiedId() + " has no RecordSpecification and it is not a Header or Footer Block so we can not serialize it.");
            }
            if (this.currentRecordSpecification != null) {
                this.currentLine = this.getCurrentline(block, this.currentRecordSpecification);
                if (this.formatSpecification.getIdExtractorClassName() == null || "".equals(this.formatSpecification.getIdExtractorClassName().trim())) {
                    for (RecordIdSpecification recordIdSpecification : this.formatSpecification.getIdSpecifications()) {
                        String idValue = block.getStandardBlockDescription().getFullQualifiedId();
                        this.currentLine = this.currentLine.replace(recordIdSpecification.getRecordTypeStartPosition() - 1, recordIdSpecification.getRecordTypeStartPosition() - 1 + idValue.length(), idValue);
                    }
                }
                ++this.lineNumber;
            }
        }
    }

    private void finishWritePreviousBlock() throws TreeProcessingException {
        if (this.currentLine != null) {
            if (this.currentBlock instanceof BlockDescription) {
                List fields = ((BlockDescription)this.currentBlock).getFields();
                for (FieldDescription fieldDescription : fields) {
                    if (this.visitedFieldDescriptionList.contains(fieldDescription)) continue;
                    FieldSpecification fieldSpecification = this.getFieldRecord(fieldDescription, this.currentRecordSpecification);
                    this.writeMessageEmptyFieldValue(this.currentLine, fieldSpecification);
                }
            }
            try {
                this.writer.append(this.currentLine);
                String endRecordDelimiter = this.formatSpecification.getEndRecordDelimiter();
                if (endRecordDelimiter == null || "".equals(endRecordDelimiter)) {
                    endRecordDelimiter = "\n";
                }
                this.writer.append(endRecordDelimiter);
            }
            catch (IOException e) {
                throw new TreeProcessingException(e);
            }
        }
        this.currentLine = null;
        this.visitedFieldDescriptionList.clear();
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
        this.signalField(field);
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
        this.signalField(field);
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
        this.signalField(field);
    }

    private void signalField(IMessageField<?> field) throws TreeProcessingException {
        if (field == null) {
            throw new TreeProcessingException("We cannot create field because field parameter is null");
        }
        this.visitedFieldDescriptionList.add(field.getStandardFieldDescription());
        FieldDescription fieldDescription = field.getStandardFieldDescription();
        FieldSpecification fieldSpecification = this.getFieldRecord(fieldDescription, this.currentRecordSpecification);
        this.writeMessageFieldValue(this.currentLine, fieldSpecification, field);
    }

    @Override
    public void endTree() throws TreeProcessingException {
        this.finishWritePreviousBlock();
        super.endTree();
    }
}

