/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.message;

import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;

public final class Operators {
    private static final String SEULE_LA_PREMIERE_VALEUR = ". Seule la premi\u00e8re valeur est prise en compte. La r\u00e8gle DSL est \u00e0 revoir ou le message a une cardinalit\u00e9 erron\u00e9e.";
    private static final String CONTENANT_PLUS_D_UN_ELT = " contenant plus d'un \u00e9l\u00e9ment, et une MessageField de type ";
    private static final String COMPARAISON_ILLEGALE_1 = "Comparaison ill\u00e9gale 'eq' (\u00e9gal) entre une liste d'\u00e9l\u00e9ments de type ";
    private static final String COMPARAISON_ILLEGALE_2 = "Comparaison ill\u00e9gale 'ge' (sup\u00e9rieur ou \u00e9gal) entre une liste d'\u00e9l\u00e9ments de type ";
    private static final String COMPARAISON_ILLEGALE_3 = "Comparaison ill\u00e9gale 'gt' (strictement sup\u00e9rieur) entre une liste d'\u00e9l\u00e9ments de type ";
    private static final String COMPARAISON_ILLEGALE_4 = "Comparaison ill\u00e9gale 'le' (inf\u00e9rieur ou \u00e9gal) entre une liste d'\u00e9l\u00e9ments de type ";
    private static final String COMPARAISON_ILLEGALE_5 = "Comparaison ill\u00e9gale 'lt' (strictement inf\u00e9rieur) entre une liste d'\u00e9l\u00e9ments de type ";
    private static final String COMPARAISON_ILLEGALE_6 = "Comparaison ill\u00e9gale 'neq' (diff\u00e9rent) entre une liste d'\u00e9l\u00e9ments de type ";
    private static final Logger LOGGER = Logger.getLogger("fr.cnav.norme.common.technical.Logger");
    private static final String MESSAGE_SUFFIX = " contenant plus d'un \u00e9l\u00e9ment, et une valeur. Seule la premi\u00e8re valeur est prise en compte. La r\u00e8gle DSL est \u00e0 revoir ou le message a une cardinalit\u00e9 erron\u00e9e.";
    private static final String MESSAGE_BODY = " contenant plus d'un \u00e9l\u00e9ment, et une rubrique de type ";

    private Operators() {
    }

    @Deprecated
    public static boolean implies(boolean a, boolean b) {
        return a ? b : true;
    }

    @Deprecated
    public static boolean equivalent(boolean a, boolean b) {
        return a == b;
    }

    public static <C extends Comparable<C>> boolean eq(IMessageField<C> rub, C value) {
        return rub == null ? false : rub.eq(value);
    }

    public static <T extends Comparable<T>> boolean eq(T value, IMessageField<T> rub) {
        return rub == null ? false : rub.eq(value);
    }

    public static <T extends Comparable<T>> boolean eq(Iterable<? extends IMessageField<? super T>> rub, T value) {
        boolean result = false;
        if (rub != null && rub.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rub.iterator();
            result = it.next().eq(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_1 + it.next().getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean eq(BigDecimal a, BigDecimal b) {
        return a == null ? false : (b == null ? false : a.doubleValue() == b.doubleValue());
    }

    public static boolean ge(BigDecimal a, BigDecimal b) {
        return a == null ? false : (b == null ? false : a.doubleValue() >= b.doubleValue());
    }

    public static boolean gt(BigDecimal a, BigDecimal b) {
        return a == null ? false : (b == null ? false : a.doubleValue() > b.doubleValue());
    }

    public static boolean le(BigDecimal a, BigDecimal b) {
        return a == null ? false : (b == null ? false : a.doubleValue() <= b.doubleValue());
    }

    public static boolean lt(BigDecimal a, BigDecimal b) {
        return a == null ? false : (b == null ? false : a.doubleValue() < b.doubleValue());
    }

    private static boolean decimalIn(BigDecimal value, Collection<? extends BigDecimal> values) {
        boolean result = false;
        if (value == null || values == null) {
            return result;
        }
        for (BigDecimal bigDecimal : values) {
            if (value.doubleValue() != bigDecimal.doubleValue()) continue;
            result = true;
            break;
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean eq(T a, T b) {
        return a == null ? false : (b == null ? false : a.compareTo(b) == 0);
    }

    public static <T extends Comparable<T>> boolean ge(IMessageField<T> rub, T value) {
        return rub == null ? false : rub.ge(value);
    }

    public static <T extends Comparable<T>> boolean ge(T value, IMessageField<T> rub) {
        return Operators.lt(rub, value);
    }

    public static <T extends Comparable<T>> boolean ge(Iterable<? extends IMessageField<? super T>> rub, T value) {
        boolean result = false;
        if (rub != null && rub.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rub.iterator();
            result = it.next().ge(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_2 + it.next().getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean ge(T a, T b) {
        return a == null ? false : (b == null ? false : a.compareTo(b) >= 0);
    }

    public static <T extends Comparable<T>> boolean gt(IMessageField<T> rub, T value) {
        return rub == null ? false : rub.gt(value);
    }

    public static <T extends Comparable<T>> boolean gt(T value, IMessageField<T> rub) {
        return Operators.le(rub, value);
    }

    public static <T extends Comparable<T>> boolean gt(Iterable<? extends IMessageField<? super T>> rub, T value) {
        boolean result = false;
        if (rub != null && rub.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rub.iterator();
            result = it.next().gt(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_3 + it.next().getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean gt(T a, T b) {
        return a == null ? false : (b == null ? false : a.compareTo(b) > 0);
    }

    public static <T extends Comparable<T>> boolean in(IMessageField<T> rub, Collection<?> values) {
        return rub == null ? false : rub.in(values);
    }

    public static boolean in(Object value, Collection<?> values) {
        boolean result = false;
        if (value == null || values == null) {
            return result;
        }
        result = value instanceof BigDecimal ? Operators.decimalIn((BigDecimal)value, values) : values.contains(value);
        return result;
    }

    public static <T extends Comparable<T>> boolean le(IMessageField<T> rub, T value) {
        return rub == null ? false : rub.le(value);
    }

    public static <T extends Comparable<T>> boolean le(T value, IMessageField<T> rub) {
        return Operators.gt(rub, value);
    }

    public static <T extends Comparable<T>> boolean le(Iterable<? extends IMessageField<? super T>> rub, T value) {
        boolean result = false;
        if (rub != null && rub.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rub.iterator();
            result = it.next().le(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_4 + it.next().getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean le(T a, T b) {
        return a == null ? false : (b == null ? false : a.compareTo(b) <= 0);
    }

    public static <T extends Comparable<T>> boolean lt(IMessageField<T> rub, T value) {
        return rub == null ? false : rub.lt(value);
    }

    public static <T extends Comparable<T>> boolean lt(T value, IMessageField<T> rub) {
        return Operators.ge(rub, value);
    }

    public static <T extends Comparable<T>> boolean lt(Iterable<? extends IMessageField<? super T>> rub, T value) {
        boolean result = false;
        if (rub != null && rub.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rub.iterator();
            result = it.next().lt(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_5 + it.next().getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean lt(T a, T b) {
        return a == null ? false : (b == null ? false : a.compareTo(b) < 0);
    }

    public static <T extends Comparable<T>> boolean neq(IMessageField<T> rub, T value) {
        return rub == null ? false : rub.neq(value);
    }

    public static <T extends Comparable<T>> boolean neq(T value, IMessageField<T> rub) {
        return rub == null ? false : rub.neq(value);
    }

    public static <T extends Comparable<T>> boolean neq(Iterable<? extends IMessageField<? super T>> rub, T value) {
        boolean result = false;
        if (rub != null && rub.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rub.iterator();
            result = it.next().neq(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_6 + it.next().getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean neq(T a, T b) {
        return a == null ? false : (b == null ? false : a.compareTo(b) != 0);
    }

    public static <T extends Comparable<T>> boolean eq(IMessageField<T> rub, IMessageField<T> value) {
        return rub == null ? false : rub.eq((T)value);
    }

    public static <T extends Comparable<T>> boolean eq(Iterable<IMessageField<T>> rubs, IMessageField<T> value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rubs.iterator();
            result = it.next().eq((T)value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_1 + it.next().getClass().getSimpleName() + CONTENANT_PLUS_D_UN_ELT + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean eq(Iterable<IMessageFieldNum> rubs, IMessageFieldNum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldNum> it = rubs.iterator();
            result = it.next().eq(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_1 + it.next().getClass().getSimpleName() + CONTENANT_PLUS_D_UN_ELT + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean eq(Iterable<IMessageFieldAlphanum> rubs, IMessageFieldAlphanum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldAlphanum> it = rubs.iterator();
            result = it.next().eq(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_1 + it.next().getClass().getSimpleName() + CONTENANT_PLUS_D_UN_ELT + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean eq(Iterable<IMessageFieldDate> rubs, IMessageFieldDate value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldDate> it = rubs.iterator();
            result = it.next().eq(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_1 + it.next().getClass().getSimpleName() + CONTENANT_PLUS_D_UN_ELT + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean ge(IMessageField<T> rub, IMessageField<T> value) {
        return rub == null ? false : rub.ge((T)value);
    }

    public static boolean ge(Iterable<IMessageFieldNum> rubs, IMessageFieldNum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldNum> it = rubs.iterator();
            result = it.next().ge(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_2 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean ge(Iterable<IMessageFieldAlphanum> rubs, IMessageFieldAlphanum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldAlphanum> it = rubs.iterator();
            result = it.next().ge(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_2 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean ge(Iterable<IMessageFieldDate> rubs, IMessageFieldDate value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldDate> it = rubs.iterator();
            result = it.next().ge(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_2 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean ge(Iterable<IMessageField<T>> rubs, IMessageField<T> value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rubs.iterator();
            result = it.next().ge((T)value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_2 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean gt(IMessageField<T> rub, IMessageField<T> value) {
        return rub == null ? false : rub.gt((T)value);
    }

    public static <T extends Comparable<T>> boolean gt(Iterable<IMessageField<T>> rubs, IMessageField<T> value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rubs.iterator();
            result = it.next().gt((T)value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_3 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean gt(Iterable<IMessageFieldNum> rubs, IMessageFieldNum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldNum> it = rubs.iterator();
            result = it.next().gt(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_3 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean gt(Iterable<IMessageFieldAlphanum> rubs, IMessageFieldAlphanum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldAlphanum> it = rubs.iterator();
            result = it.next().gt(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_3 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean gt(Iterable<IMessageFieldDate> rubs, IMessageFieldDate value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldDate> it = rubs.iterator();
            result = it.next().gt(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_3 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean le(IMessageField<T> rub, IMessageField<T> value) {
        return rub == null ? false : rub.le((T)value);
    }

    public static <T extends Comparable<T>> boolean le(Iterable<IMessageField<T>> rubs, IMessageField<T> value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rubs.iterator();
            result = it.next().le((T)value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_4 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean le(Iterable<IMessageFieldNum> rubs, IMessageFieldNum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldNum> it = rubs.iterator();
            result = it.next().le(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_4 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean le(Iterable<IMessageFieldDate> rubs, IMessageFieldDate value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldDate> it = rubs.iterator();
            result = it.next().le(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_4 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static boolean le(Iterable<IMessageFieldAlphanum> rubs, IMessageFieldAlphanum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldAlphanum> it = rubs.iterator();
            result = it.next().le(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_4 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + MESSAGE_SUFFIX);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean lt(IMessageField<T> rub, IMessageField<T> value) {
        return rub == null ? false : rub.lt((T)value);
    }

    public static <T extends Comparable<T>> boolean lt(Iterable<IMessageField<T>> rubs, IMessageField<T> value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rubs.iterator();
            result = it.next().lt((T)value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_5 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + SEULE_LA_PREMIERE_VALEUR);
            }
        }
        return result;
    }

    public static boolean lt(Iterable<IMessageFieldNum> rubs, IMessageFieldNum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldNum> it = rubs.iterator();
            result = it.next().lt(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_5 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + SEULE_LA_PREMIERE_VALEUR);
            }
        }
        return result;
    }

    public static boolean lt(Iterable<IMessageFieldAlphanum> rubs, IMessageFieldAlphanum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldAlphanum> it = rubs.iterator();
            result = it.next().lt(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_5 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + SEULE_LA_PREMIERE_VALEUR);
            }
        }
        return result;
    }

    public static boolean lt(Iterable<IMessageFieldDate> rubs, IMessageFieldDate value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldDate> it = rubs.iterator();
            result = it.next().lt(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_5 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + SEULE_LA_PREMIERE_VALEUR);
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> boolean neq(IMessageField<T> rub, IMessageField<T> value) {
        return rub == null ? false : rub.neq((T)value);
    }

    public static <T extends Comparable<T>> boolean neq(Iterable<IMessageField<T>> rubs, IMessageField<T> value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageField<T>> it = rubs.iterator();
            result = it.next().neq((T)value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_6 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + SEULE_LA_PREMIERE_VALEUR);
            }
        }
        return result;
    }

    public static boolean neq(Iterable<IMessageFieldNum> rubs, IMessageFieldNum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldNum> it = rubs.iterator();
            result = it.next().neq(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_6 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + SEULE_LA_PREMIERE_VALEUR);
            }
        }
        return result;
    }

    public static boolean neq(Iterable<IMessageFieldAlphanum> rubs, IMessageFieldAlphanum value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldAlphanum> it = rubs.iterator();
            result = it.next().neq(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_6 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + SEULE_LA_PREMIERE_VALEUR);
            }
        }
        return result;
    }

    public static boolean neq(Iterable<IMessageFieldDate> rubs, IMessageFieldDate value) {
        boolean result = false;
        if (rubs != null && rubs.iterator().hasNext()) {
            Iterator<IMessageFieldDate> it = rubs.iterator();
            result = it.next().neq(value);
            if (it.hasNext()) {
                LOGGER.warning(COMPARAISON_ILLEGALE_6 + it.next().getClass().getSimpleName() + MESSAGE_BODY + value.getClass().getSimpleName() + SEULE_LA_PREMIERE_VALEUR);
            }
        }
        return result;
    }

    public static <T> boolean every(Iterable<T> iterable, Predicate<? super T> predicate) {
        return StreamSupport.stream(iterable.spliterator(), false).allMatch(predicate);
    }

    public static <T> boolean everyIterable(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Operators.every(iterable, predicate);
    }

    public static <T> boolean every(T iterable, Predicate<? super T> predicate) {
        return iterable == null ? true : predicate.test(iterable);
    }

    public static <T> boolean some(Iterable<T> iterable, Predicate<? super T> predicate) {
        return StreamSupport.stream(iterable.spliterator(), false).anyMatch(predicate);
    }

    public static <T> boolean someIterable(Iterable<T> iterable, Predicate<? super T> predicate) {
        return Operators.some(iterable, predicate);
    }

    public static <T> boolean some(T element, Predicate<? super T> predicate) {
        return element == null ? false : predicate.test(element);
    }

    public static <T, U> U let(T var, Function<T, U> function) {
        return function.apply(var);
    }
}

