/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.message;

import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.ITreeConsumer;
import fr.cnav.saturne.validator.ITreeProvider;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.declaration.DeclarationListener;
import fr.cnav.saturne.validator.declaration.IDeclarationIdentificationListener;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.util.ArrayList;
import java.util.List;

public class MessageProvider
implements ITreeProvider,
IDeclarationIdentificationListener {
    private List<ITreeConsumer> consumers;
    private DeclarationListener declarationListener;

    public MessageProvider(StandardAccessor modelAccessor) {
        this.declarationListener = new DeclarationListener(modelAccessor);
        this.consumers = new ArrayList<ITreeConsumer>();
        this.addConsumer(this.declarationListener);
        this.declarationListener.addListener(this);
    }

    public void notifiesMessage(IMessageBlock messageBlock) throws TreeProcessingException {
        if (messageBlock == null) {
            throw new IllegalArgumentException("messageBlock must not be null.");
        }
        for (ITreeConsumer consumer : this.consumers) {
            consumer.startTree();
        }
        this.notifiesBeforeRecursive(messageBlock);
        this.notifiesChildBlocks(messageBlock);
        this.notifiesAfterRecursive(messageBlock);
        for (ITreeConsumer consumer : this.consumers) {
            consumer.endTree();
        }
    }

    protected void notifiesBeforeRecursive(IMessageBlock messageBlock) throws TreeProcessingException {
    }

    protected void notifiesAfterRecursive(IMessageBlock messageBlock) throws TreeProcessingException {
    }

    protected void notifiesChildBlocks(IMessageBlock messageBlock) throws TreeProcessingException {
        this.notifiesEnterBlock(messageBlock);
        this.notifiesBlockMessageFields(messageBlock);
        List<List<IMessageBlock>> children = messageBlock.getChildren();
        for (List<IMessageBlock> messageBlockListChild : children) {
            for (IMessageBlock messageBlockChild : messageBlockListChild) {
                this.notifiesChildBlocks(messageBlockChild);
            }
        }
        this.notifiesExitBlock(messageBlock);
    }

    protected void notifiesEnterBlock(IMessageBlock messageBlock) throws TreeProcessingException {
        for (ITreeConsumer consumer : this.consumers) {
            consumer.enterBlock(messageBlock);
        }
    }

    protected void notifiesExitBlock(IMessageBlock messageBlock) throws TreeProcessingException {
        for (ITreeConsumer consumer : this.consumers) {
            consumer.exitBlock(messageBlock);
        }
    }

    protected void notifiesBlockMessageFields(IMessageBlock messageBlock) throws TreeProcessingException {
        List<IMessageField<?>> fields = messageBlock.getFields();
        for (IMessageField<?> messageField : fields) {
            this.notifyMessageField(messageField);
        }
    }

    protected void notifyMessageField(IMessageField<?> messageField) throws TreeProcessingException {
        NatureType nature = this.getFieldNature(messageField);
        switch (nature) {
            case ALPHANUMERIC: 
            case ENUMERATION: 
            case EXTERNAL_REFERENTIAL: {
                for (ITreeConsumer consumer : this.consumers) {
                    consumer.signalAlphanumField((IMessageFieldAlphanum)messageField);
                }
                break;
            }
            case DATE: {
                for (ITreeConsumer consumer : this.consumers) {
                    consumer.signalDateField((IMessageFieldDate)messageField);
                }
                break;
            }
            case NUMERIC: {
                for (ITreeConsumer consumer : this.consumers) {
                    consumer.signalNumericField((IMessageFieldNum)messageField);
                }
                break;
            }
            default: {
                throw new TreeProcessingException(String.valueOf(nature.getName()) + " - " + nature.getLiteral() + " : unknown type nature : shouldn't happen.");
            }
        }
    }

    private NatureType getFieldNature(IMessageField<?> field) throws TreeProcessingException {
        FieldDescription stdField = field.getStandardFieldDescription();
        if (stdField == null) {
            throw new TreeProcessingException("Field of name " + field.getStandardFieldDescription().getFullQualifiedId() + "couldn't be found");
        }
        DataTypeDescription type = stdField.getDataType();
        if (type == null) {
            throw new TreeProcessingException("Field of name " + field.getStandardFieldDescription().getFullQualifiedId() + " has no data type associated.");
        }
        return type.getNature();
    }

    @Override
    public void addConsumer(ITreeConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
        for (ITreeConsumer consumer : this.consumers) {
            if (!(consumer instanceof ITreeAndDeclarationConsumer)) continue;
            ((ITreeAndDeclarationConsumer)consumer).signalDeclaration(block, declaration);
        }
    }
}

