/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.impl;

import fr.cnav.saturne.Standard;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorEncodingHandler {
    private static final String ERROR_MESSAGE_WRONG_ENCODING = "Standard's specified encoding is not valid.";
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public Charset getEncodingToUse(String messagesEncoding, Standard standard) {
        if (messagesEncoding != null) {
            try {
                if (Charset.isSupported(messagesEncoding)) {
                    return Charset.forName(messagesEncoding);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                this.logger.warn(ERROR_MESSAGE_WRONG_ENCODING);
            }
        }
        return this.getEncodingToUse(standard);
    }

    public Charset getEncodingToUse(Standard theStandard) {
        String messagesEncoding = theStandard.getMessagesEncoding();
        if (messagesEncoding != null) {
            try {
                if (Charset.isSupported(messagesEncoding)) {
                    return Charset.forName(messagesEncoding);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                this.logger.warn(ERROR_MESSAGE_WRONG_ENCODING);
            }
        }
        return this.getDefaultEncoding();
    }

    public Charset getDefaultEncoding() {
        return Charset.forName("UTF-8");
    }
}

