/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.impl;

import fr.cnav.saturne.validator.IKBDescriptorFactory;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.impl.KBDescriptorFactoryException;

public class SystemPropertyKBDescriptorFactory
implements IKBDescriptorFactory {
    @Override
    public AbstractKBDescriptor getKBDescriptor() throws KBDescriptorFactoryException {
        String property = System.getProperty("fr.cnav.saturne.validator.kbDescriptor");
        if (property != null && !"".equals(property)) {
            Class<?> descriptorClass = this.loadClass(property);
            return (AbstractKBDescriptor)this.instantiate(descriptorClass);
        }
        throw new KBDescriptorFactoryException("No system property describe the AbstractKBDescriptor to use.");
    }

    public Class<?> loadClass(String className) throws KBDescriptorFactoryException {
        Class<?> result;
        try {
            result = SystemPropertyKBDescriptorFactory.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            String message = "La classe '" + className + " servant de point d'entr\u00e9e de la norme ne peut \u00eatre instanci\u00e9e. V\u00e9rifiez les classpath ou les d\u00e9pendances entre composant.";
            throw new KBDescriptorFactoryException(message, e);
        }
        return result;
    }

    public Object instantiate(Class<?> clazz) throws KBDescriptorFactoryException {
        Object result;
        try {
            result = clazz.newInstance();
        }
        catch (InstantiationException e) {
            String message = "Impossible d'instancier la classe " + clazz.getName() + " : " + e.getMessage();
            throw new KBDescriptorFactoryException(message, e);
        }
        catch (IllegalAccessException e) {
            String message = "Acc\u00e8s \u00e0 la classe " + clazz.getName() + " non autoris\u00e9 : " + e.getMessage();
            throw new KBDescriptorFactoryException(message, e);
        }
        return result;
    }
}

