/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.xml;

import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.DeclarationBlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.MessageDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.IValidationOptions;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.conversion.OriginalValueOptionValue;
import fr.cnav.saturne.validator.conversion.xml.BlockDeclarationAnnotation;
import fr.cnav.saturne.validator.conversion.xml.XMLFormattingException;
import fr.cnav.saturne.validator.conversion.xml.XMLFormattingWriter;
import fr.cnav.saturne.validator.conversion.xml.XMLUtil;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import fr.cnav.saturne.validator.utils.DateUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class XMLSerializer
implements ITreeAndDeclarationConsumer {
    protected final XMLFormattingWriter writer;
    protected final String nameSpace;
    protected final String nameSpacePrefix;
    protected boolean doShowOriginalLineNumber = true;
    protected OriginalValueOptionValue doShowOriginalValue = IValidationOptions.DEFAULT_OUTPUT_ORIGINAL_VALUES;
    private final String messageName;

    public XMLSerializer(StandardDescription theStandard, OutputStream outputStream, String encoding, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber) throws ConversionSerializationException {
        this(theStandard, outputStream, encoding, emitOriginalValue, emitOriginalLineNumber, false);
    }

    public XMLSerializer(StandardDescription theStandard, OutputStream outputStream, String encoding, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber, boolean xmlNoPrefix) throws ConversionSerializationException {
        if (theStandard == null) {
            throw new IllegalArgumentException("The standard should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNamespacePrefix() == null) {
            throw new IllegalArgumentException("The standard namespace prefix should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNameSpace() == null) {
            throw new IllegalArgumentException("The standard namespace should not be null. The serialization will not be realized.");
        }
        if (emitOriginalValue == null) {
            throw new IllegalArgumentException("The emitOriginalValue should not be null. The serialization will not be realized.");
        }
        if (xmlNoPrefix) {
            this.nameSpacePrefix = null;
            this.nameSpace = null;
        } else {
            this.nameSpacePrefix = theStandard.getNamespacePrefix();
            this.nameSpace = theStandard.getNameSpace();
        }
        this.messageName = theStandard.getMessage().getName();
        if (outputStream != null) {
            try {
                this.writer = new XMLFormattingWriter(outputStream, encoding, "\t", "\n", "1.0", true);
            }
            catch (XMLFormattingException e) {
                throw new ConversionSerializationException(e);
            }
        } else {
            throw new IllegalArgumentException("The output stream should not be null. The serialization will not be realized.");
        }
        this.doShowOriginalValue = emitOriginalValue;
        this.doShowOriginalLineNumber = emitOriginalLineNumber;
    }

    public XMLSerializer(StandardDescription theStandard, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber, XMLFormattingWriter parent) throws ConversionSerializationException {
        this(theStandard, emitOriginalValue, emitOriginalLineNumber, parent, false);
    }

    public XMLSerializer(StandardDescription theStandard, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber, XMLFormattingWriter parent, boolean xmlNoPrefix) throws ConversionSerializationException {
        if (theStandard == null) {
            throw new IllegalArgumentException("The standard should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNamespacePrefix() == null) {
            throw new IllegalArgumentException("The standard namespace prefix should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNameSpace() == null) {
            throw new IllegalArgumentException("The standard namespace should not be null. The serialization will not be realized.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The writer should not be null. The serialization will not be realized.");
        }
        if (emitOriginalValue == null) {
            throw new IllegalArgumentException("The emitOriginalValue should not be null. The serialization will not be realized.");
        }
        if (xmlNoPrefix) {
            this.nameSpacePrefix = null;
            this.nameSpace = null;
        } else {
            this.nameSpacePrefix = theStandard.getNamespacePrefix();
            this.nameSpace = theStandard.getNameSpace();
        }
        this.messageName = theStandard.getMessage().getName();
        this.writer = parent;
        this.doShowOriginalValue = emitOriginalValue;
        this.doShowOriginalLineNumber = emitOriginalLineNumber;
    }

    @Override
    public void startTree() throws TreeProcessingException {
        try {
            this.writer.writeStartDocument();
            if (this.nameSpace != null) {
                this.writer.setPrefix(this.nameSpacePrefix, this.nameSpace);
            }
            this.writer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        catch (XMLFormattingException exception) {
            throw new TreeProcessingException("An exception has occured while appending the header of the converted file using: nameSpace = " + this.nameSpace + "nameSpacePrefix = " + this.nameSpacePrefix + "messageName = " + this.messageName + ". " + exception.getMessage(), exception);
        }
    }

    @Override
    public void endTree() throws TreeProcessingException {
        try {
            this.writer.writeEndDocument();
            this.writer.flush();
        }
        catch (XMLFormattingException exception) {
            throw new TreeProcessingException("An exception has occured while appending the footer of the converted file: " + exception.getMessage(), exception);
        }
        catch (IOException e) {
            throw new TreeProcessingException("An exception has occured while appending the footer of the converted file: " + e.getMessage(), e);
        }
    }

    protected DeclarationDescription getDeclaration(IMessageBlock block) {
        for (Object annotation : ((MessageBlock)block).getAnnotations()) {
            if (!(annotation instanceof BlockDeclarationAnnotation)) continue;
            return ((BlockDeclarationAnnotation)annotation).getDeclaration();
        }
        return null;
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        String blocQualifiedId = block.getStandardBlockDescription().getFullQualifiedId();
        String blocXMLTag = XMLUtil.getTagNameFromQualifiedId(blocQualifiedId);
        String blocName = block.getStandardBlockDescription().getName();
        try {
            boolean doSerializeChild;
            boolean bl = doSerializeChild = blocName != null;
            if (this.nameSpace == null) {
                this.writer.writeStartElement(blocXMLTag);
            } else {
                this.writer.writeStartElement(this.nameSpace, blocXMLTag);
            }
            if (block.getStandardBlockDescription() instanceof MessageDescription) {
                if (this.nameSpace != null) {
                    this.writer.writeNamespace(this.nameSpacePrefix, this.nameSpace);
                }
                this.writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            } else if (block.getStandardBlockDescription() instanceof DeclarationBlockDescription) {
                DeclarationDescription declaration = this.getDeclaration(block);
                if (declaration != null) {
                    if (this.nameSpacePrefix == null) {
                        this.writer.writeAttribute("xsi:type", declaration.getName().replaceAll(" ", "_"));
                    } else {
                        this.writer.writeAttribute("xsi:type", String.valueOf(this.nameSpacePrefix) + ":" + declaration.getName().replaceAll(" ", "_"));
                    }
                } else {
                    doSerializeChild = false;
                }
            }
            if (doSerializeChild) {
                List<IMessageField<?>> fields = block.getFields();
                int size = fields.size();
                int i = 0;
                while (i < size) {
                    String formatedValue;
                    IMessageField<?> field = fields.get(i);
                    String fieldQualifiedId = field.getStandardFieldDescription().getFullQualifiedId();
                    String fieldXMLTag = XMLUtil.getTagNameFromQualifiedId(fieldQualifiedId);
                    String originalValue = field.getOriginalValueAsString();
                    if (this.nameSpace == null) {
                        this.writer.writeStartElement(fieldXMLTag);
                    } else {
                        this.writer.writeStartElement(this.nameSpace, fieldXMLTag);
                    }
                    if (this.doShowOriginalLineNumber) {
                        this.writer.writeAttribute("originLineNumber", field.getFieldLocalizer().getLocalization());
                    }
                    if ((formatedValue = this.getFormatedValue(field)) != null) {
                        this.writer.writeAttribute("originalValue", originalValue);
                        this.writer.writeCharacters(formatedValue);
                    } else {
                        this.writer.writeCharacters(originalValue);
                    }
                    this.writer.writeEndElement(false, false);
                    ++i;
                }
            }
        }
        catch (XMLFormattingException exception) {
            throw new TreeProcessingException("An exception has occured while appending the beginning of the " + block.getStandardBlockDescription().getFullQualifiedId() + " bloc writing: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
        try {
            this.writer.writeEndElement(true, true);
        }
        catch (XMLFormattingException exception) {
            throw new TreeProcessingException(exception);
        }
    }

    protected String getFormatedValue(IMessageField<?> field) {
        DataTypeDescription dataType = field.getStandardFieldDescription().getDataType();
        String originalValueAsString = field.getOriginalValueAsString();
        String result = null;
        Object value = field.getValue();
        if (dataType != null && this.isDate(dataType) && (this.doShowOriginalValue == OriginalValueOptionValue.DATE || this.doShowOriginalValue == OriginalValueOptionValue.DATENUM)) {
            if (value != null) {
                try {
                    result = DateUtil.formatDateToXmlStandard((Date)value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    result = originalValueAsString;
                }
            } else {
                result = originalValueAsString;
            }
        } else if (dataType != null && XMLSerializer.isNumeric(dataType) && (this.doShowOriginalValue == OriginalValueOptionValue.NUM || this.doShowOriginalValue == OriginalValueOptionValue.DATENUM)) {
            if (value != null) {
                try {
                    BigDecimal numValue = new BigDecimal(originalValueAsString);
                    result = numValue.toPlainString();
                }
                catch (NumberFormatException numberFormatException) {
                    result = originalValueAsString;
                }
            } else {
                result = originalValueAsString;
            }
        }
        return result;
    }

    private boolean isDate(DataTypeDescription dataType) {
        return dataType.getNature() == NatureType.DATE;
    }

    private static boolean isNumeric(DataTypeDescription dataType) {
        return dataType.getNature() == NatureType.NUMERIC;
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
    }
}

