/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion;

import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationBlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.Anomaly;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ILoggingComponent;
import fr.cnav.saturne.validator.ISequenceProvider;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.ITreeConsumer;
import fr.cnav.saturne.validator.ITreeProvider;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.ValidationInformation;
import fr.cnav.saturne.validator.conversion.xml.BlockDeclarationAnnotation;
import fr.cnav.saturne.validator.conversion.xml.XMLSerializer;
import fr.cnav.saturne.validator.declaration.DeclarationListener;
import fr.cnav.saturne.validator.declaration.IDeclarationIdentificationListener;
import fr.cnav.saturne.validator.engine.ValidatorWithCleaner;
import fr.cnav.saturne.validator.message.LastReadFieldAnnotation;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.MessageElement;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageElement;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class TreeBuilder
implements ITreeProvider,
ILoggingComponent,
IDeclarationIdentificationListener {
    private static final String CONVERSION_MESSAGES = "conversion.messages.";
    protected final ControlMessages controlMessages;
    private final StandardAccessor modelAccessor;
    private Stack<IMessageBlock> stack;
    private Stack<IMessageBlock> stackBlockNotAttached;
    private Map<IMessageBlock, IMessageField<?>> mapNotAttachedBlock2LastAttachedField;
    private final IReportLogger reportLogger;
    private IMessageField<?> lastReadField;
    private IMessageField<?> lastAttachedField;
    private ISequenceProvider blockReader;
    private List<ITreeConsumer> consumers;
    private DeclarationDescription signaledDeclaration;
    private IMessageBlock declarationBlock;
    private boolean tooManyAnomalies = false;
    private DeclarationListener declarationListener;

    public TreeBuilder(StandardAccessor theModelAccessor, IReportLogger reportLogger, ControlMessages theControlMessages, ISequenceProvider theBlockReader) {
        this.blockReader = theBlockReader;
        this.controlMessages = theControlMessages;
        this.reportLogger = reportLogger;
        this.modelAccessor = theModelAccessor;
        this.consumers = new ArrayList<ITreeConsumer>();
        this.declarationListener = new DeclarationListener(theModelAccessor);
        this.declarationListener.addListener(this);
        this.addConsumer(this.declarationListener);
    }

    @Override
    public IReportLogger getReportLogger() {
        return this.reportLogger;
    }

    @Override
    public void addConsumer(ITreeConsumer consumer) {
        this.consumers.add(consumer);
    }

    public void convert() throws TooManyAnomaliesException, SaturneValidatorException {
        this.stack = new Stack();
        this.stackBlockNotAttached = new Stack();
        this.mapNotAttachedBlock2LastAttachedField = new HashMap();
        try {
            for (ITreeConsumer consummer : this.consumers) {
                consummer.startTree();
            }
            MessageElementFactory messageElementFactory = new MessageElementFactory(this.modelAccessor);
            MessageBlock msg = messageElementFactory.getRootContextBlock();
            this.enterBlock(msg);
            this.stack.push(msg);
            IMessageBlock currentBlock = this.getNextBlock();
            while (currentBlock != null) {
                this.attachBloc(currentBlock);
                currentBlock = this.getNextBlock();
            }
            if (!this.stackBlockNotAttached.isEmpty()) {
                this.logNoParentFoundAnomaly();
            }
            while (!this.stack.isEmpty()) {
                this.popAndExit();
            }
            for (ITreeConsumer consummer : this.consumers) {
                consummer.endTree();
            }
        }
        catch (TreeProcessingException e) {
            if (e.getCause() instanceof TooManyAnomaliesException) {
                this.tooManyAnomalies = true;
            }
            throw new SaturneValidatorException(e);
        }
        if (this.tooManyAnomalies) {
            int maxAno = this.reportLogger.getAnomaliesNumber() - 1;
            throw new TooManyAnomaliesException("Anomaly number exceeds the limit (" + maxAno + ")");
        }
    }

    private IMessageBlock getNextBlock() throws SaturneValidatorException {
        IMessageBlock result = this.blockReader.getNextBlock();
        this.blockReader.consummeBlock();
        return result;
    }

    private void logAnomaliesOfBlockAndFields(IMessageBlock block) {
        this.logAnomalies(block);
        for (IMessageField<?> field : block.getFields()) {
            this.logAnomalies(field);
        }
    }

    private void logAnomalies(IMessageElement element) {
        try {
            for (Object info : ((MessageElement)element).getAnnotations()) {
                if (!(info instanceof ValidationInformation)) continue;
                for (Anomaly anomaly : ((ValidationInformation)info).getAnomalies()) {
                    this.reportLogger.logAnomaly(anomaly.getField(), anomaly.getCode(), anomaly.getMessage(), anomaly.getCriticity());
                }
            }
        }
        catch (TooManyAnomaliesException tooManyAnomaliesException) {
            this.tooManyAnomalies = true;
        }
    }

    private boolean attachBloc(IMessageBlock bloc) throws SaturneValidatorException, TooManyAnomaliesException {
        IMessageBlock foundParent;
        ((MessageBlock)bloc).addAnnotation(new LastReadFieldAnnotation(this.lastReadField));
        List<IMessageField<?>> fields = bloc.getFields();
        if (fields.size() > 0) {
            this.lastReadField = fields.get(fields.size() - 1);
        }
        if ((foundParent = this.getParentBlock(bloc, this.stack)) != null) {
            this.lastAttachedField = this.lastReadField;
            this.updateStacksAndSignalExit(bloc, foundParent);
        } else {
            this.updateStackOfBlocsUnattached(bloc);
        }
        return foundParent != null;
    }

    private void logNoParentFoundAnomaly() {
        IMessageField<?> fieldToAdd = null;
        fieldToAdd = this.stackBlockNotAttached.peek().getFields() != null && this.stackBlockNotAttached.peek().getFields().size() != 0 ? this.stackBlockNotAttached.peek().getFields().get(0) : this.lastAttachedField;
        String message = null;
        IMessageBlock blockNotAttached = (IMessageBlock)this.stackBlockNotAttached.get(0);
        String blockNotAttachedFQId = blockNotAttached.getStandardBlockDescription().getFullQualifiedId();
        if (this.stack.size() <= 1) {
            message = this.controlMessages.getMessage("conversion.messages.CV11_2", new Object[]{blockNotAttachedFQId});
        } else if (this.mapNotAttachedBlock2LastAttachedField.get(blockNotAttached) != null) {
            String lastAttachedFieldIQID = this.mapNotAttachedBlock2LastAttachedField.get(blockNotAttached).getStandardFieldDescription().getFullQualifiedId();
            message = this.controlMessages.getMessage("conversion.messages.CV11", new Object[]{blockNotAttachedFQId, lastAttachedFieldIQID});
        } else {
            message = this.controlMessages.getMessage("conversion.messages.CV11", new Object[]{blockNotAttachedFQId, "noFoundField"});
        }
        try {
            this.reportLogger.logAnomaly(fieldToAdd, "CV11", message, RuleCriticity.BLOCKING);
        }
        catch (TooManyAnomaliesException tooManyAnomaliesException) {
            this.tooManyAnomalies = true;
        }
    }

    private void updateStackOfBlocsUnattached(IMessageBlock notAttachedBloc) {
        IMessageBlock computeParentBlock = null;
        if (!this.stackBlockNotAttached.isEmpty()) {
            computeParentBlock = this.getParentBlock(notAttachedBloc, this.stackBlockNotAttached);
            if (computeParentBlock != null) {
                while (this.stackBlockNotAttached.peek() != computeParentBlock) {
                    this.stackBlockNotAttached.pop();
                }
            } else {
                this.logNoParentFoundAnomaly();
                this.stackBlockNotAttached.clear();
            }
        }
        this.stackBlockNotAttached.push(notAttachedBloc);
        this.mapNotAttachedBlock2LastAttachedField.put(notAttachedBloc, this.lastAttachedField);
        this.logAnomalies(notAttachedBloc);
    }

    private IMessageBlock popAndExit() throws SaturneValidatorException {
        IMessageBlock bloc = this.stack.pop();
        for (ITreeConsumer consumer : this.consumers) {
            if (this.tooManyAnomalies && !(consumer instanceof IReportLogger) && !(consumer instanceof XMLSerializer)) continue;
            try {
                consumer.exitBlock(bloc);
            }
            catch (TreeProcessingException e) {
                if (e.getCause() instanceof TooManyAnomaliesException) {
                    this.tooManyAnomalies = true;
                    continue;
                }
                throw new SaturneValidatorException(e);
            }
        }
        return bloc;
    }

    private void updateStacksAndSignalExit(IMessageBlock attachedBloc, IMessageBlock parentBloc) throws SaturneValidatorException, TooManyAnomaliesException {
        if (!this.stackBlockNotAttached.isEmpty()) {
            this.logNoParentFoundAnomaly();
            this.stackBlockNotAttached.clear();
        }
        while (this.stack.peek() != parentBloc) {
            this.popAndExit();
        }
        this.stack.push(attachedBloc);
        this.enterBlock(attachedBloc);
        this.logAnomaliesOfBlockAndFields(attachedBloc);
        if (this.declarationBlock != null) {
            this.processDeclaration();
        }
    }

    private IMessageBlock getParentBlock(IMessageBlock block, Stack<IMessageBlock> theStack) {
        IMessageBlock foundParent = null;
        int rank = theStack.size() - 1;
        String parentBlocId = block.getStandardBlockDescription().getParent().getFullQualifiedId();
        IMessageBlock candidate = null;
        while (foundParent == null && rank >= 0) {
            candidate = (IMessageBlock)theStack.get(rank);
            if (parentBlocId.equals(candidate.getStandardBlockDescription().getFullQualifiedId())) {
                foundParent = candidate;
                foundParent.addBlock(block);
            }
            --rank;
        }
        return foundParent;
    }

    private void enterBlock(IMessageBlock block) throws SaturneValidatorException {
        int consumersSize = this.consumers.size();
        int c = 0;
        while (c < consumersSize) {
            ITreeConsumer consumer = this.consumers.get(c);
            if (!this.tooManyAnomalies || !(consumer instanceof ValidatorWithCleaner)) {
                try {
                    consumer.enterBlock(block);
                    int fieldsSize = block.getFields().size();
                    int i = 0;
                    while (i < fieldsSize) {
                        IMessageField<?> field = block.getFields().get(i);
                        if (field instanceof IMessageFieldAlphanum) {
                            consumer.signalAlphanumField((IMessageFieldAlphanum)field);
                        } else if (field instanceof IMessageFieldNum) {
                            consumer.signalNumericField((IMessageFieldNum)field);
                        } else if (field instanceof IMessageFieldDate) {
                            consumer.signalDateField((IMessageFieldDate)field);
                        }
                        ++i;
                    }
                }
                catch (TreeProcessingException e) {
                    if (e.getCause() instanceof TooManyAnomaliesException) {
                        this.tooManyAnomalies = true;
                    }
                    if (e.getCause() instanceof SaturneValidatorException) {
                        throw (SaturneValidatorException)e.getCause();
                    }
                    throw new SaturneValidatorException(e);
                }
            }
            ++c;
        }
    }

    @Override
    public OptionMap getOptions() {
        return null;
    }

    private void processDeclaration() throws SaturneValidatorException {
        if (this.signaledDeclaration == null) {
            IMessageField<?> field = this.declarationBlock.getFields().size() > 0 ? this.declarationBlock.getFields().get(0) : null;
            int lineNumber = field == null ? this.lastReadField.getFieldLocalizer().getLineNumber() : field.getFieldLocalizer().getLineNumber();
            int lastLineNumber = this.advanceToNextDeclaration();
            try {
                this.reportLogger.logAnomaly(field, "CV12", this.controlMessages.getMessage("conversion.messages.CV12", new Object[]{lineNumber, lastLineNumber}), RuleCriticity.BLOCKING);
            }
            catch (TooManyAnomaliesException tooManyAnomaliesException) {
                this.tooManyAnomalies = true;
            }
            IMessageBlock popedBlock = null;
            if (!this.stack.isEmpty()) {
                do {
                    popedBlock = this.popAndExit();
                } while (!this.stack.isEmpty() && !(popedBlock.getStandardBlockDescription() instanceof DeclarationBlockDescription));
            }
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("advancing to the next block while no declaration is on the stack.");
            }
        }
        this.declarationBlock = null;
        this.signaledDeclaration = null;
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
        this.signaledDeclaration = declaration;
        this.declarationBlock = block;
        if (declaration != null) {
            ((MessageBlock)block).getAnnotations().add(new BlockDeclarationAnnotation(declaration));
        }
        for (ITreeConsumer consumer : this.consumers) {
            if (!(consumer instanceof ITreeAndDeclarationConsumer)) continue;
            ((ITreeAndDeclarationConsumer)consumer).signalDeclaration(block, declaration);
        }
    }

    private int advanceToNextDeclaration() throws SaturneValidatorException {
        if (this.modelAccessor.getMessage() == null || this.modelAccessor.getMessage().getFooterBlock() == null) {
            throw new IllegalArgumentException("malformed standard : message or footer block are null.");
        }
        int lastLineNumber = -1;
        BlockDescription footer = this.modelAccessor.getMessageDescription().getFooterBlock();
        IMessageBlock block = this.blockReader.getNextBlock();
        while (block != null && !(block.getStandardBlockDescription() instanceof DeclarationBlockDescription) && !footer.equals(block.getStandardBlockDescription())) {
            List<IMessageField<?>> fields = block.getFields();
            if (fields.size() > 0) {
                lastLineNumber = fields.get(fields.size() - 1).getFieldLocalizer().getLineNumber();
            }
            this.blockReader.consummeBlock();
            block = this.blockReader.getNextBlock();
        }
        return lastLineNumber;
    }
}

