/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.controlMessages;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;

public class ControlMessagesLoader {
    private Properties propertiesFr;
    private Properties propertiesEn;

    public ControlMessagesLoader() throws IOException {
        URL frResource = this.getClass().getClassLoader().getResource("controlMessages.properties");
        URL enResource = this.getClass().getClassLoader().getResource("controlMessages_en.properties");
        this.propertiesFr = new Properties();
        this.propertiesEn = new Properties();
        InputStream fileInputStream = frResource.openStream();
        InputStream enFileInputStream = enResource.openStream();
        InputStreamReader inputStreamReaderFr = null;
        InputStreamReader inputStreamReaderEn = null;
        try {
            inputStreamReaderFr = new InputStreamReader(fileInputStream, Charset.forName("UTF-8"));
            this.propertiesFr.load(inputStreamReaderFr);
            inputStreamReaderEn = new InputStreamReader(enFileInputStream, Charset.forName("UTF-8"));
            this.propertiesEn.load(inputStreamReaderEn);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (enFileInputStream != null) {
                enFileInputStream.close();
            }
            if (inputStreamReaderFr != null) {
                inputStreamReaderFr.close();
            }
            if (inputStreamReaderEn != null) {
                inputStreamReaderEn.close();
            }
        }
    }

    public Properties getProperties() {
        return this.propertiesFr;
    }

    public Properties getEnProperties() {
        return this.propertiesEn;
    }
}

