/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.report.model;

import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.ContextField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Context {
    private int startLine;
    private int endLine;
    private final String name;
    private final String blockQualifiedId;
    private final List<Anomaly> anomalies;
    private final List<ContextField> contextFields;
    private final boolean useAnomaliesCounter;
    private final boolean useTotalAnomaliesCounter;
    private int rank;
    private final boolean isStrict;
    private final boolean failOnNoBlockingAnomaly;
    private final List<Context> contextChildren;
    private boolean hasBeenValidated;

    public Context(String name, boolean failOnNoBlockingAnomaly, boolean isStrict, String blockId, boolean useTotalAnomaliesCounter, boolean useAnomaliesCounter) {
        this.name = name;
        this.failOnNoBlockingAnomaly = failOnNoBlockingAnomaly;
        this.isStrict = isStrict;
        this.contextChildren = new ArrayList<Context>();
        this.contextFields = new ArrayList<ContextField>();
        this.anomalies = new ArrayList<Anomaly>();
        this.endLine = -1;
        this.blockQualifiedId = blockId;
        this.startLine = -1;
        this.rank = 0;
        this.useTotalAnomaliesCounter = useTotalAnomaliesCounter;
        this.useAnomaliesCounter = useAnomaliesCounter;
        this.hasBeenValidated = false;
    }

    public boolean doUseAnomaliesCounter() {
        return this.useAnomaliesCounter;
    }

    public boolean doUseTotalAnomaliesCounter() {
        return this.useTotalAnomaliesCounter;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public String getName() {
        return this.name;
    }

    public String getblockQualifiedId() {
        return this.blockQualifiedId;
    }

    public List<ContextField> getContextFields() {
        return this.contextFields;
    }

    public List<Anomaly> getAnomalies() {
        return this.anomalies;
    }

    public int getRank() {
        return this.rank;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public boolean isFailingOnNoBlockingAnomaly() {
        return this.failOnNoBlockingAnomaly;
    }

    public boolean isValid() {
        boolean isValid = true;
        if (this.failOnNoBlockingAnomaly && this.anomalies.size() > 0) {
            isValid = false;
        } else if (!this.failOnNoBlockingAnomaly && this.anomalies.size() > 0) {
            Iterator<Anomaly> anomaliesIte = this.anomalies.iterator();
            while (anomaliesIte.hasNext() && isValid) {
                Anomaly anomaly = anomaliesIte.next();
                if (!anomaly.isBlocking()) continue;
                isValid = false;
            }
        }
        if (isValid) {
            isValid = this.areContextChildrenValid();
        }
        return isValid;
    }

    private boolean areContextChildrenValid() {
        boolean isValid = true;
        Iterator<Context> contextChildrenIte = this.contextChildren.iterator();
        boolean stopValidation = false;
        while (contextChildrenIte.hasNext() && !stopValidation) {
            Context context = contextChildrenIte.next();
            if (this.isStrict && !context.isValid()) {
                isValid = false;
                stopValidation = true;
                continue;
            }
            if (!this.isStrict && context.isValid()) {
                stopValidation = true;
                isValid = true;
                continue;
            }
            if (this.isStrict || context.isValid()) continue;
            isValid = false;
        }
        return isValid;
    }

    public final List<Context> getContextChildren() {
        return this.contextChildren;
    }

    public void addAnomalyToContext(Anomaly anomaly) {
        this.anomalies.add(anomaly);
    }

    public void addContextField(ContextField field) {
        this.contextFields.add(field);
    }

    public void addContextChild(Context lastContext) {
        this.contextChildren.add(lastContext);
    }

    public void setRank(int rankInParent) {
        this.rank = rankInParent;
    }

    public boolean hasBeenDirectlyValidated() {
        return this.hasBeenValidated;
    }

    public void hasBeenDirectlyValidated(boolean isValidated) {
        this.hasBeenValidated = isValidated;
    }
}

