/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.runtime;

import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.gen.DSLGeneratorContext;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.CallTypeAdapter;

public class ExternalFunctionHelper {
    private IParserConfiguration configuration;

    public ExternalFunctionHelper() {
        this.configuration = DSLGeneratorContext.getInstance().getConfiguration();
    }

    public ExternalFunctionHelper(IParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getSignature(String function, int argsNbr) {
        return this.configuration.getDefinition(String.valueOf(function) + "/" + argsNbr + ".prototype");
    }

    public Type getReturnType(String function, int argsNbr) {
        String signature = this.getSignature(function, argsNbr);
        if (signature != null && !"".equalsIgnoreCase(signature.trim())) {
            return CallTypeAdapter.resultTypes((String)signature);
        }
        return Type.UNDEFINED;
    }

    public Type[] getArgsType(String function, int argsNbr) {
        String signature = this.getSignature(function, argsNbr);
        if (signature != null && !"".equalsIgnoreCase(signature.trim())) {
            return CallTypeAdapter.arguments((String)signature);
        }
        return null;
    }

    public Type getArgType(String function, int argsNbr, int iArg) {
        Type[] argsType = this.getArgsType(function, argsNbr);
        if (argsType != null && argsType.length > iArg) {
            return argsType[iArg];
        }
        return Type.UNDEFINED;
    }

    public Boolean isInFunction(Expression expr) {
        if (expr.eContainer() != null && expr.eContainer() instanceof FunctionCall) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private int getArgIndex(Expression expr) {
        if (this.isInFunction(expr).booleanValue()) {
            FunctionCall functionCall = (FunctionCall)expr.eContainer();
            int i = 0;
            for (Expression arg : functionCall.getArguments()) {
                if (arg == expr) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private String getArgFunctionName(Expression expr) {
        if (this.isInFunction(expr).booleanValue()) {
            FunctionCall functionCall = (FunctionCall)expr.eContainer();
            return functionCall.getName();
        }
        return "";
    }

    private int getArgFunctionArgNbr(Expression expr) {
        if (this.isInFunction(expr).booleanValue()) {
            FunctionCall functionCall = (FunctionCall)expr.eContainer();
            return functionCall.getArguments().size();
        }
        return -1;
    }

    public Type getArgType(Expression expr) {
        String functionName = this.getArgFunctionName(expr);
        int argsNbr = this.getArgFunctionArgNbr(expr);
        int argIndex = this.getArgIndex(expr);
        return this.getArgType(functionName, argsNbr, argIndex);
    }

    public Boolean isNodeArgType(Expression argExpression) {
        if (this.isInFunction(argExpression).booleanValue()) {
            Type typeArg = this.getArgType(argExpression);
            if (!Type.NODE.equals((Object)typeArg) && !Type.NODE_LIST.equals((Object)typeArg)) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Boolean isListType(Expression argExpression) {
        if (this.isInFunction(argExpression).booleanValue()) {
            Type typeArg = this.getArgType(argExpression);
            if (!(Type.NODE_LIST.equals((Object)typeArg) || Type.ALPHANUM_LIST.equals((Object)typeArg) || Type.DATE_LIST.equals((Object)typeArg) || Type.NUM_LIST.equals((Object)typeArg) || Type.TOKEN_LIST.equals((Object)typeArg))) {
                return false;
            }
            return true;
        }
        return false;
    }
}

