/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.requestor;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.dsl.formules.Add;
import fr.cnav.saturne.dsl.formules.AlphaNum;
import fr.cnav.saturne.dsl.formules.And;
import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Child;
import fr.cnav.saturne.dsl.formules.Date;
import fr.cnav.saturne.dsl.formules.Diff;
import fr.cnav.saturne.dsl.formules.Div;
import fr.cnav.saturne.dsl.formules.Equals;
import fr.cnav.saturne.dsl.formules.Equiv;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.Greater;
import fr.cnav.saturne.dsl.formules.GreaterEqual;
import fr.cnav.saturne.dsl.formules.Imply;
import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.Lower;
import fr.cnav.saturne.dsl.formules.LowerEqual;
import fr.cnav.saturne.dsl.formules.Mult;
import fr.cnav.saturne.dsl.formules.NodeExpression;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.Num;
import fr.cnav.saturne.dsl.formules.Or;
import fr.cnav.saturne.dsl.formules.Parent;
import fr.cnav.saturne.dsl.formules.PathExpression;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.Sub;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.requestor.IInterpreter;
import fr.cnav.saturne.dsl.requestor.StandardNavigationException;
import fr.cnav.saturne.dsl.runtime.BuiltinFunctions;
import fr.cnav.saturne.dsl.runtime.ExternalFunctionHelper;
import fr.cnav.saturne.dsl.runtime.RulesExecUtils;
import fr.cnav.saturne.dsl.runtime.TypeHelper;
import fr.cnav.saturne.validator.message.MessageNavigator;
import fr.cnav.saturne.validator.message.Operators;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageElement;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageNavigator;
import fr.cnav.saturne.validator.utils.DateUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.channels.IllegalSelectorException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;

public class FormulesInterpreter
extends FormulesSwitch<Object>
implements IInterpreter {
    private final Deque<Map<String, Object>> variablesStack = new ArrayDeque<Map<String, Object>>();
    private final Class<?> builtinFunctions = BuiltinFunctions.class;
    private final Class<?> externalFunctions;
    private final StandardAccessor standardAccessor;
    private final IMessageNavigator standardNavigator;
    private final ExternalFunctionHelper externalFunctionHelper;
    private final TypeHelper typeHelper;
    private IMessageBlock ctxt;

    public FormulesInterpreter(StandardAccessor standardAccessor, IParserConfiguration parserConfiguration, Class<?> externalFunctions) {
        this.standardAccessor = standardAccessor;
        this.standardNavigator = new MessageNavigator(standardAccessor);
        this.externalFunctions = externalFunctions;
        this.externalFunctionHelper = new ExternalFunctionHelper(parserConfiguration);
        this.typeHelper = new TypeHelper(parserConfiguration);
    }

    @Override
    public List<Object> eval(IMessageBlock context, Expression dslExpression) {
        ArrayList<Object> res;
        this.ctxt = context;
        HashMap<String, IMessageBlock> variables = new HashMap<String, IMessageBlock>();
        variables.put("root", this.ctxt);
        this.variablesStack.push(variables);
        try {
            Object value = this.doSwitch((EObject)dslExpression);
            if (value instanceof Collection) {
                res = new ArrayList((List)value);
            } else {
                res = new ArrayList<Object>();
                res.add(value);
            }
        }
        finally {
            this.ctxt = null;
            this.variablesStack.pop();
        }
        return res;
    }

    public Object caseFunctionCall(FunctionCall functionCall) {
        Object res;
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Expression argument : functionCall.getArguments()) {
            arguments.add(this.doSwitch((EObject)argument));
        }
        if (RulesExecUtils.isInBuiltinFunctions((Expression)functionCall)) {
            res = this.invokeFunctionCall(this.builtinFunctions, functionCall.getName(), arguments);
        } else if (RulesExecUtils.isInBuiltinFunctionsWithModelAccessor((Expression)functionCall)) {
            arguments.add(0, this.standardAccessor);
            res = this.invokeFunctionCall(this.builtinFunctions, functionCall.getName(), arguments);
        } else {
            res = this.invokeFunctionCall(this.externalFunctions, functionCall.getName(), arguments);
        }
        return res;
    }

    private Object invokeFunctionCall(Class<?> functionClass, String name, List<Object> arguments) {
        Object res;
        Class[] parameterTypes = new Class[arguments.size()];
        int index = 0;
        for (Object argument : arguments) {
            parameterTypes[index++] = argument.getClass();
        }
        try {
            Method method = this.getMethod(functionClass, name, parameterTypes);
            res = method.invoke(null, arguments.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
        return res;
    }

    private Method getMethod(Class<?> functionClass, String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method res = null;
        Method[] methodArray = functionClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(name)) {
                boolean compatible = true;
                int paramIndex = 0;
                Class<?>[] classArray = method.getParameterTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> parameterType = classArray[n4];
                    if (!parameterType.isAssignableFrom(parameterTypes[paramIndex++])) {
                        compatible = false;
                        break;
                    }
                    ++n4;
                }
                if (compatible) {
                    res = method;
                    break;
                }
            }
            ++n2;
        }
        return res;
    }

    public Object caseFieldRef(FieldRef fieldRef) {
        Object targetMessages = this.getTargetMessages(fieldRef);
        Object res = this.externalFunctionHelper.isInFunction((Expression)fieldRef).booleanValue() && !this.externalFunctionHelper.isNodeArgType((Expression)fieldRef).booleanValue() ? (targetMessages == null ? null : this.toMessageField(targetMessages).getValue()) : targetMessages;
        return res;
    }

    private Object getTargetMessages(FieldRef fieldRef) {
        Object res;
        try {
            IMessageBlock context = this.toMessageBlock(this.variablesStack.peek().get(fieldRef.getContextVariable()));
            List<IMessageElement> values = this.standardNavigator.getTargetMessages(context, fieldRef.getName());
            res = this.standardNavigator.isMultipleTarget(context, fieldRef.getName()).booleanValue() ? values : values.get(0);
        }
        catch (StandardNavigationException e) {
            e.printStackTrace();
            throw new IllegalSelectorException();
        }
        return res;
    }

    public Object casePathExpression(PathExpression pathExpression) {
        Object res = this.ctxt;
        for (NodeExpression segment : pathExpression.getSegments()) {
            if (segment instanceof Parent) {
                res = this.toMessageBlock(res).getParent();
                continue;
            }
            if (!(segment instanceof Child)) continue;
            res = this.invokeChild(res, (Child)segment);
        }
        return res;
    }

    private Object invokeChild(Object object, Child child) {
        Object res;
        try {
            Method method = object.getClass().getMethod("get" + child.getName(), new Class[0]);
            res = method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
        return res;
    }

    public BigDecimal caseAdd(Add add) {
        BigDecimal res = BigDecimal.ZERO;
        for (Expression operand : add.getOperands()) {
            res = res.add(this.toDecimal(this.doSwitch((EObject)operand)));
        }
        return res;
    }

    public BigDecimal caseSub(Sub sub) {
        BigDecimal res;
        Iterator it = sub.getOperands().iterator();
        if (it.hasNext()) {
            res = this.toDecimal(this.doSwitch((EObject)it.next()));
            while (it.hasNext()) {
                res = res.subtract(this.toDecimal(this.doSwitch((EObject)it.next())));
            }
        } else {
            res = BigDecimal.ZERO;
        }
        return res;
    }

    public BigDecimal caseMult(Mult mult) {
        BigDecimal res = BigDecimal.ONE;
        for (Expression operand : mult.getOperands()) {
            res = res.multiply(this.toDecimal(this.doSwitch((EObject)operand)));
        }
        return res;
    }

    public BigDecimal caseDiv(Div div) {
        Iterator it = div.getOperands().iterator();
        BigDecimal res = this.toDecimal(this.doSwitch((EObject)it.next()));
        while (it.hasNext()) {
            res = res.divide(this.toDecimal(this.doSwitch((EObject)it.next())));
        }
        return res;
    }

    public Boolean caseAnd(And and) {
        Boolean res = Boolean.TRUE;
        for (Expression operand : and.getOperands()) {
            if (!(res = Boolean.valueOf(Boolean.logicalAnd(res, this.toBoolean(this.doSwitch((EObject)operand))))).booleanValue()) break;
        }
        return res;
    }

    public Boolean caseOr(Or or) {
        Boolean res = Boolean.FALSE;
        for (Expression operand : or.getOperands()) {
            if ((res = Boolean.valueOf(Boolean.logicalOr(res, this.toBoolean(this.doSwitch((EObject)operand))))).booleanValue()) break;
        }
        return res;
    }

    public Boolean caseImply(Imply imply) {
        Boolean res = this.toBoolean(this.doSwitch((EObject)imply.getLeftOp())) != false ? this.toBoolean(this.doSwitch((EObject)imply.getRightOp())) : Boolean.TRUE;
        return res;
    }

    public Object caseNot(Not not) {
        return this.toBoolean(this.doSwitch((EObject)not.getOperand())) == false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean caseDiff(Diff diff) {
        Object leftValue = this.doSwitch((EObject)diff.getLeftOp());
        Object rightValue = this.doSwitch((EObject)diff.getRightOp());
        if (this.typeHelper.isNodeType(diff.getLeftOp()).booleanValue() && this.typeHelper.isNodeType(diff.getRightOp()).booleanValue()) {
            return leftValue != rightValue;
        }
        if (leftValue instanceof BigDecimal && rightValue instanceof BigDecimal) {
            return Operators.neq((BigDecimal)leftValue, (BigDecimal)rightValue);
        }
        if (leftValue instanceof IMessageField) {
            if (rightValue instanceof IMessageField) {
                return Operators.neq((IMessageField)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.neq((IMessageField)leftValue, (Comparable)rightValue);
        }
        if (leftValue instanceof Iterable) {
            if (rightValue instanceof IMessageField) {
                return Operators.neq((Iterable)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.neq((Iterable)leftValue, (Comparable)rightValue);
        }
        if (!(leftValue instanceof Comparable)) throw new IllegalStateException();
        if (rightValue instanceof IMessageField) {
            return Operators.neq((Comparable)leftValue, (IMessageField)rightValue);
        }
        if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
        return Operators.neq((Comparable)leftValue, (Comparable)rightValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object caseEquals(Equals equals) {
        Object leftValue = this.doSwitch((EObject)equals.getLeftOp());
        Object rightValue = this.doSwitch((EObject)equals.getRightOp());
        if (this.typeHelper.isNodeType(equals.getLeftOp()).booleanValue() && this.typeHelper.isNodeType(equals.getRightOp()).booleanValue()) {
            return leftValue == rightValue;
        }
        if (leftValue instanceof BigDecimal && rightValue instanceof BigDecimal) {
            return Operators.eq((BigDecimal)leftValue, (BigDecimal)rightValue);
        }
        if (leftValue instanceof IMessageField) {
            if (rightValue instanceof IMessageField) {
                return Operators.eq((IMessageField)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.eq((IMessageField)leftValue, (Comparable)rightValue);
        }
        if (leftValue instanceof Iterable) {
            if (rightValue instanceof IMessageField) {
                return Operators.eq((Iterable)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.eq((Iterable)leftValue, (Comparable)rightValue);
        }
        if (!(leftValue instanceof Comparable)) throw new IllegalStateException();
        if (rightValue instanceof IMessageField) {
            return Operators.eq((Comparable)leftValue, (IMessageField)rightValue);
        }
        if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
        return Operators.eq((Comparable)leftValue, (Comparable)rightValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object caseGreater(Greater greater) {
        Object leftValue = this.doSwitch((EObject)greater.getLeftOp());
        Object rightValue = this.doSwitch((EObject)greater.getRightOp());
        if (leftValue instanceof BigDecimal && rightValue instanceof BigDecimal) {
            return Operators.gt((BigDecimal)leftValue, (BigDecimal)rightValue);
        }
        if (leftValue instanceof IMessageField) {
            if (rightValue instanceof IMessageField) {
                return Operators.gt((IMessageField)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.gt((IMessageField)leftValue, (Comparable)rightValue);
        }
        if (leftValue instanceof Iterable) {
            if (rightValue instanceof IMessageField) {
                return Operators.gt((Iterable)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.gt((Iterable)leftValue, (Comparable)rightValue);
        }
        if (!(leftValue instanceof Comparable)) throw new IllegalStateException();
        if (rightValue instanceof IMessageField) {
            return Operators.gt((Comparable)leftValue, (IMessageField)rightValue);
        }
        if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
        return Operators.gt((Comparable)leftValue, (Comparable)rightValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object caseGreaterEqual(GreaterEqual greaterEqual) {
        Object leftValue = this.doSwitch((EObject)greaterEqual.getLeftOp());
        Object rightValue = this.doSwitch((EObject)greaterEqual.getRightOp());
        if (leftValue instanceof BigDecimal && rightValue instanceof BigDecimal) {
            return Operators.ge((BigDecimal)leftValue, (BigDecimal)rightValue);
        }
        if (leftValue instanceof IMessageField) {
            if (rightValue instanceof IMessageField) {
                return Operators.ge((IMessageField)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.ge((IMessageField)leftValue, (Comparable)rightValue);
        }
        if (leftValue instanceof Iterable) {
            if (rightValue instanceof IMessageField) {
                return Operators.ge((Iterable)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.ge((Iterable)leftValue, (Comparable)rightValue);
        }
        if (!(leftValue instanceof Comparable)) throw new IllegalStateException();
        if (rightValue instanceof IMessageField) {
            return Operators.ge((Comparable)leftValue, (IMessageField)rightValue);
        }
        if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
        return Operators.ge((Comparable)leftValue, (Comparable)rightValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object caseLower(Lower lower) {
        Object leftValue = this.doSwitch((EObject)lower.getLeftOp());
        Object rightValue = this.doSwitch((EObject)lower.getRightOp());
        if (leftValue instanceof BigDecimal && rightValue instanceof BigDecimal) {
            return Operators.lt((BigDecimal)leftValue, (BigDecimal)rightValue);
        }
        if (leftValue instanceof IMessageField) {
            if (rightValue instanceof IMessageField) {
                return Operators.lt((IMessageField)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.lt((IMessageField)leftValue, (Comparable)rightValue);
        }
        if (leftValue instanceof Iterable) {
            if (rightValue instanceof IMessageField) {
                return Operators.lt((Iterable)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.lt((Iterable)leftValue, (Comparable)rightValue);
        }
        if (!(leftValue instanceof Comparable)) throw new IllegalStateException();
        if (rightValue instanceof IMessageField) {
            return Operators.lt((Comparable)leftValue, (IMessageField)rightValue);
        }
        if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
        return Operators.lt((Comparable)leftValue, (Comparable)rightValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object caseLowerEqual(LowerEqual lowerEqual) {
        Object leftValue = this.doSwitch((EObject)lowerEqual.getLeftOp());
        Object rightValue = this.doSwitch((EObject)lowerEqual.getRightOp());
        if (leftValue instanceof BigDecimal && rightValue instanceof BigDecimal) {
            return Operators.le((BigDecimal)leftValue, (BigDecimal)rightValue);
        }
        if (leftValue instanceof IMessageField) {
            if (rightValue instanceof IMessageField) {
                return Operators.le((IMessageField)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.le((IMessageField)leftValue, (Comparable)rightValue);
        }
        if (leftValue instanceof Iterable) {
            if (rightValue instanceof IMessageField) {
                return Operators.le((Iterable)leftValue, (IMessageField)rightValue);
            }
            if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
            return Operators.le((Iterable)leftValue, (Comparable)rightValue);
        }
        if (!(leftValue instanceof Comparable)) throw new IllegalStateException();
        if (rightValue instanceof IMessageField) {
            return Operators.le((Comparable)leftValue, (IMessageField)rightValue);
        }
        if (!(rightValue instanceof Comparable)) throw new IllegalStateException();
        return Operators.le((Comparable)leftValue, (Comparable)rightValue);
    }

    public Boolean caseEquiv(Equiv equiv) {
        if (this.doSwitch((EObject)equiv.getLeftOp()) == this.doSwitch((EObject)equiv.getRightOp())) {
            return true;
        }
        return false;
    }

    public Object caseIn(In in) {
        Object leftValue = this.doSwitch((EObject)in.getLeftOp());
        Boolean res = leftValue instanceof IMessageField ? Boolean.valueOf(Operators.in((IMessageField)leftValue, Arrays.asList(this.doSwitch((EObject)in.getRightOp())))) : Boolean.valueOf(Operators.in(leftValue, (List)this.doSwitch((EObject)in.getRightOp())));
        return res;
    }

    public Object caseLet(Let let) {
        Object res;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (Binding binding : let.getBindings()) {
            variables.put(binding.getVarName(), this.doSwitch((EObject)binding.getExpr()));
        }
        this.variablesStack.push(variables);
        try {
            res = this.doSwitch((EObject)let.getIn());
        }
        finally {
            this.variablesStack.pop();
        }
        return res;
    }

    public String caseAlphaNum(AlphaNum alphaNum) {
        return alphaNum.getValue().replaceAll("&#x(\\d\\d);", "\\\\x$1").replaceAll("&#u(\\d{4});", "\\\\u$1");
    }

    public Object caseDate(Date date) {
        return DateUtil.parseDateFromDsl(date.getValue());
    }

    public Object caseNum(Num num) {
        return BigDecimal.valueOf(Double.valueOf(num.getValue()));
    }

    public Boolean caseQuantified(Quantified quantified) {
        Boolean res;
        switch (quantified.getQuantifier()) {
            case EVERY: {
                res = this.caseEvery(quantified);
                break;
            }
            case SOME: {
                res = this.caseSome(quantified);
                break;
            }
            case NONE: {
                res = this.caseNone(quantified);
                break;
            }
            case NONE_OR_EVERY: {
                res = this.caseNoneOrEvery(quantified);
                break;
            }
            default: {
                throw new IllegalStateException(quantified.getQuantifier() + " not implemented");
            }
        }
        return res;
    }

    private Boolean caseEvery(final Quantified quantified) {
        Boolean res;
        final String everyVariableName = ((IteratorVariable)quantified.getVariables().get(0)).getVarName();
        Object everyVariableValue = this.doSwitch((EObject)((IteratorVariable)quantified.getVariables().get(0)).getElement());
        final HashMap<String, Object> everyVariables = new HashMap<String, Object>(this.variablesStack.peek());
        this.variablesStack.push(everyVariables);
        Predicate<Object> everyPredicate = new Predicate<Object>(){

            @Override
            public boolean test(Object input) {
                everyVariables.put(everyVariableName, input);
                return FormulesInterpreter.this.toBoolean(FormulesInterpreter.this.doSwitch((EObject)quantified.getExpression()));
            }
        };
        try {
            res = everyVariableValue instanceof Iterable ? Boolean.valueOf(Operators.everyIterable((Iterable)everyVariableValue, everyPredicate)) : Boolean.valueOf(Operators.every(everyVariableValue, everyPredicate));
        }
        finally {
            this.variablesStack.pop();
        }
        return res;
    }

    private Boolean caseSome(final Quantified quantified) {
        Boolean res;
        final String someVariableName = ((IteratorVariable)quantified.getVariables().get(0)).getVarName();
        Object someVariableValue = this.doSwitch((EObject)((IteratorVariable)quantified.getVariables().get(0)).getElement());
        final HashMap<String, Object> someVariables = new HashMap<String, Object>(this.variablesStack.peek());
        this.variablesStack.push(someVariables);
        Predicate<Object> somePredicate = new Predicate<Object>(){

            @Override
            public boolean test(Object input) {
                someVariables.put(someVariableName, input);
                return FormulesInterpreter.this.toBoolean(FormulesInterpreter.this.doSwitch((EObject)quantified.getExpression()));
            }
        };
        try {
            res = someVariableValue instanceof Iterable ? Boolean.valueOf(Operators.someIterable((Iterable)someVariableValue, somePredicate)) : Boolean.valueOf(Operators.some(someVariableValue, somePredicate));
        }
        finally {
            this.variablesStack.pop();
        }
        return res;
    }

    private Boolean caseNone(final Quantified quantified) {
        Boolean res;
        final String noneVariableName = ((IteratorVariable)quantified.getVariables().get(0)).getVarName();
        Object noneVariableValue = this.doSwitch((EObject)((IteratorVariable)quantified.getVariables().get(0)).getElement());
        final HashMap<String, Object> noneVariables = new HashMap<String, Object>(this.variablesStack.peek());
        this.variablesStack.push(noneVariables);
        Predicate<Object> nonePredicate = new Predicate<Object>(){

            @Override
            public boolean test(Object input) {
                noneVariables.put(noneVariableName, input);
                return FormulesInterpreter.this.toBoolean(FormulesInterpreter.this.doSwitch((EObject)quantified.getExpression())) == false;
            }
        };
        try {
            res = noneVariableValue instanceof Iterable ? Boolean.valueOf(Operators.everyIterable((Iterable)noneVariableValue, nonePredicate)) : Boolean.valueOf(Operators.every(noneVariableValue, nonePredicate));
        }
        finally {
            this.variablesStack.pop();
        }
        return res;
    }

    private Boolean caseNoneOrEvery(final Quantified quantified) {
        Boolean res;
        final String noneOrEveryVariableName = ((IteratorVariable)quantified.getVariables().get(0)).getVarName();
        Object noneOrEveryVariableValue = this.doSwitch((EObject)((IteratorVariable)quantified.getVariables().get(0)).getElement());
        final HashMap<String, Object> noneOrEveryVariables = new HashMap<String, Object>(this.variablesStack.peek());
        this.variablesStack.push(noneOrEveryVariables);
        Predicate<Object> noneOrEveryEveryPredicate = new Predicate<Object>(){

            @Override
            public boolean test(Object input) {
                noneOrEveryVariables.put(noneOrEveryVariableName, input);
                return FormulesInterpreter.this.toBoolean(FormulesInterpreter.this.doSwitch((EObject)quantified.getExpression()));
            }
        };
        Predicate<Object> noneOrEveryNonePredicate = new Predicate<Object>(){

            @Override
            public boolean test(Object input) {
                noneOrEveryVariables.put(noneOrEveryVariableName, input);
                return FormulesInterpreter.this.toBoolean(FormulesInterpreter.this.doSwitch((EObject)quantified.getExpression())) == false;
            }
        };
        try {
            res = noneOrEveryVariableValue instanceof Iterable ? Boolean.valueOf(Operators.everyIterable((Iterable)noneOrEveryVariableValue, noneOrEveryEveryPredicate) || Operators.everyIterable((Iterable)noneOrEveryVariableValue, noneOrEveryNonePredicate)) : Boolean.valueOf(Operators.every(noneOrEveryVariableValue, noneOrEveryEveryPredicate) || Operators.every(noneOrEveryVariableValue, noneOrEveryNonePredicate));
        }
        finally {
            this.variablesStack.pop();
        }
        return res;
    }

    public List<Object> caseValueList(ValueList valueList) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Literal value : valueList.getValues()) {
            res.add(this.doSwitch((EObject)value));
        }
        return res;
    }

    public Object caseVarRef(VarRef varRef) {
        return this.variablesStack.peek().get(varRef.getVarName());
    }

    private BigDecimal toDecimal(Object object) {
        return (BigDecimal)object;
    }

    private Boolean toBoolean(Object object) {
        return (Boolean)object;
    }

    private IMessageBlock toMessageBlock(Object object) {
        return (IMessageBlock)object;
    }

    private IMessageField<?> toMessageField(Object object) {
        return (IMessageField)object;
    }
}

