/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn.content;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.HeaderBlock;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.ReusedField;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.ogn.content.AbstractContentHelper;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ContentHelperField
extends AbstractContentHelper<Field> {
    public ContentHelperField(Map<EObject, Adapter> adapteursMap, SaturneItemProviderAdapterFactory saturneFactory) {
        super(adapteursMap, saturneFactory);
    }

    @Override
    public List<Object> getChildrenElt(Field field, MessageTreeObject currentMessageTreeObject, boolean registerAdapter) {
        ArrayList<Object> result = new ArrayList<Object>();
        Declaration declaration = currentMessageTreeObject.getDeclaration();
        if (field.getDataType() != null) {
            MessageTreeObject messageTreeObject = new MessageTreeObject(field.getDataType(), declaration, field);
            messageTreeObject.setParentMessageTreeObject(currentMessageTreeObject);
            result.add(messageTreeObject);
        }
        FieldRefinement refinement = null;
        if (declaration != null) {
            refinement = (FieldRefinement)declaration.getFieldRefinements().get(field);
        }
        boolean forbbidenUsage = false;
        if (refinement != null) {
            MessageTreeObject messageTreeObject = new MessageTreeObject(refinement, declaration, field);
            messageTreeObject.setParentMessageTreeObject(currentMessageTreeObject);
            result.add(messageTreeObject);
            forbbidenUsage = UsageType.FORBIDDEN.equals((Object)refinement.getUsage());
        } else {
            forbbidenUsage = UsageType.FORBIDDEN.equals((Object)field.getUsage());
        }
        if (!forbbidenUsage) {
            EList eList = field.getRules();
            for (GenericRule genericRule : eList) {
                MessageTreeObject messageTreeObject = new MessageTreeObject(genericRule, declaration, field);
                messageTreeObject.setParentMessageTreeObject(currentMessageTreeObject);
                result.add(messageTreeObject);
            }
        }
        for (Object e : result) {
            if (!(e instanceof MessageTreeObject) || !(((MessageTreeObject)e).getElement() instanceof EObject)) continue;
            this.registerAdapter((EObject)((MessageTreeObject)e).getElement(), registerAdapter);
        }
        return result;
    }

    @Override
    public MessageTreeObject getParent(Field field, MessageTreeObject currentMessageTreeObject) {
        MessageTreeObject returnMsg = null;
        EObject parent = field.eContainer();
        EObject grandParent = null;
        if (parent != null) {
            grandParent = parent.eContainer();
        }
        if (parent instanceof HeaderBlock || grandParent instanceof Message) {
            grandParent = this.getStandard((EObject)field);
        }
        Declaration declaration = null;
        if (this.getParentDeclarationBlock((EObject)field) != null) {
            declaration = currentMessageTreeObject.getDeclaration();
        }
        if (parent != null) {
            returnMsg = new MessageTreeObject(parent, declaration, grandParent);
        }
        return returnMsg;
    }

    @Override
    public List<MessageTreeObject> getObjectsToRefresh(Field field, Notification notification) {
        ArrayList<MessageTreeObject> resultList = new ArrayList<MessageTreeObject>();
        DeclarationBlock parentDeclBlock = this.getParentDeclarationBlock((EObject)field);
        if (parentDeclBlock == null) {
            resultList.add(new MessageTreeObject(field, null, field.eContainer()));
            resultList.add(new MessageTreeObject(field.getDataType(), null, field));
        } else {
            Standard std = this.getStandard((EObject)field);
            for (Declaration decl : std.getDeclarations()) {
                FieldRefinement refinement = null;
                if (decl != null) {
                    resultList.add(new MessageTreeObject(field, decl, field.eContainer()));
                    resultList.add(new MessageTreeObject(field.getDataType(), decl, field));
                    refinement = (FieldRefinement)decl.getFieldRefinements().get(field);
                }
                if (refinement == null) continue;
                resultList.add(new MessageTreeObject(refinement, decl, field));
            }
        }
        if (field.eContainer() instanceof ReusedBlock) {
            ReusedBlock parentReusedBlock = (ReusedBlock)field.eContainer();
            for (Block reusingBlock : parentReusedBlock.getReusingBlocks()) {
                for (ReusedField reusedField : reusingBlock.getReusedFields()) {
                    if (!reusedField.getId().equals(field.getId())) continue;
                    resultList.add(new MessageTreeObject(reusedField, null, reusingBlock));
                }
            }
        }
        return resultList;
    }

    @Override
    public MessageTreeObject getObjectToSelect(Field field) {
        MessageTreeObject result = null;
        DeclarationBlock parentDeclBlock = this.getParentDeclarationBlock((EObject)field);
        Standard std = this.getStandard((EObject)field);
        if (parentDeclBlock == null) {
            result = new MessageTreeObject(field, null, field.eContainer());
        } else if (std != null) {
            for (Declaration decl : std.getDeclarations()) {
                if (!this.isDisplayed((EObject)field, decl)) continue;
                result = new MessageTreeObject(field, decl, field.eContainer());
                break;
            }
        }
        return result;
    }
}

