/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn.content;

import fr.cnav.saturne.DataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.ExternalDataTable;
import fr.cnav.saturne.ExternalDataType;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.ogn.content.AbstractContentHelper;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import fr.cnav.saturne.utils.DataTypeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;

public class ContentHelperDataType
extends AbstractContentHelper<DataType> {
    private DataTypeUtil dataTypeUtil = new DataTypeUtil();

    public ContentHelperDataType(Map<EObject, Adapter> adapteursMap, SaturneItemProviderAdapterFactory saturneFactory) {
        super(adapteursMap, saturneFactory);
    }

    @Override
    public List<Object> getChildrenElt(DataType dataType, MessageTreeObject currentMessageTreeObject, boolean registerAdapter) {
        MessageTreeObject messageTreeObject;
        Declaration declaration;
        ArrayList<Object> result = new ArrayList<Object>();
        if (dataType instanceof EnumDataType) {
            EnumDataType enumDataType = (EnumDataType)dataType;
            declaration = currentMessageTreeObject.getDeclaration();
            for (Value value : enumDataType.getValues()) {
                messageTreeObject = new MessageTreeObject(value, declaration, enumDataType);
                messageTreeObject.setParentMessageTreeObject(currentMessageTreeObject);
                result.add(messageTreeObject);
            }
        } else if (dataType instanceof ExternalDataType) {
            ExternalDataType externalDataType = (ExternalDataType)dataType;
            declaration = currentMessageTreeObject.getDeclaration();
            for (ExternalDataTable externalDataTable : externalDataType.getExternalDataTables()) {
                messageTreeObject = new MessageTreeObject(externalDataTable, declaration, externalDataType);
                messageTreeObject.setParentMessageTreeObject(currentMessageTreeObject);
                result.add(messageTreeObject);
            }
        }
        for (Object e : result) {
            if (!(e instanceof MessageTreeObject) || !(((MessageTreeObject)e).getElement() instanceof EObject)) continue;
            this.registerAdapter((EObject)((MessageTreeObject)e).getElement(), registerAdapter);
        }
        return result;
    }

    @Override
    public MessageTreeObject getParent(DataType dataType, MessageTreeObject currentMessageTreeObject) {
        MessageTreeObject returnMsg = null;
        Object parent = currentMessageTreeObject.getParentElement();
        Declaration declaration = currentMessageTreeObject.getDeclaration();
        if (parent != null && parent instanceof EObject) {
            EObject grandPrent = ((EObject)parent).eContainer();
            returnMsg = new MessageTreeObject(parent, declaration, grandPrent);
        }
        return returnMsg;
    }

    @Override
    public List<MessageTreeObject> getObjectsToRefresh(DataType dataType, Notification notification) {
        ArrayList<MessageTreeObject> resultList = new ArrayList<MessageTreeObject>();
        if (this.hasFieldListWithDT(dataType)) {
            for (Field field : this.getFieldListWithDT(dataType)) {
                if (this.getParentDeclarationBlock((EObject)field) == null) {
                    MessageTreeObject messageTreeObject = new MessageTreeObject(dataType, null, field);
                    resultList.add(messageTreeObject);
                    continue;
                }
                Standard standard = this.getStandard((EObject)dataType);
                for (Declaration declaration : standard.getDeclarations()) {
                    if (!this.isDisplayed((EObject)dataType, declaration)) continue;
                    MessageTreeObject messageTreeObject = new MessageTreeObject(dataType, declaration, field);
                    resultList.add(messageTreeObject);
                }
            }
        }
        return resultList;
    }

    @Override
    public MessageTreeObject getObjectToSelect(DataType dataType) {
        MessageTreeObject result = null;
        Standard standard = this.getStandard((EObject)dataType);
        if (this.hasFieldListWithDT(dataType)) {
            for (Field field : this.getFieldListWithDT(dataType)) {
                if (this.getParentDeclarationBlock((EObject)field) == null) {
                    return new MessageTreeObject(dataType, null, field);
                }
                for (Declaration declaration : standard.getDeclarations()) {
                    if (!this.isDisplayed((EObject)dataType, declaration)) continue;
                    return new MessageTreeObject(dataType, declaration, field);
                }
            }
        }
        return result;
    }

    public boolean hasFieldListWithDT(DataType dataType) {
        return this.getFieldListWithDT(dataType) != null && this.getFieldListWithDT(dataType).size() != 0;
    }

    public List<Field> getFieldListWithDT(DataType dataType) {
        return this.dataTypeUtil.getFieldListWithDT(dataType);
    }

    public Field getFirstFieldWithDT(DataType dataType) {
        return this.dataTypeUtil.getFirstFieldWithDT(dataType);
    }
}

