/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn.content;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.BoundRefinement;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.ogn.content.AbstractContentHelper;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ContentHelperBlock
extends AbstractContentHelper<Block> {
    public ContentHelperBlock(Map<EObject, Adapter> adapteursMap, SaturneItemProviderAdapterFactory saturneFactory) {
        super(adapteursMap, saturneFactory);
    }

    @Override
    public List<Object> getChildrenElt(Block parentBlock, MessageTreeObject currentMessageTreeObject, boolean registerAdapter) {
        ArrayList<Object> result = new ArrayList<Object>();
        Declaration declaration = currentMessageTreeObject.getDeclaration();
        if (declaration != null && declaration.getKeyValues() != null) {
            this.registerAdapterFieldToValueMap(declaration, registerAdapter);
        }
        BlockRefinement refinement = null;
        if (declaration != null) {
            refinement = (BlockRefinement)declaration.getBlockRefinements().get(parentBlock);
        }
        if (refinement != null) {
            result.add(new MessageTreeObject(refinement, declaration, parentBlock));
            BoundRefinement upperBoundRefinement = refinement.getUpperBound();
            this.registerAdapter((EObject)upperBoundRefinement, registerAdapter);
            BoundRefinement boundRefinement = refinement.getLowerBound();
            this.registerAdapter((EObject)boundRefinement, registerAdapter);
        }
        boolean forbbidenUsage = this.hasForbiddenUsage(refinement, parentBlock);
        result.addAll(this.computeMsgTreeObjList(parentBlock, declaration, forbbidenUsage));
        if (parentBlock.getBindings() != null) {
            result.add(new MessageTreeObject(parentBlock.getBindings(), null, parentBlock));
        }
        for (Object e : result) {
            if (!(e instanceof MessageTreeObject) || !(((MessageTreeObject)e).getElement() instanceof EObject)) continue;
            this.registerAdapter((EObject)((MessageTreeObject)e).getElement(), registerAdapter);
        }
        return result;
    }

    private List<Object> computeMsgTreeObjList(Block aBlock, Declaration declaration, boolean forbbidenUsage) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (!forbbidenUsage) {
            EList fields = aBlock.getChildrenFields();
            EList blocks = aBlock.getChildrenBlocks();
            for (Field field : fields) {
                result.add(new MessageTreeObject(field, declaration, aBlock));
            }
            for (Block block : blocks) {
                if (block instanceof DeclarationBlock) continue;
                result.add(new MessageTreeObject(block, declaration, aBlock));
            }
        }
        return result;
    }

    private boolean hasForbiddenUsage(BlockRefinement refinement, Block parentBlock) {
        boolean forbbidenUsage = false;
        forbbidenUsage = refinement != null ? UsageType.FORBIDDEN.equals((Object)refinement.getUsage()) || refinement.getUpperBound() != null && refinement.getUpperBound().getNewBound() == 0 : UsageType.FORBIDDEN.equals((Object)parentBlock.getUsage()) || parentBlock.getUpperBound() == 0;
        return forbbidenUsage;
    }

    @Override
    public MessageTreeObject getParent(Block block, MessageTreeObject currentMessageTreeObject) {
        MessageTreeObject returnMsg = null;
        EObject parent = this.getParent((EObject)block);
        EObject grandParent = this.getParent(parent);
        Declaration declaration = null;
        if (this.getParentDeclarationBlock(parent) != null) {
            declaration = currentMessageTreeObject.getDeclaration();
        }
        if (parent != null) {
            returnMsg = new MessageTreeObject(parent, declaration, grandParent);
        }
        return returnMsg;
    }

    private EObject getParent(EObject block) {
        Object parent = null;
        if (block != null) {
            parent = block.eContainer() instanceof Block ? block.eContainer() : this.getStandard(block);
        }
        return parent;
    }

    @Override
    public List<MessageTreeObject> getObjectsToRefresh(Block block, Notification notification) {
        ArrayList<MessageTreeObject> resultList = new ArrayList<MessageTreeObject>();
        DeclarationBlock parentDeclBlock = this.getParentDeclarationBlock((EObject)block);
        Standard standard = this.getStandard((EObject)block);
        EObject parentBlock = this.getParent((EObject)block);
        if (parentDeclBlock != null) {
            for (Declaration decl : standard.getDeclarations()) {
                resultList.add(new MessageTreeObject(block, decl, parentBlock));
                BlockRefinement refinement = null;
                if (decl != null) {
                    refinement = (BlockRefinement)decl.getBlockRefinements().get(block);
                }
                if (refinement == null) continue;
                resultList.add(new MessageTreeObject(refinement, decl, block));
            }
        } else {
            resultList.add(new MessageTreeObject(block, null, parentBlock));
        }
        return resultList;
    }

    @Override
    public MessageTreeObject getObjectToSelect(Block block) {
        MessageTreeObject result = null;
        DeclarationBlock parentDeclBlock = this.getParentDeclarationBlock((EObject)block);
        Standard standard = this.getStandard((EObject)block);
        EObject blockParent = this.getParent((EObject)block);
        if (parentDeclBlock == null) {
            result = new MessageTreeObject(block, null, blockParent);
        } else if (standard != null) {
            for (Declaration decl : standard.getDeclarations()) {
                if (!this.isDisplayed((EObject)block, decl)) continue;
                result = new MessageTreeObject(block, decl, blockParent);
                break;
            }
        }
        return result;
    }
}

