/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.p03v01.all.rules;

import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleRegistry;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import n4ds.dsn.p03v01.all.rules.IExecutorAndCleaner;
import n4ds.dsn.p03v01.all.rules.RuleRegistryHelper;
import n4ds.dsn.p03v01.all.rules.StructureConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorAndCleanerS21_G00_98
implements IExecutorAndCleaner,
StructureConstants {
    private final Logger LOGGER = LoggerFactory.getLogger(ExecutorAndCleanerS21_G00_98.class);
    private final StandardAccessor modelAccessor;
    private final IRuleRegistry syntacticRuleRegistry;
    private final Properties ruleInhibitionProperties;

    public ExecutorAndCleanerS21_G00_98(StandardAccessor modelAccessor, IRuleRegistry syntacticRuleRegistry, Properties ruleInhibitionProperties) {
        this.modelAccessor = modelAccessor;
        this.syntacticRuleRegistry = syntacticRuleRegistry;
        this.ruleInhibitionProperties = ruleInhibitionProperties;
    }

    @Override
    public void runRules(IMessageBlock block, DeclarationDescription declaration, RuleRegistryHelper.NormDeclarationType declType, IReportLogger theReportLogger, boolean validateSyntactic, boolean validateSemantic, boolean unloadingActivated) throws TreeProcessingException {
        HashMap<String, Iterable> msgBlockList = new HashMap<String, Iterable>();
        Iterable ctxt = Stream.of(block).collect(Collectors.toList());
        msgBlockList.put("S21_G00_98", ctxt);
        if (validateSyntactic) {
            Set ruleSet = this.syntacticRuleRegistry.getRulesForContext((BlockDescription)block.getStandardBlockDescription(), declaration);
            for (IRule rule : ruleSet) {
                this.checkRule(rule, block, theReportLogger);
            }
        }
        if (unloadingActivated) {
            block.eraseField(1);
            block.eraseField(2);
        }
        if (validateSemantic && declType != null) {
            switch (declType) {
                case DSN_Mensuelle: {
                    break;
                }
                case DSN_SIGNAL_REPRISE_TRAVAIL: {
                    break;
                }
                case DSN_SIGNAL_ARRET_TRAVAIL: {
                    break;
                }
                case DSN_SIGNAL_FIN_CONTRAT_UNIQUE: {
                    break;
                }
                case DSN_SIGNAL_AMORCAGE: {
                    break;
                }
                case DSN_SUBSTITUTION: {
                    break;
                }
                case DSN_NEANT: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    private void checkRule(IRule rule, IMessageBlock messageBlock, IReportLogger reportLogger) throws TreeProcessingException {
        IRuleResult result = null;
        try {
            result = rule.run(messageBlock);
        }
        catch (Exception e) {
            this.LOGGER.error("Problem with the executed rule " + rule.getClass().getSimpleName() + " - " + e.getClass().getName() + ", message = " + e.getMessage());
            if (e.getCause() != null && e.getCause() != e) {
                this.LOGGER.error(String.valueOf(e.getCause().getClass().getName()) + ", message = " + e.getCause().getMessage());
            }
            this.LOGGER.warn("EXC-3 : The rule ''" + rule.getCode() + "'' cause an unexpected exception : " + e.getMessage(), (Throwable)e);
        }
        this.reportResult(result, reportLogger);
    }

    private void reportResult(IRuleResult result, IReportLogger reportLogger) throws TreeProcessingException {
        Boolean resultSuccess;
        if (result != null && !(resultSuccess = (Boolean)result.getResult()).booleanValue()) {
            try {
                reportLogger.logResult(result);
            }
            catch (TooManyAnomaliesException e) {
                throw new TreeProcessingException((Throwable)e);
            }
        }
    }

    private void execRule(IRule rule, String ruleFullId, IMessageBlock blockRuleCtxt, IReportLogger theReportLogger) throws TreeProcessingException {
        if (this.ruleInhibitionProperties == null || this.ruleInhibitionProperties.get(ruleFullId) == null || !RuleCriticity.INACTIVE.getLiteral().toLowerCase().equals(this.ruleInhibitionProperties.get(ruleFullId).toString().toLowerCase())) {
            this.checkRule(rule, blockRuleCtxt, theReportLogger);
        }
    }

    private void removeField(Iterable<IMessageBlock> blockIt, int fieldToClean) {
        for (IMessageBlock blockParent : blockIt) {
            blockParent.eraseField(fieldToClean);
        }
    }
}

