/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.provider;

import fr.cnav.saturne.DataType;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.IdQualifiedElement;
import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.impl.FieldToValueMapImpl;
import fr.cnav.saturne.provider.SaturneEditPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class FieldToValueMapItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public FieldToValueMapItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addKeyPropertyDescriptor(object);
            this.addValuePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    private Collection<?> getAllPrimaryKeyField(Standard standard) {
        UniqueEList results = new UniqueEList();
        TreeIterator eAllContents = standard.getMessage().eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            if (!(eObject instanceof Field) || !((Field)eObject).isDeclarationKey()) continue;
            results.add((Object)eObject);
        }
        return results;
    }

    protected void addKeyPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FieldToValueMap_key_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FieldToValueMap_key_feature", "_UI_FieldToValueMap_type"), (EStructuralFeature)SaturnePackage.Literals.FIELD_TO_VALUE_MAP__KEY, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                FieldToValueMapImpl fieldToValueMap = (FieldToValueMapImpl)object;
                Standard standard = (Standard)fieldToValueMap.eContainer().eContainer();
                return FieldToValueMapItemProvider.this.getAllPrimaryKeyField(standard);
            }

            public IItemLabelProvider getLabelProvider(Object object) {
                return new ItemPropertyDescriptor.ItemDelegator(this, FieldToValueMapItemProvider.this.getRootAdapterFactory(), FieldToValueMapItemProvider.this.getResourceLocator()){

                    public String getText(Object object) {
                        if (object instanceof IdQualifiedElement) {
                            return String.valueOf(((IdQualifiedElement)object).getFullQualifiedId()) + " - " + ((IdQualifiedElement)object).getName();
                        }
                        return super.getText(object);
                    }
                };
            }
        });
    }

    private Collection<?> getAllValuesOfPrimaryKey(Field field) {
        UniqueEList results = new UniqueEList();
        DataType dataType = field.getDataType();
        if (dataType != null && dataType instanceof EnumDataType) {
            EnumDataType enumDataType = (EnumDataType)dataType;
            EList activeValues = enumDataType.getValues();
            results.addAll((Collection)activeValues);
        }
        return results;
    }

    protected void addValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FieldToValueMap_value_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FieldToValueMap_value_feature", "_UI_FieldToValueMap_type"), (EStructuralFeature)SaturnePackage.Literals.FIELD_TO_VALUE_MAP__VALUE, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                FieldToValueMapImpl fieldToValueMap = (FieldToValueMapImpl)object;
                if (fieldToValueMap.getKey() == null) {
                    return new UniqueEList();
                }
                return FieldToValueMapItemProvider.this.getAllValuesOfPrimaryKey(fieldToValueMap.getKey());
            }

            public IItemLabelProvider getLabelProvider(Object object) {
                return new ItemPropertyDescriptor.ItemDelegator(this, FieldToValueMapItemProvider.this.getRootAdapterFactory(), FieldToValueMapItemProvider.this.getResourceLocator()){

                    public String getText(Object object) {
                        if (object instanceof IdQualifiedElement) {
                            return String.valueOf(((IdQualifiedElement)object).getFullQualifiedId()) + " - " + ((IdQualifiedElement)object).getName();
                        }
                        return super.getText(object);
                    }
                };
            }
        });
    }

    public Object getImage(Object object) {
        if (object instanceof FieldToValueMapImpl) {
            FieldToValueMapImpl fieldToValueMap = (FieldToValueMapImpl)object;
            Object fieldImage = null;
            Field field = fieldToValueMap.getKey();
            if (field != null) {
                switch (field.getUsage().getValue()) {
                    case 2: {
                        fieldImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Field-Conditional"));
                        break;
                    }
                    case 4: {
                        fieldImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Field-Forbidden"));
                        break;
                    }
                    case 3: {
                        fieldImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Field-Mandatory"));
                        break;
                    }
                    case 1: {
                        fieldImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Field-Optional"));
                        break;
                    }
                    case 5: {
                        fieldImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Field-Unset"));
                        break;
                    }
                }
            }
            if (fieldImage != null) {
                ArrayList<Object> images = new ArrayList<Object>();
                images.add(fieldImage);
                images.add(this.getResourceLocator().getImage("full/obj16/PrimaryKey"));
                return this.overlayImage(object, new ComposedImage(images));
            }
        }
        return null;
    }

    public String getText(Object object) {
        FieldToValueMapImpl fieldToValueMapImpl = (FieldToValueMapImpl)object;
        Field key = fieldToValueMapImpl.getKey();
        EList values = fieldToValueMapImpl.getValue();
        StringBuilder result = new StringBuilder();
        if (key == null) {
            result.append("*undefined*");
        } else {
            String id = key.getId() != null ? key.getId() : "";
            result.append(id);
            if (values != null) {
                String idValue;
                result.append(" = ");
                result.append("{");
                if (values.size() > 0) {
                    idValue = ((Value)values.get(0)).getId() != null ? ((Value)values.get(0)).getId() : "";
                    result.append(idValue);
                }
                if (values.size() > 1) {
                    int i = 1;
                    while (i < values.size()) {
                        result.append(",");
                        idValue = ((Value)values.get(i)).getId() != null ? ((Value)values.get(i)).getId() : "";
                        result.append(idValue);
                        ++i;
                    }
                }
                result.append("}");
            }
        }
        return result.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (notification.getFeature() != null && (notification.getFeature().equals(SaturnePackage.Literals.FIELD_TO_VALUE_MAP__KEY) || notification.getFeature().equals(SaturnePackage.Literals.FIELD_TO_VALUE_MAP__VALUE))) {
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return SaturneEditPlugin.INSTANCE;
    }
}

