/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.views;

import fr.cnav.autocontrol.export.Activator;
import fr.cnav.autocontrol.export.ReportExporter;
import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.dialogs.ProgressMonitorWithTitle;
import fr.cnav.autocontrole.ui.views.ExportWizardPage;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.SerializationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ExportWizard
extends Wizard {
    private ExportWizardPage page;
    private String exportFilePath;
    private String selectedContentType;

    public ExportWizard() {
        this.setWindowTitle(Messages.ExportWizard_0);
    }

    public void addPages() {
        this.page = new ExportWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        block6: {
            try {
                if (this.page == null) break block6;
                this.exportFilePath = this.page.getFile();
                this.selectedContentType = this.page.getContentType();
                try {
                    ProgressMonitorWithTitle dialog = new ProgressMonitorWithTitle(this.getShell(), Messages.ExportHandler_0);
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.setTaskName(Messages.ExportWizard_1);
                            String defaultContentType = StandardHelper.getInstance().getSerializerFactory().getDefaultContentType();
                            if (ExportWizard.this.selectedContentType.equals(defaultContentType)) {
                                try {
                                    ReportExporter.exportWithDefaultSerializer((File)MessageFile.getInstance().getReportFile(), (String)ExportWizard.this.exportFilePath, (IProgressMonitor)monitor);
                                }
                                catch (IOException e) {
                                    throw new AutoCtrlException(ExceptionKind.CANNOT_EXPORT_XML, (Throwable)e);
                                }
                            }
                            IReportSerializer serializer = StandardHelper.getInstance().getSerializerFactory().getNormSerializer(ExportWizard.this.selectedContentType).getReportSerializer();
                            try {
                                ReportExporter.exportWithSerializer((String)ExportWizard.this.exportFilePath, (IProgressMonitor)monitor, (IReportSerializer)serializer, (IReportLogger)MessageFile.getInstance().getReportResult());
                            }
                            catch (AutoCtrlException e) {
                                throw new AutoCtrlException(ExceptionKind.CANNOT_EXPORT_XML, (Throwable)e);
                            }
                            catch (FileNotFoundException e) {
                                throw new AutoCtrlException(ExceptionKind.CANNOT_EXPORT_XML, (Throwable)e);
                            }
                            catch (SerializationException e) {
                                throw new AutoCtrlException(ExceptionKind.CANNOT_EXPORT_XML, (Throwable)e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof AutoCtrlException) {
                        e.getTargetException().printStackTrace();
                        Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", e.getCause().getMessage(), (Throwable)e));
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportHandler_0, (String)e.getCause().getMessage());
                        break block6;
                    }
                    e.printStackTrace();
                    Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_TECHNIC_EXPORT.getMessage(), (Throwable)e));
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportHandler_0, (String)String.format(ExceptionKind.ERROR_TECHNIC_EXPORT.getMessage(), new Object[0]));
                    this.showErrorLog();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_TECHNIC_EXPORT.getMessage(), (Throwable)e));
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportHandler_0, (String)String.format(ExceptionKind.ERROR_TECHNIC_EXPORT.getMessage(), new Object[0]));
                    this.showErrorLog();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_TECHNIC_EXPORT.getMessage(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportHandler_0, (String)String.format(ExceptionKind.ERROR_TECHNIC_EXPORT.getMessage(), new Object[0]));
                this.showErrorLog();
            }
        }
        return true;
    }

    private void showErrorLog() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
            Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_OPENING_ERROR_LOG.getMessage(), (Throwable)e));
        }
    }

    public String getExportFilePath() {
        return this.exportFilePath;
    }

    public String getExportFormat() {
        return this.selectedContentType;
    }

    public boolean isComplete() {
        return this.page.isPageComplete();
    }
}

