/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.proxy;

import fr.cnav.autocontrole.ui.proxy.AbstractPreferenceDialog;
import fr.cnav.autocontrole.ui.proxy.ReflectUtil;
import java.lang.reflect.Method;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.net.ProxyPreferencePage;

public class ProxyPreferenceDialog
extends AbstractPreferenceDialog {
    public ProxyPreferenceDialog(Shell parentShell) {
        super(parentShell, "Network Proxy Settings");
    }

    @Override
    protected String getDefaultMessage() {
        return "Adjust your network proxy settings.";
    }

    @Override
    protected PreferencePage createPreferencePage() {
        return new ProxyPreferencePageWithoutHelp();
    }

    private static final class ProxyPreferencePageWithoutHelp
    extends ProxyPreferencePage {
        public ProxyPreferencePageWithoutHelp() {
            this.noDefaultAndApplyButton();
        }

        protected Control createContents(Composite parent) {
            final Composite mainComposite = new Composite(parent, 0);
            mainComposite.setLayout((Layout)new GridLayout(1, false));
            mainComposite.setLayoutData((Object)new GridData(1808));
            final ScrolledComposite scrolledComposite = new ScrolledComposite(mainComposite, 512);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setLayoutData((Object)new GridData(1808));
            final Composite composite = new Composite((Composite)scrolledComposite, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            composite.setLayout((Layout)layout);
            scrolledComposite.setContent((Control)composite);
            composite.setLayoutData((Object)new GridData(768));
            int providerHeight = this.createProviderComposite(composite);
            int proxyEntriesHeight = this.createProxyEntriesComposite(composite);
            this.createNonProxiedHostsComposite(composite, proxyEntriesHeight);
            this.applyDialogFont(composite);
            this.initializeValues();
            ControlAdapter resizeListener = new ControlAdapter(providerHeight, proxyEntriesHeight){
                int height;
                {
                    this.height = n + 2 * n2 - 10;
                }

                public void controlResized(ControlEvent event) {
                    int width = mainComposite.getClientArea().x;
                    Point size = composite.computeSize(width, this.height - 10);
                    scrolledComposite.setMinSize(size);
                }
            };
            scrolledComposite.addControlListener((ControlListener)resizeListener);
            composite.addControlListener((ControlListener)resizeListener);
            composite.notifyListeners(11, new Event());
            return composite;
        }

        private int createProviderComposite(Composite composite) {
            Method method = ReflectUtil.getMethod(ProxyPreferencePage.class, "createProviderComposite", Composite.class);
            ReflectUtil.invokeMethod(method, (Object)this, composite);
            Control control = this.getLastChild(composite);
            Point size = control.computeSize(-1, -1);
            return size.y;
        }

        private int createProxyEntriesComposite(Composite composite) {
            Method method = ReflectUtil.getMethod(ProxyPreferencePage.class, "createProxyEntriesComposite", Composite.class);
            ReflectUtil.invokeMethod(method, (Object)this, composite);
            Control control = this.getLastChild(composite);
            Point size = control.computeSize(-1, -1);
            GridData layoutData = new GridData(4, 4, true, false);
            layoutData.minimumHeight = size.y;
            control.setLayoutData((Object)layoutData);
            return size.y;
        }

        private Control getLastChild(Composite composite) {
            Control[] children = composite.getChildren();
            Control control = children[children.length - 1];
            return control;
        }

        private void createNonProxiedHostsComposite(Composite composite, int height) {
            Method method = ReflectUtil.getMethod(ProxyPreferencePage.class, "createNonProxiedHostsComposite", Composite.class);
            ReflectUtil.invokeMethod(method, (Object)this, composite);
            Control control = this.getLastChild(composite);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.minimumHeight = height;
            control.setLayoutData((Object)layoutData);
        }

        private void initializeValues() {
            Method method = ReflectUtil.getMethod(ProxyPreferencePage.class, "initializeValues", new Class[0]);
            ReflectUtil.invokeMethod(method, (Object)this, new Object[0]);
        }
    }
}

