/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.providers;

import fr.cnav.autocontrole.providers.AnomalieLabelProvider;
import fr.cnav.autocontrole.ui.AutocontrolUiPlugin;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class AnomalieColumnLabelProvider
extends ColumnLabelProvider {
    private AnomalieLabelProvider anomalieLabelProvider;
    private int index;
    private final boolean showTooltip;

    public AnomalieColumnLabelProvider(int index, boolean showTooltip) {
        this.showTooltip = showTooltip;
        this.anomalieLabelProvider = new AnomalieLabelProvider();
        this.index = index;
    }

    public String getText(Object element) {
        return this.anomalieLabelProvider.getText(this.index, element);
    }

    public Object getValue(Object element) {
        return this.anomalieLabelProvider.getValue(this.index, element);
    }

    public Image getImage(Object element) {
        if (this.index != 0) {
            return super.getImage(element);
        }
        return this.anomalieLabelProvider.isBloquant(element) ? AutocontrolUiPlugin.getImage("icons/error.gif") : AutocontrolUiPlugin.getImage("icons/warning.gif");
    }

    public String getToolTipText(Object element) {
        if (element == null) {
            return "";
        }
        if (this.showTooltip) {
            return this.anomalieLabelProvider.getToolTip(element);
        }
        return super.getToolTipText(element);
    }

    public Point getToolTipShift(Object object) {
        if (this.showTooltip) {
            return new Point(-5, -5);
        }
        return super.getToolTipShift(object);
    }

    public int getToolTipTimeDisplayed(Object object) {
        if (this.showTooltip) {
            return super.getToolTipTimeDisplayed(object);
        }
        return super.getToolTipTimeDisplayed(object);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        if (this.showTooltip) {
            return 100;
        }
        return super.getToolTipDisplayDelayTime(object);
    }
}

