/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.handlers;

import fr.cnav.autocontrole.helpers.AnomalyHelper;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.views.NormeView;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.report.model.Anomaly;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenViewNormeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        try {
            Object selectedObject;
            IViewPart normeView = page.showView("fr.cnav.autocontrole.ui.views.NormeView");
            if (MessageFile.getInstance() != null && normeView instanceof NormeView && currentSelection instanceof StructuredSelection && (selectedObject = ((StructuredSelection)currentSelection).getFirstElement()) instanceof Anomaly) {
                StructuredSelection structuredSelection;
                StandardAccessor modelAccessor = StandardHelper.getInstance().getStandardAccessor();
                Object normeEltDescription = MessageFile.getInstance().getNormeElt(selectedObject);
                DeclarationDescription declDescription = AnomalyHelper.getDeclaration((Anomaly)((Anomaly)selectedObject));
                Declaration decl = null;
                if (declDescription != null) {
                    for (Declaration declaration : modelAccessor.getStandard().getDeclarations()) {
                        if (declaration.getName() == null || !declaration.getName().equals(declDescription.getName())) continue;
                        decl = declaration;
                    }
                }
                if (normeEltDescription != null) {
                    Block normeElt = null;
                    if (normeEltDescription instanceof BlockDescription) {
                        normeElt = modelAccessor.getBlock(((BlockDescription)normeEltDescription).getFullQualifiedId());
                    } else if (normeEltDescription instanceof FieldDescription) {
                        normeElt = modelAccessor.getField(((FieldDescription)normeEltDescription).getFullQualifiedId());
                    }
                    structuredSelection = new StructuredSelection((Object)new MessageTreeObject((Object)normeElt, decl));
                } else {
                    structuredSelection = new StructuredSelection();
                }
                if (structuredSelection != null) {
                    ((NormeView)normeView).getTreeViewer().setSelection((ISelection)structuredSelection);
                }
                shell.setFocus();
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)shell, (String)Messages.OpenViewNormeHandler_0, (String)(String.valueOf(Messages.OpenViewNormeHandler_1) + e.getMessage() + Messages.OpenViewNormeHandler_2));
        }
        return null;
    }

    public boolean isEnabled() {
        return !StandardHelper.getInstance().getNormSelector().isEmpty() && StandardHelper.getInstance().getNormSelector().getCurrentNormIdUsed() != null;
    }
}

