/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;

public class ChecksumHelper {
    public static final String MD5 = "md5";

    public static Map<String, String> getChecksums(IArtifactDescriptor descriptor, String property) throws IllegalArgumentException {
        if (!"artifact.checksum".equals(property) && !"download.checksum".equals(property)) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> checksumsByAlgo = new HashMap<String, String>();
        String md5Checksum = ChecksumHelper.getLegacyMd5Checksum(descriptor, property);
        if (md5Checksum != null) {
            checksumsByAlgo.put(MD5, md5Checksum);
        }
        for (Map.Entry<String, String> p : descriptor.getProperties().entrySet()) {
            String checksumValue;
            String checksumAlgorithmId;
            String duplicatedChecksum;
            String key = p.getKey();
            if (key.startsWith(property) && (duplicatedChecksum = checksumsByAlgo.put(checksumAlgorithmId = key.substring(property.length()).substring(1), checksumValue = Objects.requireNonNull(p.getValue()))) == null) continue;
        }
        return checksumsByAlgo;
    }

    private static String getLegacyMd5Checksum(IArtifactDescriptor descriptor, String property) {
        switch (property) {
            case "artifact.checksum": {
                return descriptor.getProperty("artifact.md5");
            }
            case "download.checksum": {
                return descriptor.getProperty("download.md5");
            }
        }
        return null;
    }

    public static String toHexString(byte[] digest) {
        StringBuilder buf = new StringBuilder();
        byte[] byArray = digest;
        int n = digest.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            if ((element & 0xFF) < 16) {
                buf.append('0');
            }
            buf.append(Integer.toHexString(element & 0xFF));
            ++n2;
        }
        return buf.toString();
    }
}

