/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.dsl.gen.common.navigation.IMessage;
import fr.cnav.saturne.dsl.gen.common.navigation.IMessageNode;

public class FieldBlockRefCardinalityTester {
    private static final String COULDN_T_FIND_A_COMMON_CONTEXT = "Couldn't find a common context for the nodes %s and %s.";
    private static final String COULDN_T_NAVIGATE_FROM_EMPTY_CONTEXT_TO = "Couldn't navigate from empty context to %s.";
    private static final String COULDN_T_NAVIGATE_FROM = "Couldn't navigate from %s to empty target.";
    private IMessage message;

    public FieldBlockRefCardinalityTester(IMessage message) {
        this.message = message;
    }

    public boolean isMultiple(String dslContextFQID, String targetFQID) {
        if (this.message == null) {
            return false;
        }
        IMessageNode dslContext = this.message.getMessageNode(dslContextFQID);
        IMessageNode target = this.message.getMessageNode(targetFQID);
        if (dslContextFQID != null && targetFQID != null && dslContext != null && target != null) {
            return this.isMultiple(dslContext, target);
        }
        return false;
    }

    private boolean isMultiple(IMessageNode dslContext, IMessageNode target) {
        int i;
        boolean result = false;
        IMessageNode currentContext = dslContext;
        IMessageNode currentTarget = target;
        int contextDepth = dslContext.getDepth();
        int targetDepth = currentTarget.getDepth();
        String targetName = currentTarget.getName();
        if (contextDepth > targetDepth) {
            int depthDiff = contextDepth - targetDepth;
            i = 0;
            while (i < depthDiff) {
                if (currentContext == null) {
                    throw new IllegalStateException(String.format(COULDN_T_NAVIGATE_FROM_EMPTY_CONTEXT_TO, targetName));
                }
                currentContext = currentContext.getParent();
                ++i;
            }
        } else if (contextDepth < targetDepth) {
            int depthDiff = targetDepth - contextDepth;
            i = 0;
            while (i < depthDiff) {
                if (currentTarget == null) {
                    throw new IllegalStateException(String.format(COULDN_T_NAVIGATE_FROM, currentContext.getName()));
                }
                IMessageNode child = currentTarget;
                currentTarget = currentTarget.getParent();
                if (child.isMany()) {
                    result = true;
                }
                ++i;
            }
        }
        while (!result && !currentTarget.equals(currentContext)) {
            currentTarget = currentTarget.getParent();
            currentContext = currentContext.getParent();
            IMessageNode child = currentTarget;
            if (currentTarget == null || currentContext == null) {
                throw new IllegalStateException(String.format(COULDN_T_FIND_A_COMMON_CONTEXT, dslContext.getName(), targetName));
            }
            if (!child.isMany() || currentTarget == currentContext) continue;
            result = true;
        }
        return result;
    }
}

