/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.Rule;
import fr.cnav.saturne.dsl.parser.FormuleTraducteurException;
import fr.cnav.saturne.utils.DslConvertPos;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.RecognitionException;

public class DSLErrorUtil {
    private static final String ERROR_PARSING_VIABLE_ALTERNATIVE_MESSAGE = " During parsing, viable alternative was not found for a valide DSL.\n";
    private static final String NEW_LINE = "\n";
    private static final String INTRO_MESSAGE = "%s has an invalid dsl expression.";
    private static final String DSL_WITH_ERR_TAGS = " Dsl With ERR tags : ";
    private static final String DSL_WITH_NO_ERR_TAGS = " Dsl : ";
    private static final char CLOSE_PARENTHESE = ')';
    private static final char OPEN_PARENTHESE = '(';
    private static final String CLOSE = "Close";
    private static final String OPEN = "Open";
    private static final String PARENTHESES_MISSING_ERROR_MESSAGE = " Perhaps some %s parentheses are missing. Number of missing %s parentheses : %s";
    private static final String PARSING_ERROR_MESSAGE = " Error parsing message : %s";
    private static final String EOF_MARKER = "<EOF>";
    private static final String ERR_MARKER = "<ERR>";

    public String getDslErrorMsg(Exception e, Rule rule, String objectLabel) {
        String errorMsg = this.getIntroDslErrorMsg(objectLabel);
        if (e instanceof FormuleTraducteurException) {
            errorMsg = String.valueOf(errorMsg) + " " + e.getMessage() + NEW_LINE;
        } else if (e.getCause() != null && e.getCause().getMessage() != null) {
            errorMsg = String.valueOf(errorMsg) + String.format(PARSING_ERROR_MESSAGE, e.getCause().getMessage()) + NEW_LINE;
        } else if (e.getMessage() != null && !(e instanceof FormuleTraducteurException)) {
            errorMsg = String.valueOf(errorMsg) + String.format(PARSING_ERROR_MESSAGE, e.getMessage()) + NEW_LINE;
        }
        if (e.getCause() != null && e.getCause() instanceof RecognitionException) {
            if (e.getCause() instanceof NoViableAltException || e.getCause() instanceof LexerNoViableAltException) {
                errorMsg = String.valueOf(errorMsg) + ERROR_PARSING_VIABLE_ALTERNATIVE_MESSAGE;
            }
            errorMsg = String.valueOf(errorMsg) + this.getDslWithErrorMarkPosition(rule, (RecognitionException)e.getCause());
        }
        errorMsg = String.valueOf(errorMsg) + this.completeErrorMessage(rule.getDslExpression());
        return errorMsg;
    }

    public String getIntroDslErrorMsg(String objectLabel) {
        return String.valueOf(String.format(INTRO_MESSAGE, objectLabel)) + NEW_LINE;
    }

    public String getDslWithErrorMarkAroundFirstString(String elementInError, String dslExpression) {
        StringBuilder result = new StringBuilder();
        if (dslExpression != null) {
            if (elementInError != null) {
                int startOfFieldId = dslExpression.indexOf(elementInError);
                int endOfFieldId = startOfFieldId + elementInError.length();
                result.append(NEW_LINE);
                result.append(DSL_WITH_ERR_TAGS);
                result.append(dslExpression.substring(0, startOfFieldId));
                result.append(ERR_MARKER);
                result.append(elementInError);
                result.append(ERR_MARKER);
                result.append(dslExpression.substring(endOfFieldId));
            } else {
                result.append(NEW_LINE);
                result.append(DSL_WITH_NO_ERR_TAGS);
                result.append(dslExpression);
            }
        }
        return result.toString();
    }

    public String getDslWithErrorMarkPosition(Rule rule, RecognitionException recognitionException) {
        StringBuilder result = new StringBuilder();
        int line = 0;
        String dsl = rule.getDslExpression();
        String[] stringArray = dsl.split(NEW_LINE);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dslLine = stringArray[n2];
            if (++line != 1) {
                result.append("                     ");
            }
            if (recognitionException.getOffendingToken() != null && line == recognitionException.getOffendingToken().getLine()) {
                result.append(DSL_WITH_ERR_TAGS);
                int startOffendingToken = recognitionException.getOffendingToken().getStartIndex();
                int stopOffendingToken = recognitionException.getOffendingToken().getStopIndex() + 1;
                String contextFQId = "";
                Block context = rule.getContext();
                if (context == null && rule.getSubject().eContainer() instanceof Block) {
                    contextFQId = ((Block)rule.getSubject().eContainer()).getFullQualifiedId();
                } else if (context == null && rule.getSubject().eContainer() instanceof ReusedBlock) {
                    contextFQId = ((ReusedBlock)rule.getSubject().eContainer()).getFullQualifiedId();
                }
                DslConvertPos dslConvertPos = new DslConvertPos(dsl, contextFQId, rule.getSubject().getFullQualifiedId(), null);
                int startErrorIndex = dslConvertPos.convertFromParsedPositionIntoModelPosition(startOffendingToken);
                int stopErrorIndex = dslConvertPos.convertFromParsedPositionIntoModelPosition(stopOffendingToken);
                if (dsl.length() > startErrorIndex && dsl.length() >= stopErrorIndex && startErrorIndex != -1 && stopErrorIndex >= startErrorIndex) {
                    result.append(dsl.substring(0, startErrorIndex));
                    result.append(ERR_MARKER);
                    result.append(dsl.substring(startErrorIndex, stopErrorIndex));
                    result.append(ERR_MARKER);
                    result.append(dsl.substring(stopErrorIndex));
                } else {
                    result.append(dsl);
                    result.append(ERR_MARKER);
                    result.append(EOF_MARKER);
                    result.append(ERR_MARKER);
                }
            } else {
                result.append(DSL_WITH_NO_ERR_TAGS);
                result.append(dslLine);
            }
            ++n2;
        }
        result.append(NEW_LINE);
        return result.toString();
    }

    public String completeErrorMessage(String dsl) {
        StringBuilder msg = new StringBuilder();
        if (this.missingCloseParent(dsl)) {
            msg.append(String.format(PARENTHESES_MISSING_ERROR_MESSAGE, CLOSE, CLOSE, this.countOpenCloseParentStat(dsl)));
            msg.append(NEW_LINE);
        } else if (this.missingOpenParent(dsl)) {
            msg.append(String.format(PARENTHESES_MISSING_ERROR_MESSAGE, OPEN, OPEN, -this.countOpenCloseParentStat(dsl)));
            msg.append(NEW_LINE);
        }
        return msg.toString();
    }

    private boolean missingCloseParent(String dsl) {
        return this.countOpenCloseParentStat(dsl) > 0;
    }

    private boolean missingOpenParent(String dsl) {
        return this.countOpenCloseParentStat(dsl) < 0;
    }

    private int countOpenCloseParentStat(String dsl) {
        int statOfOpenClosePrent = 0;
        char[] cArray = dsl.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '(') {
                ++statOfOpenClosePrent;
            } else if (c == ')') {
                --statOfOpenClosePrent;
            }
            ++n2;
        }
        return statOfOpenClosePrent;
    }
}

