/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.utils.BlockDeepestAncetorExtractor;
import java.util.List;
import java.util.Objects;

public class CardinalityExtractor {
    private boolean isMultiple;

    public CardinalityExtractor(MessageElement source, MessageElement target) {
        Objects.requireNonNull(source, "The source MessageElement should not be null.");
        Objects.requireNonNull(source.eContainer(), "The source MessageElement parent should not be null.");
        Objects.requireNonNull(target, "The target MessageElement should not be null.");
        Objects.requireNonNull(target.eContainer(), "The target MessageElement parent should not be null.");
        Block sourceBlock = null;
        if (source instanceof Field && source.eContainer() instanceof Block) {
            sourceBlock = (Block)source.eContainer();
        } else if (source instanceof Block) {
            sourceBlock = (Block)source;
        }
        Block targetBlock = null;
        if (target instanceof Field && target.eContainer() instanceof Block) {
            targetBlock = (Block)target.eContainer();
        } else if (target instanceof Block) {
            targetBlock = (Block)target;
        }
        Objects.requireNonNull(sourceBlock, "The source block is not found.");
        Objects.requireNonNull(targetBlock, "The target block is not found.");
        BlockDeepestAncetorExtractor blockDeepestAncetorExtractor = new BlockDeepestAncetorExtractor(sourceBlock, targetBlock);
        Objects.requireNonNull(blockDeepestAncetorExtractor.getDeepestAncestorBlock(), "The source and target block is not linked.");
        this.isMultiple = this.isMany(blockDeepestAncetorExtractor.getBlocksListFromDeepestAncestorToTgt());
    }

    private boolean isMany(List<MessageElement> navigationBlocksList) {
        MessageElement sourceBlock = null;
        MessageElement targetBlock = null;
        for (MessageElement block : navigationBlocksList) {
            if (targetBlock != null) {
                sourceBlock = targetBlock;
            }
            targetBlock = block;
            if (sourceBlock == null || targetBlock == null || !this.isMany(sourceBlock, targetBlock)) continue;
            return true;
        }
        return false;
    }

    private boolean isMany(MessageElement sourceMsgElt, MessageElement targetMsgElt) {
        if (sourceMsgElt instanceof Block && targetMsgElt instanceof Block) {
            Block sourceBlock = (Block)sourceMsgElt;
            Block targetBlock = (Block)targetMsgElt;
            if (sourceBlock.getChildrenBlocks().contains((Object)targetBlock)) {
                Objects.requireNonNull(Integer.valueOf(targetBlock.getUpperBound()), "All block in down path should not have an \"upper bound\" attribute setting to null.");
                if (targetBlock.getUpperBound() != 1 && targetBlock.getUpperBound() != 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }
}

