/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.util;

import fr.cnav.saturne.AbstractBinding;
import fr.cnav.saturne.Alias;
import fr.cnav.saturne.AlphanumericDataType;
import fr.cnav.saturne.BindingSet;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockContext;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.BoundRefinement;
import fr.cnav.saturne.CSVDataSource;
import fr.cnav.saturne.CSVExternalDataTable;
import fr.cnav.saturne.ControlType;
import fr.cnav.saturne.CsvDataValue;
import fr.cnav.saturne.DataSource;
import fr.cnav.saturne.DataSourceSet;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.DataTypeSet;
import fr.cnav.saturne.DateDataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.ExternalDataTable;
import fr.cnav.saturne.ExternalDataType;
import fr.cnav.saturne.ExternalFunctionDefinition;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldContext;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.FilterType;
import fr.cnav.saturne.ForeignKeyBinding;
import fr.cnav.saturne.FunctionBinding;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.HeaderBlock;
import fr.cnav.saturne.IdQualifiedElement;
import fr.cnav.saturne.JavaRule;
import fr.cnav.saturne.Macro;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.ModelAccessorWithNomenclaturesHandling;
import fr.cnav.saturne.NamedElement;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.NumericDataType;
import fr.cnav.saturne.Refinement;
import fr.cnav.saturne.ReportConfiguration;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.ReusedBlockSet;
import fr.cnav.saturne.ReusedField;
import fr.cnav.saturne.Rule;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.RuleSet;
import fr.cnav.saturne.RulesConfiguration;
import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.parser.FormuleTraducteur;
import fr.cnav.saturne.dsl.parser.FormuleTraducteurException;
import fr.cnav.saturne.dsl.parser.ParserConfigurationException;
import fr.cnav.saturne.dsl.parser.configuration.StandardParserConfiguration;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.ITypingEnvironment;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.utils.DSLErrorUtil;
import fr.cnav.saturne.utils.DslExpressionExtractor;
import fr.cnav.saturne.utils.ExternalFunctionUtil;
import fr.cnav.saturne.utils.FieldBlockRefCardinalityTester;
import fr.cnav.saturne.utils.RuleUtil;
import fr.cnav.saturne.utils.StandardFileUtil;
import fr.cnav.saturne.utils.StandardUtil;
import fr.cnav.saturne.utils.ValidatorJavaPkgIdFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class SaturneValidator
extends EObjectValidator {
    public static final String MODELS_DIRECTORY = "models";
    public static final String DATASOURCES_DIRECTORY = "datasources";
    public static final String VALID_NAME_DESCRIPTION_REGEX = "[^=;]*";
    public static final String STANDARD_ACCEPTED_NAME_PATTERN_STRING = "[A-Za-z][A-Za-z0-9_ \\-]*[A-Za-z0-9]+";
    public static final SaturneValidator INSTANCE = new SaturneValidator();
    public static final String DIAGNOSTIC_SOURCE = "fr.cnav.saturne";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return SaturnePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateNamedElement((NamedElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateIdQualifiedElement((IdQualifiedElement)value, diagnostics, context);
            }
            case 2: {
                return this.validateStandard((Standard)value, diagnostics, context);
            }
            case 3: {
                return this.validateMessageElement((MessageElement)value, diagnostics, context);
            }
            case 4: {
                return this.validateMessage((Message)value, diagnostics, context);
            }
            case 5: {
                return this.validateBlock((Block)value, diagnostics, context);
            }
            case 6: {
                return this.validateHeaderBlock((HeaderBlock)value, diagnostics, context);
            }
            case 7: {
                return this.validateDeclarationBlock((DeclarationBlock)value, diagnostics, context);
            }
            case 8: {
                return this.validateField((Field)value, diagnostics, context);
            }
            case 9: {
                return this.validateValue((Value)value, diagnostics, context);
            }
            case 10: {
                return this.validateDataType((DataType)value, diagnostics, context);
            }
            case 11: {
                return this.validateEnumDataType((EnumDataType)value, diagnostics, context);
            }
            case 12: {
                return this.validateAlphanumericDataType((AlphanumericDataType)value, diagnostics, context);
            }
            case 13: {
                return this.validateNumericDataType((NumericDataType)value, diagnostics, context);
            }
            case 14: {
                return this.validateDateDataType((DateDataType)value, diagnostics, context);
            }
            case 15: {
                return this.validateExternalDataType((ExternalDataType)value, diagnostics, context);
            }
            case 16: {
                return this.validateDataSource((DataSource)value, diagnostics, context);
            }
            case 17: {
                return this.validateCSVDataSource((CSVDataSource)value, diagnostics, context);
            }
            case 18: {
                return this.validateExternalDataTable((ExternalDataTable)value, diagnostics, context);
            }
            case 19: {
                return this.validateCSVExternalDataTable((CSVExternalDataTable)value, diagnostics, context);
            }
            case 20: {
                return this.validateGenericRule((GenericRule)value, diagnostics, context);
            }
            case 21: {
                return this.validateAlias((Alias)value, diagnostics, context);
            }
            case 22: {
                return this.validateMacro((Macro)value, diagnostics, context);
            }
            case 23: {
                return this.validateExternalFunctionDefinition((ExternalFunctionDefinition)value, diagnostics, context);
            }
            case 24: {
                return this.validateRulesConfiguration((RulesConfiguration)value, diagnostics, context);
            }
            case 25: {
                return this.validateDeclaration((Declaration)value, diagnostics, context);
            }
            case 26: {
                return this.validateFieldToValueMap((Map.Entry)value, diagnostics, context);
            }
            case 27: {
                return this.validateRefinement((Refinement)value, diagnostics, context);
            }
            case 28: {
                return this.validateBlockRefinement((BlockRefinement)value, diagnostics, context);
            }
            case 29: {
                return this.validateBoundRefinement((BoundRefinement)value, diagnostics, context);
            }
            case 30: {
                return this.validateFieldRefinement((FieldRefinement)value, diagnostics, context);
            }
            case 31: {
                return this.validateReportConfiguration((ReportConfiguration)value, diagnostics, context);
            }
            case 32: {
                return this.validateFieldContext((FieldContext)value, diagnostics, context);
            }
            case 33: {
                return this.validateBlockContext((BlockContext)value, diagnostics, context);
            }
            case 34: {
                return this.validateRuleSet((RuleSet)value, diagnostics, context);
            }
            case 35: {
                return this.validateDataTypeSet((DataTypeSet)value, diagnostics, context);
            }
            case 36: {
                return this.validateDataSourceSet((DataSourceSet)value, diagnostics, context);
            }
            case 37: {
                return this.validateJavaRule((JavaRule)value, diagnostics, context);
            }
            case 38: {
                return this.validateRule((Rule)value, diagnostics, context);
            }
            case 39: {
                return this.validateCsvDataValue((CsvDataValue)value, diagnostics, context);
            }
            case 40: {
                return this.validateReusedBlock((ReusedBlock)value, diagnostics, context);
            }
            case 41: {
                return this.validateReusedBlockSet((ReusedBlockSet)value, diagnostics, context);
            }
            case 42: {
                return this.validateReusedField((ReusedField)value, diagnostics, context);
            }
            case 43: {
                return this.validateAbstractBinding((AbstractBinding)value, diagnostics, context);
            }
            case 44: {
                return this.validateForeignKeyBinding((ForeignKeyBinding)value, diagnostics, context);
            }
            case 45: {
                return this.validateFunctionBinding((FunctionBinding)value, diagnostics, context);
            }
            case 46: {
                return this.validateBindingSet((BindingSet)value, diagnostics, context);
            }
            case 47: {
                return this.validateNatureType((NatureType)((Object)value), diagnostics, context);
            }
            case 48: {
                return this.validateUsageType((UsageType)((Object)value), diagnostics, context);
            }
            case 49: {
                return this.validateControlType((ControlType)((Object)value), diagnostics, context);
            }
            case 50: {
                return this.validateRuleCriticity((RuleCriticity)((Object)value), diagnostics, context);
            }
            case 51: {
                return this.validateFilterType((FilterType)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateNamedElement(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(namedElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(namedElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(namedElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateNamedElement_ValidateDescription(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && (namedElement.getDescription() == null || "".equals(namedElement.getDescription()))) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(1, DIAGNOSTIC_SOURCE, 0, "The following named element : '" + SaturneValidator.getObjectLabel((EObject)namedElement, context) + "' could have a description.", new Object[]{namedElement, SaturnePackage.Literals.NAMED_ELEMENT__DESCRIPTION});
            diagnostics.add((Diagnostic)diagnostic);
            return true;
        }
        return true;
    }

    public boolean validateNamedElement_ValidateName(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name;
        if (diagnostics != null && namedElement.getName() != null && !(name = namedElement.getName()).matches(VALID_NAME_DESCRIPTION_REGEX)) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The name of the element '" + SaturneValidator.getObjectLabel((EObject)namedElement, context) + "' must respect the following pattern : '" + VALID_NAME_DESCRIPTION_REGEX + "'", new Object[]{namedElement, SaturnePackage.Literals.NAMED_ELEMENT__NAME});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateIdQualifiedElement(IdQualifiedElement idQualifiedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(idQualifiedElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(idQualifiedElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(idQualifiedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(idQualifiedElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateIdQualifiedElement_FullQualifiedIdIsUnique(IdQualifiedElement idQualifiedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Standard standard;
        if (diagnostics != null && (standard = this.getStandard(idQualifiedElement)) != null) {
            TreeIterator eAllContents = standard.eAllContents();
            String fullQualifiedId = idQualifiedElement.getFullQualifiedId();
            if (fullQualifiedId != null) {
                while (eAllContents.hasNext()) {
                    EObject eObject = (EObject)eAllContents.next();
                    if (idQualifiedElement == eObject || !(eObject instanceof IdQualifiedElement) || !fullQualifiedId.equals(((IdQualifiedElement)eObject).getFullQualifiedId())) continue;
                    BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The validated element, '" + SaturneValidator.getObjectLabel((EObject)idQualifiedElement, context) + "' has a full qualified id equal to the element '" + SaturneValidator.getObjectLabel((EObject)eObject, context) + "'. This is forbidden.", new Object[]{idQualifiedElement});
                    diagnostics.add((Diagnostic)diagnostic);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateIdQualifiedElement_IdNotEmpty(IdQualifiedElement idQualifiedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String id;
        if (diagnostics != null && (id = idQualifiedElement.getId()) != null && "".equals(id.trim())) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The validated element '" + SaturneValidator.getObjectLabel((EObject)idQualifiedElement, context) + "' has an empty id. This is forbidden.", new Object[]{idQualifiedElement});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    private Standard getStandard(EObject eObject) {
        Standard result = null;
        if (eObject instanceof Standard) {
            result = (Standard)eObject;
        } else {
            boolean stopSearch = false;
            EObject currentElement = eObject;
            while (!stopSearch && result == null) {
                EObject eContainer = currentElement.eContainer();
                if (eContainer instanceof Standard) {
                    result = (Standard)eContainer;
                    continue;
                }
                if (eContainer == null) {
                    stopSearch = true;
                    continue;
                }
                currentElement = eContainer;
            }
        }
        return result;
    }

    public boolean validateStandard(Standard standard, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(standard, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(standard, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStandard_ValidVersionFormat(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStandard_ValidDateFormat(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStandard_ValidBlockRegex(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStandard_ValidFieldRegex(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStandard_ValidCharacterRegex(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStandard_ValidateStandardName(standard, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStandard_UniqGeneratedRulesClassNames(standard, diagnostics, context);
        }
        return result;
    }

    public boolean validateStandard_ValidVersionFormat(Standard standard, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            ValidatorJavaPkgIdFormat validatorJavaPckIdFormat = new ValidatorJavaPkgIdFormat();
            String version = standard.getVersion();
            if (validatorJavaPckIdFormat.isValideCaseInsessitive(version)) {
                if (validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_IS_EMPTY_OR_NULL) {
                    BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Version format of the Standard element should not be empty or null.", new Object[]{standard, SaturnePackage.Literals.STANDARD__VERSION});
                    diagnostics.add((Diagnostic)diagnostic);
                    return false;
                }
                if (validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_CONTAIN_FORRDIDEN_CHAR) {
                    BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Version format '" + standard.getVersion() + "' of the Standard element is invalid-> '" + validatorJavaPckIdFormat.getCharOrWordTriggerFailure() + "' is not an allowed character.", new Object[]{standard, SaturnePackage.Literals.STANDARD__VERSION});
                    diagnostics.add((Diagnostic)diagnostic);
                    return false;
                }
            } else if (validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_IS_KEYWORD) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Version format '" + standard.getVersion() + "' of the Standard element is invalid-> '" + validatorJavaPckIdFormat.getCharOrWordTriggerFailure() + "' is not an allowed word because java keyword is forbidden.", new Object[]{standard, SaturnePackage.Literals.STANDARD__VERSION});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateStandard_ValidDateFormat(Standard standard, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && standard.getDateFormat() != null && !"".equals(standard.getDateFormat())) {
            try {
                new SimpleDateFormat(standard.getDateFormat());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The date format '" + standard.getDateFormat() + "' of the Standard element is invalid.", new Object[]{standard, SaturnePackage.Literals.STANDARD__DATE_FORMAT});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateStandard_ValidBlockRegex(Standard standard, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && standard.getAllowedBlockRegex() != null && !"".equals(standard.getAllowedBlockRegex())) {
            try {
                Pattern.compile(standard.getAllowedBlockRegex());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Standard's allowed regular expression for block id, '" + standard.getAllowedBlockRegex() + "', is syntactically invalid.", new Object[]{standard, SaturnePackage.Literals.STANDARD__ALLOWED_BLOCK_REGEX});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateStandard_ValidFieldRegex(Standard standard, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && standard.getAllowedFieldRegex() != null && !"".equals(standard.getAllowedFieldRegex())) {
            try {
                Pattern.compile(standard.getAllowedFieldRegex());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Standard's allowed regular expression for field id, '" + standard.getAllowedFieldRegex() + "', is syntactically invalid.", new Object[]{standard, SaturnePackage.Literals.STANDARD__ALLOWED_FIELD_REGEX});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateStandard_ValidCharacterRegex(Standard standard, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && standard.getAllowedCharactersRegex() != null && !"".equals(standard.getAllowedCharactersRegex())) {
            try {
                Pattern.compile(standard.getAllowedCharactersRegex());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Standard's allowed regular expression for characters, '" + standard.getAllowedCharactersRegex() + "', is syntactically invalid.", new Object[]{standard, SaturnePackage.Literals.STANDARD__ALLOWED_CHARACTERS_REGEX});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateStandard_ValidateStandardName(Standard standard, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            String standardName;
            String string = standardName = standard.getName() == null ? "" : standard.getName();
            if (!standardName.matches(STANDARD_ACCEPTED_NAME_PATTERN_STRING)) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "The name of the standard element '" + SaturneValidator.getObjectLabel((EObject)standard, context) + "' must respect the following pattern : '[A-Za-z][A-Za-z0-9_ \\-]*[A-Za-z0-9]+'", new Object[]{standard, SaturnePackage.Literals.NAMED_ELEMENT__NAME});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateStandard_UniqGeneratedRulesClassNames(Standard standard, DiagnosticChain diagnostics, Map<Object, Object> context) {
        RuleSet ruleSet = standard.getRules();
        EList<GenericRule> rules = ruleSet.getRules();
        Map<GenericRule, GenericRule> duplicatesRules = new RuleUtil().getDuplicateRules((List<GenericRule>)rules);
        if (diagnostics != null && duplicatesRules.size() != 0) {
            for (Map.Entry<GenericRule, GenericRule> entry : duplicatesRules.entrySet()) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "Class name collision detected between the following rules : '" + entry.getKey().getName() + "', '" + entry.getValue().getName() + "' .", new Object[]{entry.getKey(), entry.getValue(), SaturnePackage.Literals.NAMED_ELEMENT__NAME});
                diagnostics.add((Diagnostic)diagnostic);
            }
            return false;
        }
        return true;
    }

    public boolean validateMessageElement(MessageElement messageElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(messageElement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(messageElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(messageElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageElement_UsageCantBeUnset(messageElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateMessageElement_UsageCantBeUnset(MessageElement messageElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && messageElement.getUsage() != null && UsageType.UNSET.equals((Object)messageElement.getUsage())) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The MessageElement '" + SaturneValidator.getObjectLabel((EObject)messageElement, context) + "' must not have its usage equal to 'unset'.", new Object[]{messageElement, SaturnePackage.Literals.MESSAGE_ELEMENT__USAGE});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateMessage(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(message, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(message, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(message, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageElement_UsageCantBeUnset(message, diagnostics, context);
        }
        return result;
    }

    public boolean validateBlock(Block block, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(block, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(block, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageElement_UsageCantBeUnset(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_BlockContainsAtLeastOneField(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_CompatibleUsageAndCardinality(block, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_ValidBounds(block, diagnostics, context);
        }
        return result;
    }

    public boolean validateBlock_BlockContainsAtLeastOneField(Block block, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            boolean isInvalid = block.getFields().size() == 0;
            boolean hasOnlyForbiddenField = true;
            if (!isInvalid) {
                Iterator iterator = block.getFields().iterator();
                while (iterator.hasNext() && hasOnlyForbiddenField) {
                    Field field = (Field)iterator.next();
                    if (UsageType.FORBIDDEN.equals((Object)field.getUsage())) continue;
                    hasOnlyForbiddenField = false;
                }
            }
            if (isInvalid || hasOnlyForbiddenField) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Block '" + SaturneValidator.getObjectLabel((EObject)block, context) + "' must have at least one field with usage not 'forbidden'.", new Object[]{block, SaturnePackage.Literals.BLOCK__CHILDREN});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateBlock_CompatibleUsageAndCardinality(Block block, DiagnosticChain diagnostics, Map<Object, Object> context) {
        UsageType blockUsage = block.getUsage();
        if (diagnostics != null && blockUsage != null) {
            if (UsageType.MANDATORY.equals((Object)blockUsage) && (block.getLowerBound() == 0 || block.getUpperBound() == 0)) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The " + blockUsage.getLiteral() + " Block '" + SaturneValidator.getObjectLabel((EObject)block, context) + "' must have its lower and upper bounds greater than or equal to 1.", new Object[]{block, SaturnePackage.Literals.MESSAGE_ELEMENT__USAGE, SaturnePackage.Literals.BLOCK__LOWER_BOUND, SaturnePackage.Literals.BLOCK__UPPER_BOUND});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
            if (UsageType.FORBIDDEN.equals((Object)blockUsage) && (block.getLowerBound() != 0 || block.getUpperBound() != 0)) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The " + blockUsage.getLiteral() + " Block '" + SaturneValidator.getObjectLabel((EObject)block, context) + "' must have its lower and upper bounds equal to 0.", new Object[]{block, SaturnePackage.Literals.MESSAGE_ELEMENT__USAGE, SaturnePackage.Literals.BLOCK__LOWER_BOUND, SaturnePackage.Literals.BLOCK__UPPER_BOUND});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
            if ((UsageType.OPTIONAL.equals((Object)blockUsage) || UsageType.CONDITIONAL.equals((Object)blockUsage)) && (block.getLowerBound() > 0 || block.getUpperBound() == 0)) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The " + blockUsage.getLiteral() + " Block '" + SaturneValidator.getObjectLabel((EObject)block, context) + "' must have its lower bound equal to 0 and upper bound greater than 0.", new Object[]{block, SaturnePackage.Literals.MESSAGE_ELEMENT__USAGE, SaturnePackage.Literals.BLOCK__LOWER_BOUND, SaturnePackage.Literals.BLOCK__UPPER_BOUND});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateBlock_ValidBounds(Block block, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            int lowerBound;
            boolean boundsAreValid;
            int upperBound = block.getUpperBound();
            boolean bl = boundsAreValid = !(upperBound < (lowerBound = block.getLowerBound()) && upperBound != -1 || upperBound != -1 && upperBound < 0 || lowerBound < 0);
            if (!boundsAreValid) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Block '" + SaturneValidator.getObjectLabel((EObject)block, context) + "' must have its upper bound greater than or equal to its lower bound and its lower bound must be greater than or equal to 0 and its upper bound must be -1 or greater than 0.", new Object[]{block, SaturnePackage.Literals.BLOCK__LOWER_BOUND, SaturnePackage.Literals.BLOCK__UPPER_BOUND});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateHeaderBlock(HeaderBlock headerBlock, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(headerBlock, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(headerBlock, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageElement_UsageCantBeUnset(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_BlockContainsAtLeastOneField(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_CompatibleUsageAndCardinality(headerBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_ValidBounds(headerBlock, diagnostics, context);
        }
        return result;
    }

    public boolean validateDeclarationBlock(DeclarationBlock declarationBlock, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(declarationBlock, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(declarationBlock, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageElement_UsageCantBeUnset(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_BlockContainsAtLeastOneField(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_CompatibleUsageAndCardinality(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlock_ValidBounds(declarationBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDeclarationBlock_HasAtLeastOneKey(declarationBlock, diagnostics, context);
        }
        return result;
    }

    public boolean validateDeclarationBlock_HasAtLeastOneKey(DeclarationBlock declarationBlock, DiagnosticChain diagnostics, Map<Object, Object> context) {
        TreeIterator iterator = declarationBlock.eAllContents();
        boolean keyIsMissing = true;
        while (iterator.hasNext()) {
            Field currentField;
            EObject currentElement = (EObject)iterator.next();
            if (!(currentElement instanceof Field) || !(currentField = (Field)currentElement).isDeclarationKey()) continue;
            keyIsMissing = false;
        }
        if (keyIsMissing) {
            if (diagnostics != null) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "Declaration Block" + SaturneValidator.getObjectLabel((EObject)declarationBlock, context) + " must set a key on at least one Field.", new Object[]{declarationBlock, SaturnePackage.Literals.DECLARATION_BLOCK});
                diagnostics.add((Diagnostic)diagnostic);
            }
            return false;
        }
        return true;
    }

    public boolean validateField(Field field, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(field, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(field, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageElement_UsageCantBeUnset(field, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateField_PrimaryKeyHasEnumDatatype(field, diagnostics, context);
        }
        return result;
    }

    public boolean validateField_PrimaryKeyHasEnumDatatype(Field field, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (field.isDeclarationKey() && diagnostics != null && field.getDataType() != null && !(field.getDataType() instanceof EnumDataType)) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Field '" + SaturneValidator.getObjectLabel((EObject)field, context) + "' that is a primary key must have an enum datatype.", new Object[]{field, SaturnePackage.Literals.FIELD__DECLARATION_KEY, SaturnePackage.Literals.FIELD__DATA_TYPE});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateValue(Value value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(value, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(value, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(value, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateValue_ValueRespectAuthorizedLength(value, diagnostics, context);
        }
        return result;
    }

    public boolean validateValue_ValueRespectAuthorizedLength(Value value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            boolean lengthIsValid;
            EnumDataType enumDataType = (EnumDataType)value.eContainer();
            int maxLength = enumDataType.getMaxLength();
            int minLength = enumDataType.getMinLength();
            boolean bl = lengthIsValid = value.getId().length() >= minLength && (value.getId().length() <= maxLength || maxLength == -1);
            if (!lengthIsValid) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The enum value '" + SaturneValidator.getObjectLabel((EObject)value, context) + "' must have its id length in the authorized interval (" + enumDataType.getMinLength() + "-" + enumDataType.getMaxLength() + ")", new Object[]{value, SaturnePackage.Literals.ID_QUALIFIED_ELEMENT__ID});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateDataType(DataType dataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidDataTypeLength(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidRegex(dataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_UsedDataType(dataType, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataType_ValidDataTypeLength(DataType dataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            int minLength;
            boolean lengthsAreValid;
            int maxLength = dataType.getMaxLength();
            boolean bl = lengthsAreValid = maxLength >= (minLength = dataType.getMinLength()) && maxLength > 0 && minLength >= 0;
            if (!lengthsAreValid) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Datatype '" + SaturneValidator.getObjectLabel((EObject)dataType, context) + "' must have its max length greater than or equal to min length and its min length greater than or equal to 0 and its max length greater than 0.", new Object[]{dataType, SaturnePackage.Literals.DATA_TYPE__MIN_LENGTH, SaturnePackage.Literals.DATA_TYPE__MAX_LENGTH});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateDataType_ValidRegex(DataType dataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && dataType.getRegexp() != null && !"".equals(dataType.getRegexp())) {
            try {
                Pattern.compile(dataType.getRegexp());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Datatype '" + SaturneValidator.getObjectLabel((EObject)dataType, context) + "' has a regular expression '" + dataType.getRegexp() + "' that is syntactically invalid.", new Object[]{dataType, SaturnePackage.Literals.DATA_TYPE__REGEXP});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateDataType_UsedDataType(DataType dataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Standard standard;
        Message message;
        if (diagnostics != null && (message = (standard = this.getStandard(dataType)).getMessage()) != null) {
            TreeIterator eAllContents = message.eAllContents();
            boolean datatypeUsed = false;
            while (eAllContents.hasNext() && !datatypeUsed) {
                Field field;
                EObject eObject = (EObject)eAllContents.next();
                if (!(eObject instanceof Field) || dataType != (field = (Field)eObject).getDataType()) continue;
                datatypeUsed = true;
            }
            if (!datatypeUsed) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(1, DIAGNOSTIC_SOURCE, 0, "The Datatype '" + SaturneValidator.getObjectLabel((EObject)dataType, context) + "' is not used by any field.", new Object[]{dataType});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateEnumDataType(EnumDataType enumDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(enumDataType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(enumDataType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidDataTypeLength(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidRegex(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_UsedDataType(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEnumDataType_NatureIsEnumeration(enumDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEnumDataType_NonEmptyEnumeration(enumDataType, diagnostics, context);
        }
        return result;
    }

    public boolean validateEnumDataType_NatureIsEnumeration(EnumDataType enumDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && enumDataType.getNature() != null && !NatureType.ENUMERATION.equals((Object)enumDataType.getNature())) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The EnumDatatype '" + SaturneValidator.getObjectLabel((EObject)enumDataType, context) + "' must have its nature equal to 'Enumeration'", new Object[]{enumDataType, SaturnePackage.Literals.DATA_TYPE__NATURE});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateEnumDataType_NonEmptyEnumeration(EnumDataType enumDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && enumDataType.getValues().size() == 0) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The EnumDatatype '" + SaturneValidator.getObjectLabel((EObject)enumDataType, context) + "' must have at least one Value.", new Object[]{enumDataType, SaturnePackage.Literals.ENUM_DATA_TYPE__VALUES});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateAlphanumericDataType(AlphanumericDataType alphanumericDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(alphanumericDataType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(alphanumericDataType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidDataTypeLength(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidRegex(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_UsedDataType(alphanumericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAlphanumericDataType_NatureIsAlphanumeric(alphanumericDataType, diagnostics, context);
        }
        return result;
    }

    public boolean validateAlphanumericDataType_NatureIsAlphanumeric(AlphanumericDataType alphanumericDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && alphanumericDataType.getNature() != null && !NatureType.ALPHANUMERIC.equals((Object)alphanumericDataType.getNature())) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The AlphanumericDataType '" + SaturneValidator.getObjectLabel((EObject)alphanumericDataType, context) + "' must have its nature equal to 'Alphanumeric'", new Object[]{alphanumericDataType, SaturnePackage.Literals.DATA_TYPE__NATURE});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateNumericDataType(NumericDataType numericDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(numericDataType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(numericDataType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidDataTypeLength(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidRegex(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_UsedDataType(numericDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNumericDataType_NatureIsNumeric(numericDataType, diagnostics, context);
        }
        return result;
    }

    public boolean validateNumericDataType_NatureIsNumeric(NumericDataType numericDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && numericDataType.getNature() != null && !NatureType.NUMERIC.equals((Object)numericDataType.getNature())) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The NumericDataType '" + SaturneValidator.getObjectLabel((EObject)numericDataType, context) + "' must have its nature equal to 'Numeric'", new Object[]{numericDataType, SaturnePackage.Literals.DATA_TYPE__NATURE});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateDateDataType(DateDataType dateDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dateDataType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dateDataType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidDataTypeLength(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidRegex(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_UsedDataType(dateDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDateDataType_NatureIsDate(dateDataType, diagnostics, context);
        }
        return result;
    }

    public boolean validateDateDataType_NatureIsDate(DateDataType dateDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && dateDataType.getNature() != null && !NatureType.DATE.equals((Object)dateDataType.getNature())) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The DateDataType '" + SaturneValidator.getObjectLabel((EObject)dateDataType, context) + "' must have its nature equal to 'Date'", new Object[]{dateDataType, SaturnePackage.Literals.DATA_TYPE__NATURE});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateExternalDataType(ExternalDataType externalDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(externalDataType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(externalDataType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidDataTypeLength(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_ValidRegex(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataType_UsedDataType(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExternalDataType_NatureIsExternalReferential(externalDataType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExternalDataType_ExistingFilterValues(externalDataType, diagnostics, context);
        }
        return result;
    }

    public boolean validateExternalDataType_NatureIsExternalReferential(ExternalDataType externalDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && externalDataType.getNature() != null && !NatureType.EXTERNAL_REFERENTIAL.equals((Object)externalDataType.getNature())) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The ExternalDataType '" + SaturneValidator.getObjectLabel((EObject)externalDataType, context) + "' must have its nature equal to 'ExternalReferential'", new Object[]{externalDataType, SaturnePackage.Literals.DATA_TYPE__NATURE});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateExternalDataType_ExistingFilterValues(ExternalDataType externalDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        BasicDiagnostic diagnostic;
        boolean isNoIncludedValue;
        block13: {
            boolean areAllValuesExcluded;
            block12: {
                OptionMap options;
                Standard standard;
                boolean areValuesContained;
                block11: {
                    areValuesContained = true;
                    areAllValuesExcluded = true;
                    isNoIncludedValue = true;
                    standard = this.getStandard(externalDataType);
                    options = new OptionMap();
                    try {
                        StandardFileUtil standardUtil = new StandardFileUtil();
                        IFile standardFile = standardUtil.getStandardFile(standard);
                        if (standardFile != null) {
                            options.setOption(new Key("fr.cnav.saturne.kbdescriptor.init.workspace.norm.file"), standardFile);
                            break block11;
                        }
                        throw new ExecutionException("Standard File model can not be loaded. The unloaded model Uri is " + standard.eResource().getURI());
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    ModelAccessorWithNomenclaturesHandling modelAccessor = new ModelAccessorWithNomenclaturesHandling(standard, options, Logger.getAnonymousLogger(), DATASOURCES_DIRECTORY, standard);
                    List filterValues = externalDataType.getIncludeExcludeValues().stream().map(csvValue -> csvValue.getValue()).collect(Collectors.toList());
                    isNoIncludedValue = filterValues.isEmpty();
                    HashSet<String> allReferentialValues = new HashSet<String>();
                    for (ExternalDataTable dataTable : externalDataType.getExternalDataTables()) {
                        if (!(dataTable.getDataSource() instanceof CSVDataSource)) continue;
                        CSVDataSource csvDataSource = (CSVDataSource)dataTable.getDataSource();
                        String columnId = csvDataSource.getColumnId();
                        String referentialName = csvDataSource.getFilename();
                        Set<String> referential = modelAccessor.getReferential(referentialName, columnId);
                        if (referential == null) continue;
                        allReferentialValues.addAll(referential);
                    }
                    areAllValuesExcluded = filterValues.containsAll(allReferentialValues);
                    ArrayList<String> unknownFilterValues = new ArrayList<String>();
                    for (String filterValue : filterValues) {
                        if (allReferentialValues.contains(filterValue)) continue;
                        unknownFilterValues.add(filterValue);
                        areValuesContained = false;
                    }
                    if (areValuesContained) break block12;
                    if (diagnostics != null) {
                        diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The ExternalDataType '" + SaturneValidator.getObjectLabel((EObject)externalDataType, context) + "' must have its filter values contained in CSV file. Concerned values: [" + String.join((CharSequence)",", unknownFilterValues) + "].", new Object[]{externalDataType, SaturnePackage.Literals.DATA_TYPE__NATURE});
                        diagnostics.add((Diagnostic)diagnostic);
                    }
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (externalDataType.getFilter() != FilterType.EXCLUDE || !areAllValuesExcluded || diagnostics == null) break block13;
            diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The ExternalDataType '" + SaturneValidator.getObjectLabel((EObject)externalDataType, context) + "' should not exclude all values contained in CSV file.", new Object[]{externalDataType, SaturnePackage.Literals.DATA_TYPE__NATURE});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        if (externalDataType.getFilter() == FilterType.INCLUDE && isNoIncludedValue && diagnostics != null) {
            diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The ExternalDataType '" + SaturneValidator.getObjectLabel((EObject)externalDataType, context) + "' must include at least one value from CSV file.", new Object[]{externalDataType, SaturnePackage.Literals.DATA_TYPE__NATURE});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateDataSource(DataSource dataSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(dataSource, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(dataSource, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(dataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataSource_UsedDatasource(dataSource, diagnostics, context);
        }
        return result;
    }

    public boolean validateDataSource_UsedDatasource(DataSource dataSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Standard standard;
        if (diagnostics != null && (standard = this.getStandard(dataSource)) != null) {
            boolean isDatasourceUsed = false;
            Iterator iteratorDatatype = standard.getDataTypes().getDatatypes().iterator();
            while (iteratorDatatype.hasNext() && !isDatasourceUsed) {
                DataType dataType = (DataType)iteratorDatatype.next();
                if (!(dataType instanceof ExternalDataType)) continue;
                ExternalDataType externalDataType = (ExternalDataType)dataType;
                Iterator iteratorDataTable = externalDataType.getExternalDataTables().iterator();
                while (iteratorDataTable.hasNext() && !isDatasourceUsed) {
                    ExternalDataTable externalDataTable = (ExternalDataTable)iteratorDataTable.next();
                    if (!dataSource.equals(externalDataTable.getDataSource())) continue;
                    isDatasourceUsed = true;
                }
            }
            if (!isDatasourceUsed) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(1, DIAGNOSTIC_SOURCE, 0, "The datasource '" + SaturneValidator.getObjectLabel((EObject)dataSource, context) + "' is not used by any external referential datatype.", new Object[]{dataSource});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateCSVDataSource(CSVDataSource csvDataSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(csvDataSource, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(csvDataSource, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDataSource_UsedDatasource(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCSVDataSource_ValidLineNumber(csvDataSource, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCSVDataSource_ValidFileReferenced(csvDataSource, diagnostics, context);
        }
        return result;
    }

    public boolean validateCSVDataSource_ValidLineNumber(CSVDataSource csvDataSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && csvDataSource.getTitleLineNumber() < 0) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The CSV datasource '" + SaturneValidator.getObjectLabel((EObject)csvDataSource, context) + "' must have its title line number greater than 0.", new Object[]{csvDataSource, SaturnePackage.Literals.CSV_DATA_SOURCE__TITLE_LINE_NUMBER});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateCSVDataSource_ValidFileReferenced(CSVDataSource csvDataSource, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && csvDataSource.getFilename() != null && !"".equals(csvDataSource.getFilename())) {
            IFile file;
            IFolder datasourcesFolder;
            URI uri = csvDataSource.eResource().getURI();
            IWorkspace myWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot myWorkspaceRoot = myWorkspace.getRoot();
            IFile iFile = myWorkspaceRoot.getFile((IPath)new Path(uri.toPlatformString(true)));
            IProject project = iFile.getProject();
            IFolder modelFolder = project.getFolder(MODELS_DIRECTORY);
            if (modelFolder.exists() && (datasourcesFolder = modelFolder.getFolder(DATASOURCES_DIRECTORY)).exists() && (file = datasourcesFolder.getFile(csvDataSource.getFilename())).exists()) {
                return true;
            }
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Datasource '" + SaturneValidator.getObjectLabel((EObject)csvDataSource, context) + "' references a file, '" + csvDataSource.getFilename() + "', that cannot be found in the folder '" + MODELS_DIRECTORY + "/" + DATASOURCES_DIRECTORY + "'.", new Object[]{csvDataSource, SaturnePackage.Literals.CSV_DATA_SOURCE__FILENAME});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateExternalDataTable(ExternalDataTable externalDataTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(externalDataTable, diagnostics, context);
    }

    public boolean validateCSVExternalDataTable(CSVExternalDataTable csvExternalDataTable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(csvExternalDataTable, diagnostics, context);
    }

    public boolean validateGenericRule(GenericRule genericRule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(genericRule, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(genericRule, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(genericRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(genericRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(genericRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(genericRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(genericRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(genericRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(genericRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(genericRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(genericRule, diagnostics, context);
        }
        return result;
    }

    public boolean validateAlias(Alias alias, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(alias, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(alias, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(alias, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(alias, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(alias, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(alias, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(alias, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(alias, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(alias, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(alias, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(alias, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAlias_UsedAlias(alias, diagnostics, context);
        }
        return result;
    }

    public boolean validateAlias_UsedAlias(Alias alias, DiagnosticChain diagnostics, Map<Object, Object> context) {
        RuleSet ruleSet;
        Standard standard;
        if (diagnostics != null && alias.getName() != null && !"".equals(alias.getName()) && alias.getReference() != null && !"".equals(alias.getReference().getFullQualifiedId()) && (standard = this.getStandard(alias)) != null && (ruleSet = standard.getRules()) != null) {
            boolean isUsed = false;
            Iterator iterator = ruleSet.getRules().iterator();
            while (iterator.hasNext() && !isUsed) {
                String dslExpression;
                GenericRule rule = (GenericRule)iterator.next();
                if (!(rule instanceof Rule) || (dslExpression = ((Rule)rule).getDslExpression()) == null || !dslExpression.contains("@" + alias.getName())) continue;
                isUsed = true;
            }
            if (!isUsed) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(1, DIAGNOSTIC_SOURCE, 0, "The Alias '" + SaturneValidator.getObjectLabel((EObject)alias, context) + "' is not used by any rule.", new Object[]{alias});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateMacro(Macro macro, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(macro, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(macro, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMacro_UsedMacro(macro, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMacro_ValidSyntax(macro, diagnostics, context);
        }
        return result;
    }

    public boolean validateMacro_UsedMacro(Macro macro, DiagnosticChain diagnostics, Map<Object, Object> context) {
        RuleSet ruleSet;
        Standard standard;
        if (diagnostics != null && macro.getName() != null && !"".equals(macro.getName()) && macro.getExpression() != null && !"".equals(macro.getExpression()) && (standard = this.getStandard(macro)) != null && (ruleSet = standard.getRules()) != null) {
            boolean isUsed = false;
            Iterator iterator = ruleSet.getRules().iterator();
            while (iterator.hasNext() && !isUsed) {
                String dslExpression;
                GenericRule rule = (GenericRule)iterator.next();
                if (!(rule instanceof Rule) || (dslExpression = ((Rule)rule).getDslExpression()) == null || !dslExpression.contains("@" + macro.getName())) continue;
                isUsed = true;
            }
            if (!isUsed) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(1, DIAGNOSTIC_SOURCE, 0, "The Macro '" + SaturneValidator.getObjectLabel((EObject)macro, context) + "' is not used by any rule.", new Object[]{macro});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateMacro_ValidSyntax(Macro macro, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String expression = macro.getExpression();
        if (diagnostics != null && expression != null && !"".equals(expression)) {
            DslExpressionExtractor dslExpressionExtractor = new DslExpressionExtractor();
            Standard standard = this.getStandard(macro);
            if (standard != null) {
                try {
                    dslExpressionExtractor.extractDslExpressionFromDslString(standard, expression, "", "");
                }
                catch (FormuleTraducteurException | ParserConfigurationException | RuntimeException e) {
                    BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Macro '" + SaturneValidator.getObjectLabel((EObject)macro, context) + "' has an invalid DSL syntax : " + e.getMessage(), new Object[]{macro, SaturnePackage.Literals.MACRO__EXPRESSION});
                    diagnostics.add((Diagnostic)diagnostic);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateExternalFunctionDefinition(ExternalFunctionDefinition externalFunctionDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(externalFunctionDefinition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(externalFunctionDefinition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExternalFunctionDefinition_UsedExternalFunction(externalFunctionDefinition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateExternalFunctionDefinition_ValidSignature(externalFunctionDefinition, diagnostics, context);
        }
        return result;
    }

    public boolean validateExternalFunctionDefinition_UsedExternalFunction(ExternalFunctionDefinition externalFunctionDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        RuleSet ruleSet;
        Standard standard;
        if (diagnostics != null && externalFunctionDefinition.getName() != null && !"".equals(externalFunctionDefinition.getName()) && externalFunctionDefinition.getSignature() != null && !"".equals(externalFunctionDefinition.getSignature()) && (standard = this.getStandard(externalFunctionDefinition)) != null && (ruleSet = standard.getRules()) != null) {
            boolean isUsed = false;
            Iterator iterator = ruleSet.getRules().iterator();
            while (iterator.hasNext() && !isUsed) {
                Rule dslRule;
                String dslExpression;
                GenericRule rule = (GenericRule)iterator.next();
                if (!(rule instanceof Rule) || (dslExpression = (dslRule = (Rule)rule).getDslExpression()) == null || dslRule.getComputedContext() == null) continue;
                FormuleTraducteur formuleTraducteur = null;
                try {
                    formuleTraducteur = new FormuleTraducteur(new StandardParserConfiguration(standard, Collections.emptyMap()));
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
                try {
                    Expression parsedExpression = formuleTraducteur.parse(dslRule.getDslExpression(), dslRule.getSubject().getFullQualifiedId(), dslRule.getComputedContext().getFullQualifiedId());
                    if (parsedExpression instanceof FunctionCall && externalFunctionDefinition.getName().equals(((FunctionCall)parsedExpression).getName())) {
                        isUsed = true;
                    }
                    TreeIterator eAllContents = parsedExpression.eAllContents();
                    while (eAllContents.hasNext() && !isUsed) {
                        EObject eObject = (EObject)eAllContents.next();
                        if (!(eObject instanceof FunctionCall) || !externalFunctionDefinition.getName().equals(((FunctionCall)eObject).getName())) continue;
                        isUsed = true;
                    }
                }
                catch (Exception exception) {}
            }
            if (!isUsed) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(1, DIAGNOSTIC_SOURCE, 0, "The External function '" + SaturneValidator.getObjectLabel((EObject)externalFunctionDefinition, context) + "' is not used by any rule.", new Object[]{externalFunctionDefinition});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateExternalFunctionDefinition_ValidSignature(ExternalFunctionDefinition externalFunctionDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String signature = externalFunctionDefinition.getSignature();
        boolean isValidSignature = ExternalFunctionUtil.isValidSignatureFormat(signature);
        if (!isValidSignature) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The signature of the External Function '" + SaturneValidator.getObjectLabel((EObject)externalFunctionDefinition, context) + "' is not valid.", new Object[]{externalFunctionDefinition});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateRulesConfiguration(RulesConfiguration rulesConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(rulesConfiguration, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(rulesConfiguration, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(rulesConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(rulesConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(rulesConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(rulesConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(rulesConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(rulesConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(rulesConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRulesConfiguration_UniqueExternalFunctionNames(rulesConfiguration, diagnostics, context);
        }
        return result;
    }

    public boolean validateRulesConfiguration_UniqueExternalFunctionNames(RulesConfiguration rulesConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        HashMap<String, List> functionsByName = new HashMap<String, List>();
        for (ExternalFunctionDefinition function : rulesConfiguration.getExternalFunctions()) {
            List duplicatedFunctions = functionsByName.getOrDefault(function.getName(), new ArrayList());
            duplicatedFunctions.add(function);
            functionsByName.put(function.getName(), duplicatedFunctions);
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            for (ExternalFunctionDefinition duplicatedFunction : (List)entry.getValue()) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "Duplicate External Function '" + SaturneValidator.getObjectLabel((EObject)duplicatedFunction, context) + "' : name must be unique.", new Object[]{duplicatedFunction, SaturnePackage.Literals.NAMED_ELEMENT__NAME});
                diagnostics.add((Diagnostic)diagnostic);
            }
            result = false;
        }
        return result;
    }

    public boolean validateDeclaration(Declaration declaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(declaration, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(declaration, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDeclaration_AllIdentificationKeysAreSpecified(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDeclaration_DeclarationHaveUniqueName(declaration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDeclaration_BlockOfDeclarationContainsAtLeastOneFieldNotForbidden(declaration, diagnostics, context);
        }
        return result;
    }

    public boolean validateDeclaration_AllIdentificationKeysAreSpecified(Declaration declaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            Standard standard = this.getStandard(declaration);
            Iterator<Field> iteratorPrimaryKeys = this.getPrimaryKeyFields(standard).iterator();
            boolean keyMissing = false;
            Field key = null;
            while (iteratorPrimaryKeys.hasNext() && !keyMissing) {
                Field field = iteratorPrimaryKeys.next();
                Iterator iteratorFieldToValue = declaration.getKeyValues().iterator();
                boolean keyFound = false;
                while (iteratorFieldToValue.hasNext()) {
                    Map.Entry entryFieldToValue = (Map.Entry)iteratorFieldToValue.next();
                    if (field != entryFieldToValue.getKey()) continue;
                    keyFound = true;
                }
                if (keyFound) continue;
                key = field;
                keyMissing = true;
            }
            if (keyMissing) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Declaration '" + SaturneValidator.getObjectLabel((EObject)declaration, context) + "' does not define a set of usable values for the primary key '" + SaturneValidator.getObjectLabel((EObject)key, context) + "'.", new Object[]{declaration, SaturnePackage.Literals.DECLARATION__KEY_VALUES});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    private List<Field> getPrimaryKeyFields(Standard standard) {
        Message message = standard.getMessage();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        if (message != null) {
            TreeIterator eAllContents = message.eAllContents();
            while (eAllContents.hasNext()) {
                EObject eObject = (EObject)eAllContents.next();
                if (!(eObject instanceof Field) || !((Field)eObject).isDeclarationKey()) continue;
                fieldList.add((Field)eObject);
            }
        }
        return fieldList;
    }

    public boolean validateDeclaration_DeclarationHaveUniqueName(Declaration declaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Standard standard;
        if (diagnostics != null && declaration.getName() != null && !"".equals(declaration.getName()) && (standard = this.getStandard(declaration)) != null) {
            boolean hasNotUniqueName = false;
            Iterator iterator = standard.getDeclarations().iterator();
            Declaration declaration2 = null;
            while (iterator.hasNext() && !hasNotUniqueName) {
                declaration2 = (Declaration)iterator.next();
                if (declaration2 == declaration || !declaration.getName().equals(declaration2.getName())) continue;
                hasNotUniqueName = true;
            }
            if (hasNotUniqueName) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "The name of the declaration '" + SaturneValidator.getObjectLabel((EObject)declaration, context) + "' is already used. Declaration's name should be unique.", new Object[]{declaration, SaturnePackage.Literals.NAMED_ELEMENT__NAME});
                diagnostics.add((Diagnostic)diagnostic);
                return true;
            }
        }
        return true;
    }

    public boolean validateDeclaration_BlockOfDeclarationContainsAtLeastOneFieldNotForbidden(Declaration declaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            Map<Block, BlockRefinement> blockRefinementsMap = declaration.getBlockRefinements();
            Map<Field, FieldRefinement> fieldRefinementsMap = declaration.getFieldRefinements();
            Collection<FieldRefinement> values = fieldRefinementsMap.values();
            HashSet<Block> blockWithOneFieldNoForbiddenAtLeast = new HashSet<Block>();
            for (FieldRefinement fieldRefinement : values) {
                boolean isForbiddenBlock;
                Block blockParent;
                Field field = fieldRefinement.getField();
                if (field == null || blockWithOneFieldNoForbiddenAtLeast.contains(blockParent = (Block)field.eContainer())) continue;
                Iterator iterator = blockParent.getChildrenFields().iterator();
                boolean hasOnlyForbiddenField = true;
                while (iterator.hasNext() && hasOnlyForbiddenField) {
                    UsageType effectiveUsageType;
                    Field blockField = (Field)iterator.next();
                    FieldRefinement blockFieldRefinement = fieldRefinementsMap.get(blockField);
                    UsageType usageType = effectiveUsageType = blockFieldRefinement == null ? blockField.getUsage() : blockFieldRefinement.getUsage();
                    if (UsageType.FORBIDDEN.equals((Object)effectiveUsageType)) continue;
                    hasOnlyForbiddenField = false;
                    blockWithOneFieldNoForbiddenAtLeast.add(blockParent);
                }
                BlockRefinement bockRefinement = blockRefinementsMap.get(blockParent);
                boolean bl = isForbiddenBlock = bockRefinement != null && UsageType.FORBIDDEN.equals((Object)bockRefinement.getUsage());
                if (isForbiddenBlock || !hasOnlyForbiddenField) continue;
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The block '" + SaturneValidator.getObjectLabel((EObject)blockParent, context) + "' of the declaration '" + SaturneValidator.getObjectLabel((EObject)declaration, context) + "' with its field refinements breaks the rule : a block must contain at least one field not forbidden. ", new Object[]{declaration, SaturnePackage.Literals.DECLARATION___GET_FIELD_REFINEMENTS});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateFieldToValueMap(Map.Entry<?, ?> fieldToValueMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)fieldToValueMap, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)fieldToValueMap, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)fieldToValueMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)fieldToValueMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)fieldToValueMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)fieldToValueMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)fieldToValueMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)fieldToValueMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)fieldToValueMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFieldToValueMap_SpecifiedValuesAreValuesOfIdentificationKey(fieldToValueMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFieldToValueMap_SpecifiedKeyIsIdentificationKey(fieldToValueMap, diagnostics, context);
        }
        return result;
    }

    public boolean validateFieldToValueMap_SpecifiedValuesAreValuesOfIdentificationKey(Map.Entry<?, ?> fieldToValueMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Field key;
        DataType dataType;
        if (diagnostics != null && fieldToValueMap.getKey() != null && (dataType = (key = (Field)fieldToValueMap.getKey()).getDataType()) instanceof EnumDataType && ((EnumDataType)dataType).getValues().size() > 0) {
            EnumDataType enumDataType = (EnumDataType)dataType;
            boolean valueDoesNotBelongToKey = false;
            EList<Value> keyDatatypeValues = enumDataType.getValues();
            Iterator iterator = ((EList)fieldToValueMap.getValue()).iterator();
            Value value = null;
            while (iterator.hasNext() && !valueDoesNotBelongToKey) {
                value = (Value)iterator.next();
                if (keyDatatypeValues.contains((Object)value)) continue;
                valueDoesNotBelongToKey = true;
            }
            if (valueDoesNotBelongToKey) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The couple {primary key field, {values}} referencing the primary key '" + SaturneValidator.getObjectLabel((EObject)((Field)fieldToValueMap.getKey()), context) + "' contains values not belonging to the specified primary key field.", new Object[]{"SpecifiedValuesAreValuesOfIdentificationKey", SaturneValidator.getObjectLabel((EObject)((Field)fieldToValueMap.getKey()), context)});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateFieldToValueMap_SpecifiedKeyIsIdentificationKey(Map.Entry<?, ?> fieldToValueMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Field key;
        if (diagnostics != null && fieldToValueMap.getKey() != null && !(key = (Field)fieldToValueMap.getKey()).isDeclarationKey()) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The couple {primary key field, {values}} contains a key '" + SaturneValidator.getObjectLabel((EObject)((Field)fieldToValueMap.getKey()), context) + "' that is not a primary key field.", new Object[]{"SpecifiedKeyIsIdentificationKey", SaturneValidator.getObjectLabel((EObject)((Field)fieldToValueMap.getKey()), context)});
            diagnostics.add((Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public boolean validateRefinement(Refinement refinement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(refinement, diagnostics, context);
    }

    public boolean validateBlockRefinement(BlockRefinement blockRefinement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(blockRefinement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(blockRefinement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(blockRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(blockRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(blockRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(blockRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(blockRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(blockRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(blockRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlockRefinement_CompatibleUsageAndCardinality(blockRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlockRefinement_ValidBounds(blockRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBlockRefinement_BlockIsRefinedOneTimeMax(blockRefinement, diagnostics, context);
        }
        return result;
    }

    public boolean validateBlockRefinement_CompatibleUsageAndCardinality(BlockRefinement blockRefinement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && blockRefinement.getBlock() != null) {
            UsageType blockRefinementUsage = blockRefinement.getUsage();
            BoundRefinement blockRefinementLowerBound = blockRefinement.getLowerBound();
            BoundRefinement blockRefinementUpperBound = blockRefinement.getUpperBound();
            if (UsageType.MANDATORY.equals((Object)blockRefinementUsage) && (blockRefinementLowerBound != null && blockRefinementLowerBound.getNewBound() == 0 || blockRefinementUpperBound != null && blockRefinementUpperBound.getNewBound() == 0)) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The refined " + blockRefinementUsage.getLiteral() + " Block '" + SaturneValidator.getObjectLabel((EObject)blockRefinement, context) + "' must have its lower and upper bounds greater than or equal to 1.", new Object[]{blockRefinement, SaturnePackage.Literals.BLOCK_REFINEMENT__LOWER_BOUND, SaturnePackage.Literals.BLOCK_REFINEMENT__UPPER_BOUND});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
            if (UsageType.FORBIDDEN.equals((Object)blockRefinementUsage) && (blockRefinementLowerBound != null && blockRefinementLowerBound.getNewBound() != 0 || blockRefinementUpperBound != null && blockRefinementUpperBound.getNewBound() != 0)) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The refined " + blockRefinementUsage.getLiteral() + " Block '" + SaturneValidator.getObjectLabel((EObject)blockRefinement, context) + "' must have its lower and upper bounds equal to 0.", new Object[]{blockRefinement, SaturnePackage.Literals.BLOCK_REFINEMENT__LOWER_BOUND, SaturnePackage.Literals.BLOCK_REFINEMENT__UPPER_BOUND});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
            if ((UsageType.OPTIONAL.equals((Object)blockRefinementUsage) || UsageType.CONDITIONAL.equals((Object)blockRefinementUsage)) && (blockRefinementLowerBound != null && blockRefinementLowerBound.getNewBound() > 0 || blockRefinementUpperBound != null && blockRefinementUpperBound.getNewBound() == 0)) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The refined " + blockRefinementUsage.getLiteral() + " Block '" + SaturneValidator.getObjectLabel((EObject)blockRefinement, context) + "' must have its lower bound equal to 0 and upper bound greater than 0.", new Object[]{blockRefinement, SaturnePackage.Literals.BLOCK_REFINEMENT__LOWER_BOUND, SaturnePackage.Literals.BLOCK_REFINEMENT__UPPER_BOUND});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateBlockRefinement_ValidBounds(BlockRefinement blockRefinement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && blockRefinement.getBlock() != null) {
            boolean boundsAreValid;
            int effectiveUpperBound = blockRefinement.getUpperBound() != null ? blockRefinement.getUpperBound().getNewBound() : blockRefinement.getBlock().getUpperBound();
            int effectiveLowerBound = blockRefinement.getLowerBound() != null ? blockRefinement.getLowerBound().getNewBound() : blockRefinement.getBlock().getLowerBound();
            boolean bl = boundsAreValid = !(effectiveUpperBound < effectiveLowerBound && effectiveUpperBound != -1 || effectiveUpperBound != -1 && effectiveUpperBound < 0 || effectiveLowerBound < 0);
            if (!boundsAreValid) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The refined Block '" + SaturneValidator.getObjectLabel((EObject)blockRefinement, context) + "' must have its effective upper bound greater than or equal to it's effective lower bound and lower bound must be greater than or equal to 0 and upper bound must be -1 or greater than 0.", new Object[]{blockRefinement, SaturnePackage.Literals.BLOCK_REFINEMENT__LOWER_BOUND, SaturnePackage.Literals.BLOCK_REFINEMENT__UPPER_BOUND});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateBlockRefinement_BlockIsRefinedOneTimeMax(BlockRefinement blockRefinement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && blockRefinement.getBlock() != null) {
            Declaration declaration = (Declaration)blockRefinement.eContainer();
            for (BlockRefinement blockRefinement2 : declaration.getBlockRefinements().values()) {
                if (blockRefinement == blockRefinement2 || blockRefinement.getBlock() != blockRefinement2.getBlock()) continue;
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The block '" + SaturneValidator.getObjectLabel((EObject)blockRefinement.getBlock(), context) + "' is refined more than one time in the declaration '" + SaturneValidator.getObjectLabel((EObject)declaration, context) + "'.", new Object[]{blockRefinement});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateBoundRefinement(BoundRefinement boundRefinement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(boundRefinement, diagnostics, context);
    }

    public boolean validateFieldRefinement(FieldRefinement fieldRefinement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(fieldRefinement, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(fieldRefinement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(fieldRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(fieldRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(fieldRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(fieldRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(fieldRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(fieldRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(fieldRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFieldRefinement_FilteredRulesBelongToRefinedField(fieldRefinement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFieldRefinement_FieldIsRefinedOneTimeMax(fieldRefinement, diagnostics, context);
        }
        return result;
    }

    public boolean validateFieldRefinement_FilteredRulesBelongToRefinedField(FieldRefinement fieldRefinement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && fieldRefinement.getField() != null) {
            EList<GenericRule> inhibitedRules = fieldRefinement.getInhibitedRules();
            for (GenericRule rule : inhibitedRules) {
                if (fieldRefinement.getField().equals(rule.getSubject())) continue;
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The refined Field '" + SaturneValidator.getObjectLabel((EObject)fieldRefinement.getField(), context) + "' contains an inhibited rule '" + SaturneValidator.getObjectLabel((EObject)rule, context) + "' not belonging to the referenced Field.", new Object[]{fieldRefinement});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateFieldRefinement_FieldIsRefinedOneTimeMax(FieldRefinement fieldRefinement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null && fieldRefinement.getField() != null) {
            Declaration declaration = (Declaration)fieldRefinement.eContainer();
            for (Refinement fieldRefinement2 : declaration.getRefinements()) {
                if (!(fieldRefinement2 instanceof FieldRefinement) || fieldRefinement == fieldRefinement2 || fieldRefinement.getField() != ((FieldRefinement)fieldRefinement2).getField()) continue;
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The field '" + SaturneValidator.getObjectLabel((EObject)fieldRefinement.getField(), context) + "' is refined more than one time in the declaration '" + SaturneValidator.getObjectLabel((EObject)declaration, context) + "'.", new Object[]{fieldRefinement});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateReportConfiguration(ReportConfiguration reportConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(reportConfiguration, diagnostics, context);
    }

    public boolean validateFieldContext(FieldContext fieldContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(fieldContext, diagnostics, context);
    }

    public boolean validateBlockContext(BlockContext blockContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(blockContext, diagnostics, context);
    }

    public boolean validateRuleSet(RuleSet ruleSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ruleSet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ruleSet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ruleSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ruleSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ruleSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ruleSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ruleSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ruleSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ruleSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRuleSet_NoDuplicatedRules(ruleSet, diagnostics, context);
        }
        return result;
    }

    public boolean validateRuleSet_NoDuplicatedRules(RuleSet ruleSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Boolean isValid = true;
        HashSet<String> rulesId = new HashSet<String>();
        for (GenericRule rule : ruleSet.getRules()) {
            String fullId = rule.getFullId();
            if (rulesId.contains(fullId)) {
                if (diagnostics == null) continue;
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Rule Set contains multiple rules with the same id : " + fullId, new Object[]{rule});
                diagnostics.add((Diagnostic)diagnostic);
                isValid = false;
                continue;
            }
            rulesId.add(fullId);
        }
        return isValid;
    }

    public boolean validateDataTypeSet(DataTypeSet dataTypeSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dataTypeSet, diagnostics, context);
    }

    public boolean validateDataSourceSet(DataSourceSet dataSourceSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dataSourceSet, diagnostics, context);
    }

    public boolean validateJavaRule(JavaRule javaRule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(javaRule, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(javaRule, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(javaRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(javaRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(javaRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(javaRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(javaRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(javaRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(javaRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(javaRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(javaRule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateJavaRule_ValidRuleClassName(javaRule, diagnostics, context);
        }
        return result;
    }

    public boolean validateJavaRule_ValidRuleClassName(JavaRule javaRule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            String ruleClassName = javaRule.getRuleClass();
            ValidatorJavaPkgIdFormat validatorJavaPckIdFormat = new ValidatorJavaPkgIdFormat();
            validatorJavaPckIdFormat.isValideCaseInsessitive(ruleClassName);
            if (validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_IS_EMPTY_OR_NULL) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The rule class name format of the JavaRule element should not be empty or null.", new Object[]{javaRule, SaturnePackage.Literals.JAVA_RULE__RULE_CLASS});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
            if (validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_CONTAIN_FORRDIDEN_CHAR || validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_FIRST_CHAR_IS_FORRDIDEN_CHAR) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The rule class name '" + ruleClassName + "' of the JavaRule element is invalid-> '" + validatorJavaPckIdFormat.getCharOrWordTriggerFailure() + "' is not an allowed character.", new Object[]{javaRule, SaturnePackage.Literals.JAVA_RULE__RULE_CLASS});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
            if (validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_IS_KEYWORD) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The rule class name format '" + ruleClassName + "' of the JavaRule element is invalid-> '" + validatorJavaPckIdFormat.getCharOrWordTriggerFailure() + "' is not an allowed word because java keyword is forbidden.", new Object[]{javaRule, SaturnePackage.Literals.JAVA_RULE__RULE_CLASS});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateRule(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(rule, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(rule, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_DslExpressionCompile(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_IsBooleanType(rule, diagnostics, context);
        }
        return result;
    }

    public boolean validateRule_DslExpressionCompile(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Standard standard;
        boolean isValid = true;
        String dslExpression = rule.getDslExpression();
        if (diagnostics != null && dslExpression != null && !"".equals(dslExpression) && rule.getSubject() != null && (RuleUtil.isSubjectInReusedBlock(rule) || rule.getComputedContext() != null) && (standard = this.getStandard(rule)) != null) {
            StandardParserConfiguration configuration;
            try {
                configuration = new StandardParserConfiguration(standard, Collections.emptyMap());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            final FormuleTraducteur formuleTraducteur = new FormuleTraducteur(configuration);
            String subjectId = rule.getSubject().getFullQualifiedId();
            String ctxID = null;
            if (RuleUtil.isSubjectInReusedBlock(rule)) {
                ReusedBlock subjectParent = (ReusedBlock)rule.getSubject().eContainer();
                ctxID = subjectParent.getFullQualifiedId();
            } else {
                ctxID = rule.getComputedContext().getFullQualifiedId();
            }
            if (subjectId == null || ctxID == null) {
                return isValid;
            }
            Expression ast = null;
            try {
                ast = formuleTraducteur.parse(dslExpression, subjectId, ctxID);
            }
            catch (Exception e) {
                DSLErrorUtil dslErrorUtil = new DSLErrorUtil();
                String errorMsg = dslErrorUtil.getDslErrorMsg(e, rule, SaturneValidator.getObjectLabel((EObject)rule, context));
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMsg, new Object[]{rule, SaturnePackage.Literals.RULE__DSL_EXPRESSION});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
            Map<Object, Object> contextFormule = context;
            final String finalCtxID = ctxID;
            ITypingEnvironment env = new ITypingEnvironment(){

                @Override
                public String getSignature(String functionName, int argCount) {
                    String key = String.valueOf(functionName) + "/" + argCount + ".prototype";
                    return formuleTraducteur.getConfiguration().getDefinition(key);
                }

                @Override
                public Type getNodeType(String nodeName) {
                    return formuleTraducteur.getConfiguration().getType(nodeName);
                }

                @Override
                public boolean isMultiple(String nodeName) {
                    FieldBlockRefCardinalityTester fieldBlockRefCardinalityTester = new FieldBlockRefCardinalityTester(configuration.getMessage());
                    return fieldBlockRefCardinalityTester.isMultiple(finalCtxID, nodeName);
                }

                @Override
                public boolean isMultiple(String nodeName, String newContextID) {
                    FieldBlockRefCardinalityTester fieldBlockRefCardinalityTester = new FieldBlockRefCardinalityTester(configuration.getMessage());
                    return fieldBlockRefCardinalityTester.isMultiple(newContextID, nodeName);
                }
            };
            ModelAccessor modelAccessor = new ModelAccessor(standard);
            if (rule.getSubject() != null && rule.getSubject().eContainer() instanceof ReusedBlock) {
                EList<Field> reusedField = ((ReusedBlock)rule.getSubject().eContainer()).getFields();
                modelAccessor = new ModelAccessor(standard, (List)reusedField){
                    private final /* synthetic */ List val$reusedField;
                    {
                        this.val$reusedField = list;
                        super($anonymous0);
                    }

                    @Override
                    public Block getBlock(String fullQualifiedId) {
                        return null;
                    }

                    @Override
                    public Field getField(String fullQualifiedId) {
                        Field field = super.getField(fullQualifiedId);
                        if (this.val$reusedField.contains(field)) {
                            return field;
                        }
                        return null;
                    }
                };
            }
            contextFormule.put("MODEL_ACCESSOR", modelAccessor);
            contextFormule.put("TYPING_ENVIRONMENT", env);
            contextFormule.put("RULE", rule);
            contextFormule.put("DSL", rule.getDslExpression());
            isValid = Diagnostician.INSTANCE.validate((EObject)ast, diagnostics, contextFormule);
        }
        return isValid;
    }

    public boolean validateRule_IsBooleanType(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        try {
            Type dslType;
            DslExpressionExtractor dslExpressionExtractor = new DslExpressionExtractor();
            StandardUtil standardUtil = new StandardUtil();
            Standard standard = standardUtil.getStandard(rule);
            Expression dslExpression = dslExpressionExtractor.extractDslExpressionFromRule(standard, rule);
            if (dslExpression != null && Type.BOOLEAN != (dslType = dslExpressionExtractor.getExpressionType(standard, dslExpression))) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The dsl type result must be BOOLEAN type instead of " + dslType.name() + ".", new Object[]{rule});
                diagnostics.add((Diagnostic)diagnostic);
                isValid = false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return isValid;
    }

    public boolean validateCsvDataValue(CsvDataValue csvDataValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(csvDataValue, diagnostics, context);
    }

    public boolean validateReusedBlock(ReusedBlock reusedBlock, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(reusedBlock, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(reusedBlock, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(reusedBlock, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(reusedBlock, diagnostics, context);
        }
        return result;
    }

    public boolean validateAbstractBinding(AbstractBinding abstractBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(abstractBinding, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(abstractBinding, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(abstractBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(abstractBinding, diagnostics, context);
        }
        return result;
    }

    public boolean validateReusedBlockSet(ReusedBlockSet reusedBlockSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(reusedBlockSet, diagnostics, context);
    }

    public boolean validateForeignKeyBinding(ForeignKeyBinding foreignKeyBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(foreignKeyBinding, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(foreignKeyBinding, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateForeignKeyBinding_FieldTypeCompatibility(foreignKeyBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateForeignKeyBinding_ForeignFieldFromForeignBlock(foreignKeyBinding, diagnostics, context);
        }
        return result;
    }

    public boolean validateForeignKeyBinding_FieldTypeCompatibility(ForeignKeyBinding foreignKeyBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        if (foreignKeyBinding.getLocalField() != null && foreignKeyBinding.getForeignField() != null) {
            DataType localDatatype = foreignKeyBinding.getLocalField().getDataType();
            DataType foreignDatatype = foreignKeyBinding.getForeignField().getDataType();
            if (localDatatype != null && foreignDatatype != null && !localDatatype.equals(foreignDatatype)) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The Datatype of the localField is not the same as the foreignField.", new Object[]{foreignKeyBinding});
                diagnostics.add((Diagnostic)diagnostic);
                isValid = false;
            }
        }
        return isValid;
    }

    public boolean validateForeignKeyBinding_ForeignFieldFromForeignBlock(ForeignKeyBinding foreignKeyBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        if (foreignKeyBinding.getForeignField() != null && !foreignKeyBinding.getForeignField().eContainer().equals(foreignKeyBinding.getForeignBlock())) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The foreignField is not a member of the foreignBlock.", new Object[]{foreignKeyBinding});
            diagnostics.add((Diagnostic)diagnostic);
            isValid = false;
        }
        return isValid;
    }

    public boolean validateReusedField(ReusedField reusedField, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(reusedField, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(reusedField, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageElement_UsageCantBeUnset(reusedField, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateField_PrimaryKeyHasEnumDatatype(reusedField, diagnostics, context);
        }
        return result;
    }

    public boolean validateFunctionBinding(FunctionBinding functionBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(functionBinding, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(functionBinding, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateDescription(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidateName(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_FullQualifiedIdIsUnique(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIdQualifiedElement_IdNotEmpty(functionBinding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFunctionBinding_ValidJavaClassName(functionBinding, diagnostics, context);
        }
        return result;
    }

    public boolean validateFunctionBinding_ValidJavaClassName(FunctionBinding functionBinding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            String ruleClassName = functionBinding.getJavaClass();
            ValidatorJavaPkgIdFormat validatorJavaPckIdFormat = new ValidatorJavaPkgIdFormat();
            validatorJavaPckIdFormat.isValideCaseInsessitive(ruleClassName);
            if (validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_IS_EMPTY_OR_NULL) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The rule class name format of the JavaRule element should not be empty or null.", new Object[]{functionBinding, SaturnePackage.Literals.JAVA_RULE__RULE_CLASS});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
            if (validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_CONTAIN_FORRDIDEN_CHAR || validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_FIRST_CHAR_IS_FORRDIDEN_CHAR) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The rule class name '" + ruleClassName + "' of the JavaRule element is invalid-> '" + validatorJavaPckIdFormat.getCharOrWordTriggerFailure() + "' is not an allowed character.", new Object[]{functionBinding, SaturnePackage.Literals.JAVA_RULE__RULE_CLASS});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
            if (validatorJavaPckIdFormat.getFailureResultType() == ValidatorJavaPkgIdFormat.FailureResultType.ID_IS_KEYWORD) {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "The rule class name format '" + ruleClassName + "' of the JavaRule element is invalid-> '" + validatorJavaPckIdFormat.getCharOrWordTriggerFailure() + "' is not an allowed word because java keyword is forbidden.", new Object[]{functionBinding, SaturnePackage.Literals.JAVA_RULE__RULE_CLASS});
                diagnostics.add((Diagnostic)diagnostic);
                return false;
            }
        }
        return true;
    }

    public boolean validateBindingSet(BindingSet bindingSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(bindingSet, diagnostics, context);
    }

    public boolean validateNatureType(NatureType natureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateUsageType(UsageType usageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateControlType(ControlType controlType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateRuleCriticity(RuleCriticity ruleCriticity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFilterType(FilterType filterType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

