/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.entities.util;

import fr.cnav.saturne.entities.Attribute;
import fr.cnav.saturne.entities.Child;
import fr.cnav.saturne.entities.DeclarationEntity;
import fr.cnav.saturne.entities.EntitiesModel;
import fr.cnav.saturne.entities.EntitiesPackage;
import fr.cnav.saturne.entities.Entity;
import fr.cnav.saturne.entities.NamedElement;
import fr.cnav.saturne.entities.PrimaryKeyElement;
import fr.cnav.saturne.entities.Relation;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class EntitiesValidator
extends EObjectValidator {
    public static final EntitiesValidator INSTANCE = new EntitiesValidator();
    public static final String DIAGNOSTIC_SOURCE = "fr.cnav.saturne.entities";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return EntitiesPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateNamedElement((NamedElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateEntitiesModel((EntitiesModel)value, diagnostics, context);
            }
            case 2: {
                return this.validateAttribute((Attribute)value, diagnostics, context);
            }
            case 3: {
                return this.validateRelation((Relation)value, diagnostics, context);
            }
            case 4: {
                return this.validateEntity((Entity)value, diagnostics, context);
            }
            case 5: {
                return this.validateChild((Child)value, diagnostics, context);
            }
            case 6: {
                return this.validateDeclarationEntity((DeclarationEntity)value, diagnostics, context);
            }
            case 7: {
                return this.validatePrimaryKeyElement((PrimaryKeyElement)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateNamedElement(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(namedElement, diagnostics, context);
    }

    public boolean validateEntitiesModel(EntitiesModel entitiesModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(entitiesModel, diagnostics, context);
    }

    public boolean validateAttribute(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(attribute, diagnostics, context);
    }

    public boolean validateRelation(Relation relation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(relation, diagnostics, context);
    }

    public boolean validateEntity(Entity entity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(entity, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(entity, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(entity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(entity, diagnostics, context);
        }
        if (!this.validate_NoCircularContainment(entity, diagnostics, context)) {
            return false;
        }
        if (result || diagnostics != null) {
            result &= this.validateEntity_AttributesAreLinkedToASingleMessageBloc(entity, diagnostics, context);
        }
        return result;
    }

    public boolean validateEntity_NoCircularContainment(Entity entity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateEntity_AttributesAreLinkedToASingleMessageBloc(Entity entity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateChild(Child child, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(child, diagnostics, context);
    }

    public boolean validateDeclarationEntity(DeclarationEntity declarationEntity, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(declarationEntity, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(declarationEntity, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(declarationEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(declarationEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(declarationEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(declarationEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(declarationEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(declarationEntity, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(declarationEntity, diagnostics, context);
        }
        if (!this.validate_NoCircularContainment(declarationEntity, diagnostics, context)) {
            return false;
        }
        if (result || diagnostics != null) {
            result &= this.validateEntity_AttributesAreLinkedToASingleMessageBloc(declarationEntity, diagnostics, context);
        }
        return result;
    }

    public boolean validatePrimaryKeyElement(PrimaryKeyElement primaryKeyElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(primaryKeyElement, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

