/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import java.util.Map;
import java.util.logging.Level;

public class QuantifiedTypeAdapter
extends DSLTypeAdapter {
    @Override
    Type computeType(Type context, Map<String, Type> env) {
        assert (this.getTarget() instanceof Quantified);
        assert (env != null);
        Quantified expr = (Quantified)this.getTarget();
        for (IteratorVariable variable : expr.getVariables()) {
            env.put(variable.getVarName(), this.getSimpleType(DSLTypeAdapterFactory.adapt(variable.getElement()).getType(context, env)));
        }
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(expr.getExpression());
        Type type = adapter.getType(context, env);
        if (type == Type.UNDEFINED) {
            this.setErrorMsg(adapter.getErrorMsg());
        } else if (type != Type.BOOLEAN) {
            this.setErrorMsg("Quantified expression's body must be of type BOOL : found " + (Object)((Object)type));
            return Type.UNDEFINED;
        }
        if (type == Type.UNDEFINED) {
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
        }
        return type;
    }

    private Type getSimpleType(Type listType) {
        Type result = listType;
        if (result == Type.ALPHANUM_LIST) {
            result = Type.ALPHANUM;
        } else if (result == Type.TOKEN_LIST) {
            result = Type.TOKEN;
        } else if (result == Type.NUM_LIST) {
            result = Type.NUM;
        } else if (result == Type.DATE_LIST) {
            result = Type.DATE;
        } else if (result == Type.NODE_LIST) {
            result = Type.NODE;
        }
        return result;
    }
}

