/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import java.util.Map;
import java.util.logging.Level;

public class InTypeAdapter
extends DSLTypeAdapter {
    private static final String AND = " and ";

    @Override
    Type computeType(Type context, Map<String, Type> env) {
        Type result;
        assert (this.getTarget() instanceof In);
        In in = (In)this.getTarget();
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(in.getLeftOp());
        Type elementType = adapter.getType(context, env);
        if (elementType == Type.UNDEFINED) {
            this.setErrorMsg(adapter.getErrorMsg());
            return Type.UNDEFINED;
        }
        DSLTypeAdapter listAdapter = DSLTypeAdapterFactory.adapt(in.getRightOp());
        switch (elementType) {
            case NUM: {
                Type listType = listAdapter.getType(context, env);
                boolean listTypeMatchToLeftOpType = listType == Type.NUM_LIST;
                result = this.computeInType(listTypeMatchToLeftOpType, listType, Type.NUM, listAdapter.getErrorMsg());
                break;
            }
            case ALPHANUM: {
                Type listType = listAdapter.getType(context, env);
                boolean listTypeMatchToLeftOpType = listType == Type.ALPHANUM_LIST || listType == Type.TOKEN_LIST;
                result = this.computeInType(listTypeMatchToLeftOpType, listType, Type.ALPHANUM, listAdapter.getErrorMsg());
                break;
            }
            case DATE: {
                Type listType = listAdapter.getType(context, env);
                boolean listTypeMatchToLeftOpType = listType == Type.DATE_LIST;
                result = this.computeInType(listTypeMatchToLeftOpType, listType, Type.DATE, listAdapter.getErrorMsg());
                break;
            }
            case TOKEN: {
                Type listType = listAdapter.getType(context, env);
                boolean listTypeMatchToLeftOpType = listType == Type.TOKEN_LIST || listType == Type.ALPHANUM_LIST;
                result = this.computeInType(listTypeMatchToLeftOpType, listType, Type.TOKEN, listAdapter.getErrorMsg());
                break;
            }
            case UNDEFINED: {
                result = Type.UNDEFINED;
                this.setErrorMsg(adapter.getErrorMsg());
                break;
            }
            default: {
                result = Type.UNDEFINED;
                this.setErrorMsg("Unknown Error");
            }
        }
        if (result == Type.UNDEFINED) {
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
        }
        return result;
    }

    private Type computeInType(boolean listTypeMatchToLeftOpType, Type listType, Type leftOpType, String errorMsg) {
        Type result;
        if (listTypeMatchToLeftOpType) {
            result = Type.BOOLEAN;
        } else if (listType == Type.UNDEFINED) {
            result = Type.UNDEFINED;
            this.setErrorMsg(errorMsg);
        } else {
            result = Type.UNDEFINED;
            this.setErrorMsg("In operator has incompatible list type: " + (Object)((Object)leftOpType) + AND + (Object)((Object)listType));
        }
        return result;
    }
}

