/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import java.util.Map;
import java.util.logging.Level;

public class ArithmeticNaryTypeAdapter
extends DSLTypeAdapter {
    @Override
    Type computeType(Type context, Map<String, Type> env) {
        assert (this.getTarget() instanceof Nary);
        Nary target = (Nary)this.getTarget();
        for (Expression expr : target.getOperands()) {
            DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(expr);
            if (adapter.getType(Type.UNDEFINED, env) == Type.NUM) continue;
            if (adapter.getType(context, env) == Type.UNDEFINED) {
                this.setErrorMsg(adapter.getErrorMsg());
            } else {
                this.setErrorMsg("N4DSType : Arithmetic operator's operands must be of numerical type: " + (Object)((Object)adapter.getType()));
            }
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
            return Type.UNDEFINED;
        }
        return Type.NUM;
    }
}

