/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.parser.configuration;

import fr.cnav.saturne.Alias;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.ExternalFunctionDefinition;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Macro;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.RulesConfiguration;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.dsl.gen.common.navigation.IMessage;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.parser.ParserConfigurationException;
import fr.cnav.saturne.dsl.parser.configuration.StandardMessage;
import fr.cnav.saturne.dsl.parser.configuration.StandardMessageNode;
import fr.cnav.saturne.dsl.types.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class StandardParserConfiguration
implements IParserConfiguration {
    private Map<String, String> options = new HashMap<String, String>();
    protected Properties parserEnvironment;
    protected HashMap<String, Type> types = new HashMap();
    private Standard standard;
    private Map<String, StandardMessageNode> nodes = new HashMap<String, StandardMessageNode>();
    private StandardMessage message;

    public StandardParserConfiguration(Standard standard, Map<String, String> options) throws ParserConfigurationException {
        this.parserEnvironment = new Properties();
        this.options = new HashMap<String, String>();
        if (options != null) {
            this.options.putAll(options);
        }
        this.message = new StandardMessage();
        this.fillSymbolTable(standard);
        this.standard = standard;
        this.fillDefinitions();
        this.message.setNodes(this.nodes);
        this.message.setTypes(this.types);
    }

    private void fillDefinitions() {
        RulesConfiguration conf = this.standard.getConfigurations();
        if (conf != null && conf.getExternalFunctions() != null && !conf.getExternalFunctions().isEmpty()) {
            for (ExternalFunctionDefinition definition : conf.getExternalFunctions()) {
                if (definition.getName() == null || definition.getSignature() == null || definition.getSpecification() == null) continue;
                String key = String.valueOf(definition.getName()) + "/" + definition.getCardinality();
                this.parserEnvironment.put(key, definition.getSpecification());
                this.parserEnvironment.put(String.valueOf(key) + ".prototype", definition.getSignature());
            }
        }
    }

    private void fillSymbolTable(Standard processedStandard) {
        this.registerNode(processedStandard.getMessage(), 0);
        this.initSymbols(processedStandard.getMessage().getHeaderBlock(), 1);
        this.initSymbols(processedStandard.getMessage().getFooterBlock(), 1);
        if (processedStandard.getReusedBlocks() != null) {
            for (ReusedBlock reusedBlock : processedStandard.getReusedBlocks().getReusedBlocks()) {
                this.initSymbols(reusedBlock);
            }
        }
    }

    private void registerNode(MessageElement element, int depth) {
        this.nodes.put(element.getFullQualifiedId(), new StandardMessageNode(this.message, element, depth));
    }

    private void initSymbols(Block block, int depth) {
        this.types.put(block.getFullQualifiedId(), Type.NODE);
        this.registerNode(block, depth);
        for (Field field : block.getChildrenFields()) {
            this.types.put(field.getFullQualifiedId(), this.dataType(field));
            this.registerNode(field, depth + 1);
        }
        for (Block child : block.getChildrenBlocks()) {
            this.initSymbols(child, depth + 1);
        }
    }

    private void initSymbols(ReusedBlock block) {
        for (Field field : block.getFields()) {
            this.types.put(field.getFullQualifiedId(), this.dataType(field));
            this.registerNode(field, 1);
        }
    }

    private Type dataType(Field field) {
        Type result;
        if (field.getDataType() == null) {
            result = Type.UNDEFINED;
            Logging.LOGGER.log(Level.SEVERE, "The given field has no datatype : " + field.getFullQualifiedId());
        } else {
            switch (field.getDataType().getNature()) {
                case ALPHANUMERIC: {
                    result = Type.ALPHANUM;
                    break;
                }
                case DATE: {
                    result = Type.DATE;
                    break;
                }
                case ENUMERATION: {
                    result = Type.TOKEN;
                    break;
                }
                case EXTERNAL_REFERENTIAL: {
                    result = Type.TOKEN;
                    break;
                }
                case NUMERIC: {
                    result = Type.NUM;
                    break;
                }
                default: {
                    result = Type.UNDEFINED;
                }
            }
        }
        return result;
    }

    @Override
    public List<AliasForParser> aliases() {
        return this.aliases(this.standard.getConfigurations());
    }

    protected List<AliasForParser> aliases(RulesConfiguration conf) {
        ArrayList<AliasForParser> aliases = new ArrayList<AliasForParser>();
        if (conf != null && conf.getMacros() != null) {
            for (Macro macro : conf.getMacros()) {
                aliases.add(new AliasForParser("@" + macro.getName(), macro.getExpression()));
            }
        }
        if (conf != null && conf.getAliases() != null) {
            for (Alias alias : conf.getAliases()) {
                if (alias.getReference() == null) continue;
                aliases.add(new AliasForParser("@" + alias.getName(), alias.getReference().getFullQualifiedId()));
            }
        }
        Collections.sort(aliases, new Comparator<AliasForParser>(){

            @Override
            public int compare(AliasForParser o1, AliasForParser o2) {
                if (o1.getKey().compareTo(o2.getKey()) >= 1) {
                    return -1;
                }
                if (o1.getKey().compareTo(o2.getKey()) <= -1) {
                    return 1;
                }
                return 0;
            }
        });
        return aliases;
    }

    @Override
    public Map<String, String> options() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    public String getDefinition(String key) {
        return this.parserEnvironment.getProperty(key);
    }

    @Override
    public Type getType(String nodeName) {
        Type type = this.types.get(nodeName);
        if (type == null) {
            return Type.UNDEFINED;
        }
        return type;
    }

    @Override
    public IMessage getMessage() {
        return this.message;
    }

    public static class AliasForParser {
        private String key;
        private String value;

        public AliasForParser(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.key;
        }
    }
}

