/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.parser;

import fr.cnav.saturne.dsl.ast.validator.ModelValidationFailedException;
import fr.cnav.saturne.dsl.ast.validator.ModelValidator;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.optimization.FreshVariableGenerator;
import fr.cnav.saturne.dsl.optimization.invariants.InvariantTransformation;
import fr.cnav.saturne.dsl.optimization.vn.ValueNumbering;
import fr.cnav.saturne.dsl.parser.ASTFormulesLexer;
import fr.cnav.saturne.dsl.parser.ASTFormulesListener;
import fr.cnav.saturne.dsl.parser.FormuleTraducteurException;
import fr.cnav.saturne.dsl.parser.FormulesErrorListener;
import fr.cnav.saturne.dsl.parser.FormulesErrorStrategy;
import fr.cnav.saturne.dsl.parser.FormulesParser;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.parser.configuration.StandardParserConfiguration;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import fr.cnav.saturne.dsl.types.adapter.ITypingEnvironment;
import fr.cnav.saturne.utils.FieldBlockRefCardinalityTester;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FormuleTraducteur {
    public static final String ALIAS_PREFIX = "@";
    public static final String DO_INVARIANT_HOISTING = "INVARIANT_HOISTING";
    public static final String DO_VALUE_NUMBERING = "VALUE_NUMBERING";
    private IParserConfiguration configuration;

    public FormuleTraducteur(IParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public IParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean doInvariantHoisting() {
        return "true".equals(this.configuration.options().get(DO_INVARIANT_HOISTING));
    }

    public boolean doValueNumbering() {
        return "true".equals(this.configuration.options().get(DO_VALUE_NUMBERING));
    }

    public void disableOption(String key) {
        this.configuration.options().put(key, "false");
    }

    protected String processAliases(String dslStr) throws FormuleTraducteurException {
        List<StandardParserConfiguration.AliasForParser> aliases = this.configuration.aliases();
        String result = dslStr;
        String atString = ALIAS_PREFIX;
        for (StandardParserConfiguration.AliasForParser entry : aliases) {
            String key = entry.getKey();
            String value = entry.getValue();
            result = result.replaceAll(key, "(" + value + ")");
        }
        if (result.contains(atString)) {
            String alias = result.split(atString)[1].split("[^a-zA-Z1-9_-]")[0];
            throw new FormuleTraducteurException("alias not found:" + atString + alias);
        }
        return result;
    }

    protected String processSubject(String input, String subject) {
        String result = input;
        result = result.replaceAll("\\$rub([^a-zA-Z1-9_-])", String.valueOf(subject) + "$1");
        result = result.replaceAll("\\$rub$", subject);
        return result;
    }

    private String cleanUp(String dsl) {
        return dsl.replaceAll("\\s", " ");
    }

    public Expression processDSL(String inputDSL, String subject, String context) throws FormuleTraducteurException {
        String dsl = this.cleanUp(inputDSL);
        FreshVariableGenerator.reset();
        dsl = this.processAliases(dsl);
        dsl = this.processSubject(dsl, subject);
        try {
            return this.translateDSL(dsl, context);
        }
        catch (ModelValidationFailedException e) {
            throw new FormuleTraducteurException("Invalid model produced : this is due to an invalid model : " + e.getMessage(), e);
        }
    }

    public Expression parse(String inputDSL, String subject, String context) throws FormuleTraducteurException {
        String dsl = this.processAliases(inputDSL);
        dsl = this.processSubject(dsl, subject);
        ANTLRInputStream sequence = new ANTLRInputStream(dsl);
        ASTFormulesLexer lexer = new ASTFormulesLexer((CharStream)sequence);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FormulesParser parser = new FormulesParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new FormulesErrorStrategy());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new FormulesErrorListener());
        FormulesParser.EntryContext tree = parser.entry();
        ASTFormulesListener extractor = new ASTFormulesListener(parser);
        try {
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)extractor, (ParseTree)tree);
            return extractor.getAST();
        }
        catch (RecognitionException e) {
            throw new FormuleTraducteurException("problem during parsing : " + e.getMessage(), (Exception)((Object)e));
        }
        catch (FormuleTraducteurException e) {
            throw new FormuleTraducteurException("problem during parsing : " + e.getMessage(), e);
        }
    }

    protected Expression translateDSL(String input, String context) throws FormuleTraducteurException, ModelValidationFailedException {
        EObject astInput;
        InvariantTransformation invariantTransformation;
        Expression astTransform;
        ANTLRInputStream sequence = new ANTLRInputStream(input);
        ASTFormulesLexer lexer = new ASTFormulesLexer((CharStream)sequence);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FormulesParser parser = new FormulesParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new FormulesErrorStrategy());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new FormulesErrorListener());
        FormulesParser.EntryContext tree = parser.entry();
        ASTFormulesListener extractor = new ASTFormulesListener(parser);
        Expression ast = null;
        try {
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)extractor, (ParseTree)tree);
            ast = extractor.getAST();
        }
        catch (RecognitionException e) {
            throw new FormuleTraducteurException("Syntax error: ", (Exception)((Object)e));
        }
        catch (FormuleTraducteurException e) {
            throw new FormuleTraducteurException("Syntax error: ", e);
        }
        this.initiateTypeAdapter(ast, context);
        ModelValidator validator = new ModelValidator(this.configuration);
        validator.validate(ast);
        if (this.doInvariantHoisting() && ast instanceof Expression && (astTransform = (invariantTransformation = new InvariantTransformation()).transform((Expression)(astInput = EcoreUtil.copy((EObject)ast)))) != null) {
            ast = astTransform;
        }
        if (this.doValueNumbering()) {
            ValueNumbering vn = new ValueNumbering();
            ast = vn.transform(ast);
        }
        return ast;
    }

    public void initiateTypeAdapter(Expression ast, final String dslContext) throws FormuleTraducteurException {
        ITypingEnvironment env = new ITypingEnvironment(){

            @Override
            public String getSignature(String functionName, int argCount) {
                String key = String.valueOf(functionName) + "/" + argCount + ".prototype";
                return FormuleTraducteur.this.configuration.getDefinition(key);
            }

            @Override
            public Type getNodeType(String nodeName) {
                return FormuleTraducteur.this.configuration.getType(nodeName);
            }

            @Override
            public boolean isMultiple(String nodeName) {
                FieldBlockRefCardinalityTester fieldBlockRefCardinalityTester = new FieldBlockRefCardinalityTester(FormuleTraducteur.this.configuration.getMessage());
                return fieldBlockRefCardinalityTester.isMultiple(dslContext, nodeName);
            }

            @Override
            public boolean isMultiple(String nodeName, String newContextID) {
                FieldBlockRefCardinalityTester fieldBlockRefCardinalityTester = new FieldBlockRefCardinalityTester(FormuleTraducteur.this.configuration.getMessage());
                return fieldBlockRefCardinalityTester.isMultiple(newContextID, nodeName);
            }
        };
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(ast);
        adapter.setTypingEnvironment(env);
        Type type = adapter.getType();
        if (type == Type.UNDEFINED) {
            throw new FormuleTraducteurException("Typing error: " + adapter.getErrorMsg());
        }
    }
}

