/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.invariants;

import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class InvariantDetector
extends FormulesSwitch<Boolean> {
    private Set<String> linkedVariables;
    private HashSet<Expression> invariants;

    public Set<Expression> getInvariants(Quantified quantifiedExpr) {
        this.invariants = new HashSet();
        this.linkedVariables = new HashSet<String>();
        for (IteratorVariable iteratorVariable : quantifiedExpr.getVariables()) {
            this.linkedVariables.add(iteratorVariable.getVarName());
        }
        this.doSwitch(quantifiedExpr.getExpression());
        return this.invariants;
    }

    public Set<Expression> getInvariants(Let letExpr) {
        this.invariants = new HashSet();
        this.linkedVariables = new HashSet<String>();
        for (Binding binding : letExpr.getBindings()) {
            this.linkedVariables.add(binding.getVarName());
        }
        this.doSwitch(letExpr.getIn());
        return this.invariants;
    }

    @Override
    public Boolean caseQuantified(Quantified object) {
        boolean invariant = true;
        for (IteratorVariable var : object.getVariables()) {
            if (!this.linkedVariables.contains(var.getVarName()) && !this.linkedVariables.contains(var.getElement().getContextVariable())) continue;
            invariant = false;
            break;
        }
        if (invariant) {
            HashSet savedInvariants = (HashSet)this.invariants.clone();
            this.doSwitch(object.getExpression());
            if (this.invariants.contains(object.getExpression())) {
                savedInvariants.add(object);
            }
            this.invariants = savedInvariants;
        }
        for (IteratorVariable iteratorVariable : object.getVariables()) {
            this.linkedVariables.add(iteratorVariable.getVarName());
        }
        boolean result = true;
        result = (Boolean)this.doSwitch(object.getExpression());
        if (result) {
            this.invariants.add(object);
        }
        return result;
    }

    @Override
    public Boolean caseLet(Let object) {
        for (Binding binding : object.getBindings()) {
            TreeIterator treeIterator = binding.eAllContents();
            while (treeIterator.hasNext()) {
                FieldRef curStuc;
                EObject curEObj = (EObject)treeIterator.next();
                if (!(curEObj instanceof FieldRef) || !this.linkedVariables.contains((curStuc = (FieldRef)curEObj).getContextVariable())) continue;
                this.linkedVariables.add(binding.getVarName());
            }
        }
        boolean result = true;
        result = (Boolean)this.doSwitch(object.getIn());
        if (result) {
            this.invariants.add(object);
        }
        return result;
    }

    @Override
    public Boolean caseFieldRef(FieldRef object) {
        boolean result;
        String variable = object.getContextVariable();
        boolean bl = result = variable != null && !this.linkedVariables.contains(variable);
        if (result) {
            this.invariants.add(object);
        }
        return result;
    }

    @Override
    public Boolean caseVarRef(VarRef object) {
        boolean result;
        String variable = object.getVarName();
        boolean bl = result = variable != null && !this.linkedVariables.contains(variable);
        if (result) {
            this.invariants.add(object);
        }
        return result;
    }

    @Override
    public Boolean caseExpression(Expression object) {
        EList contents = object.eContents();
        boolean result = true;
        for (EObject eObject : contents) {
            result &= ((Boolean)this.doSwitch(eObject)).booleanValue();
        }
        if (result) {
            this.invariants.add(object);
        }
        return result;
    }

    @Override
    public Boolean defaultCase(EObject object) {
        return true;
    }
}

