/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.metacontrol;

import fr.cnav.saturne.DataType;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.dsl.formules.AlphaNum;
import fr.cnav.saturne.dsl.formules.Diff;
import fr.cnav.saturne.dsl.formules.Equals;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FormulesPackage;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.Greater;
import fr.cnav.saturne.dsl.formules.GreaterEqual;
import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.formules.Lower;
import fr.cnav.saturne.dsl.formules.LowerEqual;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.metacontrol.AbstractTransformation;
import fr.cnav.saturne.dsl.metacontrol.NodeTyper;
import fr.cnav.saturne.dsl.parser.ParserConfigurationException;
import fr.cnav.saturne.dsl.types.Type;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class OperatorNormalizer
extends AbstractTransformation {
    private NodeTyper typer;
    private ModelAccessor modelAccessor;

    public OperatorNormalizer(Standard theStandard) throws ParserConfigurationException, IOException {
        this.typer = new NodeTyper(theStandard);
        this.modelAccessor = new ModelAccessor(theStandard);
    }

    Expression normalize(Expression candidate) {
        return (Expression)this.doSwitch(candidate);
    }

    @Override
    public Expression caseExpression(Expression object) {
        return object;
    }

    @Override
    public Expression caseDiff(Diff object) {
        FieldRef ref = object.getLeftOp() instanceof FieldRef ? (FieldRef)object.getLeftOp() : (object.getRightOp() instanceof FieldRef ? (FieldRef)object.getRightOp() : null);
        Type type = ref != null ? this.typer.getType(ref) : Type.UNDEFINED;
        if (type == Type.TOKEN) {
            Field field;
            DataType dataType;
            String value = object.getRightOp() instanceof AlphaNum ? ((AlphaNum)object.getRightOp()).getValue() : (object.getLeftOp() instanceof AlphaNum ? ((AlphaNum)object.getLeftOp()).getValue() : null);
            if (ref != null && value != null && (dataType = (field = this.modelAccessor.getField(ref.getName())).getDataType()) instanceof EnumDataType) {
                EnumDataType fieldType = (EnumDataType)dataType;
                EList<Value> values = fieldType.getValues();
                ValueList list = this.createList(value, (List<Value>)values);
                In in = (In)EcoreUtil.create((EClass)FormulesPackage.Literals.IN);
                in.setLeftOp(ref);
                in.setRightOp(list);
                return in;
            }
        }
        Equals eq = (Equals)EcoreUtil.create((EClass)FormulesPackage.Literals.EQUALS);
        eq.setLeftOp(object.getLeftOp());
        eq.setRightOp(object.getRightOp());
        Not not = (Not)EcoreUtil.create((EClass)FormulesPackage.Literals.NOT);
        not.setOperand(eq);
        return not;
    }

    @Override
    public Expression caseEquals(Equals object) {
        FieldRef ref = object.getLeftOp() instanceof FieldRef ? (FieldRef)object.getLeftOp() : (object.getRightOp() instanceof FieldRef ? (FieldRef)object.getRightOp() : null);
        Type type = ref != null ? this.typer.getType(ref) : Type.UNDEFINED;
        if (type == Type.TOKEN) {
            AlphaNum value = object.getRightOp() instanceof AlphaNum ? (AlphaNum)object.getRightOp() : (object.getLeftOp() instanceof AlphaNum ? (AlphaNum)object.getLeftOp() : null);
            if (ref != null && value != null) {
                In in = (In)EcoreUtil.create((EClass)FormulesPackage.Literals.IN);
                in.setLeftOp(ref);
                ValueList list = (ValueList)EcoreUtil.create((EClass)FormulesPackage.Literals.VALUE_LIST);
                list.getValues().add((Object)value);
                in.setRightOp(list);
                return in;
            }
        }
        return object;
    }

    @Override
    public Expression caseGreaterEqual(GreaterEqual object) {
        Not not = (Not)EcoreUtil.create((EClass)FormulesPackage.Literals.NOT);
        Lower lower = (Lower)EcoreUtil.create((EClass)FormulesPackage.Literals.LOWER);
        lower.setLeftOp(object.getLeftOp());
        lower.setRightOp(object.getRightOp());
        not.setOperand(lower);
        return not;
    }

    @Override
    public Expression caseGreater(Greater object) {
        Not not = (Not)EcoreUtil.create((EClass)FormulesPackage.Literals.NOT);
        LowerEqual lowerEquals = (LowerEqual)EcoreUtil.create((EClass)FormulesPackage.Literals.LOWER_EQUAL);
        lowerEquals.setLeftOp(object.getLeftOp());
        lowerEquals.setRightOp(object.getRightOp());
        not.setOperand(lowerEquals);
        return not;
    }

    @Override
    public Expression caseFunctionCall(FunctionCall object) {
        if ("isAbsent".equals(object.getName()) && object.getArguments().size() == 1) {
            Not not = (Not)EcoreUtil.create((EClass)FormulesPackage.Literals.NOT);
            not.setOperand(object);
            object.setName("isPresent");
            return not;
        }
        return super.caseFunctionCall(object);
    }

    private ValueList createList(String excludedValue, List<Value> values) {
        ValueList result = (ValueList)EcoreUtil.create((EClass)FormulesPackage.Literals.VALUE_LIST);
        for (Value value : values) {
            if (excludedValue.equals(value.getId())) continue;
            AlphaNum literal = (AlphaNum)EcoreUtil.create((EClass)FormulesPackage.Literals.ALPHA_NUM);
            literal.setValue(value.getId());
            result.getValues().add((Object)literal);
        }
        return result;
    }
}

