/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.metacontrol;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.parser.ParserConfigurationException;
import fr.cnav.saturne.dsl.parser.configuration.StandardParserConfiguration;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import fr.cnav.saturne.dsl.types.adapter.ITypingEnvironment;
import java.util.Collections;

public class NodeTyper {
    private final IParserConfiguration config;
    private final Standard standard;
    private final ITypingEnvironment typingEnvironment;

    public NodeTyper(Standard theStandard) throws ParserConfigurationException {
        this.standard = theStandard;
        this.config = new StandardParserConfiguration(this.standard, Collections.emptyMap());
        this.typingEnvironment = new ITypingEnvironment(){

            @Override
            public String getSignature(String functionName, int argCount) {
                String key = String.valueOf(functionName) + "/" + argCount + ".prototype";
                return NodeTyper.this.config.getDefinition(key);
            }

            @Override
            public Type getNodeType(String nodeName) {
                return NodeTyper.this.config.getType(nodeName);
            }
        };
    }

    public Type getType(Expression expression) {
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(expression);
        adapter.setTypingEnvironment(this.typingEnvironment);
        return adapter.getType();
    }
}

