/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.metacontrol;

import fr.cnav.saturne.Field;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FormulesPackage;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.Or;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.metacontrol.AbstractMetacontrolValidation;
import fr.cnav.saturne.dsl.metacontrol.MetacontrolValidationInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MetacontrolContradictoryValidation
extends AbstractMetacontrolValidation {
    private static final String FIELD_SUBJECT_LABEL_IN_DSL_EXPRESSION = "$rub";
    private static final String IS_PRESENT = "isPresent";
    private List<MetacontrolValidationInfo> validationInfos;
    private Map<Expression, GenericRule> literalToRuleMap;
    private ModelAccessor modelAccessor;
    private List<Expression> clauseKnowledge;

    public MetacontrolContradictoryValidation(List<Expression> clauses, ModelAccessor theModelAccessor, Map<Expression, GenericRule> theClauseToRuleMap) {
        this.modelAccessor = theModelAccessor;
        this.validationInfos = new ArrayList<MetacontrolValidationInfo>();
        this.clauseKnowledge = clauses;
        this.literalToRuleMap = new HashMap<Expression, GenericRule>();
        for (Expression clause : clauses) {
            for (Expression literal : this.getLiteralsFromClause(clause)) {
                this.literalToRuleMap.put(literal, theClauseToRuleMap.get(clause));
            }
        }
    }

    public List<MetacontrolValidationInfo> checkContradictions() {
        List<Object> resolvantsBefore = new ArrayList();
        List<Object> newResolvants = new ArrayList();
        newResolvants = this.checkContradictionByComputingEveryResolvant(this.clauseKnowledge);
        while (newResolvants.size() != 0) {
            resolvantsBefore = newResolvants;
            newResolvants = new ArrayList();
            for (Expression expression : resolvantsBefore) {
                for (Expression clause : this.clauseKnowledge) {
                    Or computedResolvant = this.computeResolvant(clause, expression);
                    if (computedResolvant == null || this.doesResolvantExist(resolvantsBefore, newResolvants, computedResolvant)) continue;
                    if (this.isResolvantContradictory(computedResolvant)) {
                        this.logContradictionError(clause, expression);
                    } else if (computedResolvant.getOperands().size() == 1) {
                        this.logConstrainstError(clause, expression, this.getStringExpression((Expression)computedResolvant.getOperands().get(0)));
                    }
                    newResolvants.add(computedResolvant);
                }
            }
            newResolvants.addAll(this.checkContradictionByComputingEveryResolvant(resolvantsBefore));
            this.clauseKnowledge.addAll(resolvantsBefore);
        }
        return this.validationInfos;
    }

    private List<Expression> checkContradictionByComputingEveryResolvant(List<Expression> clauses) {
        ArrayList<Expression> newResolvants = new ArrayList<Expression>();
        int size = clauses.size();
        int i = 0;
        while (i < size) {
            Expression clause1 = clauses.get(i);
            int j = i + 1;
            while (j < size) {
                Expression clause2 = clauses.get(j);
                Or computedResolvant = this.computeResolvant(clause1, clause2);
                if (computedResolvant != null && !this.doesResolvantExist(clauses, newResolvants, computedResolvant)) {
                    if (this.isResolvantContradictory(computedResolvant)) {
                        this.logContradictionError(clause1, clause2);
                    } else if (computedResolvant.getOperands().size() == 1) {
                        this.logConstrainstError(clause1, clause2, this.getStringExpression((Expression)computedResolvant.getOperands().get(0)));
                    }
                    newResolvants.add(computedResolvant);
                }
                ++j;
            }
            ++i;
        }
        return newResolvants;
    }

    private boolean isResolvantContradictory(Or resolvant) {
        boolean isContradictory = false;
        if (resolvant.getOperands().size() == 0) {
            isContradictory = true;
        }
        if (resolvant.getOperands().size() == 1) {
            isContradictory = this.isWeakContradiction(resolvant);
        }
        return isContradictory;
    }

    private boolean isWeakContradiction(Or resolvant) {
        Expression expression;
        Field field;
        Expression notOperand;
        Expression expression2;
        Field field2;
        boolean isWeakContradiction = false;
        Expression operand = (Expression)resolvant.getOperands().get(0);
        if (operand instanceof FunctionCall && IS_PRESENT.equals(((FunctionCall)operand).getName()) && (field2 = this.getFieldFromExpression(expression2 = (Expression)((FunctionCall)operand).getArguments().get(0))) != null && "Forbidden".equals(field2.getUsage().getLiteral())) {
            isWeakContradiction = true;
        }
        if (operand instanceof Not && (notOperand = ((Not)operand).getOperand()) instanceof FunctionCall && IS_PRESENT.equals(((FunctionCall)notOperand).getName()) && (field = this.getFieldFromExpression(expression = (Expression)((FunctionCall)notOperand).getArguments().get(0))) != null && "Mandatory".equals(field.getUsage().getLiteral())) {
            isWeakContradiction = true;
        }
        return isWeakContradiction;
    }

    private Field getFieldFromExpression(Expression literal) {
        Field field = null;
        if (literal instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)literal;
            field = this.modelAccessor.getField(fieldRef.getName());
        } else {
            VarRef varRef = (VarRef)literal;
            String varName = varRef.getVarName();
            if (FIELD_SUBJECT_LABEL_IN_DSL_EXPRESSION.equals(varName.toLowerCase())) {
                GenericRule genericRule = this.literalToRuleMap.get(literal);
                return genericRule.getSubject();
            }
        }
        return field;
    }

    private Or computeResolvant(Expression clause1, Expression clause2) {
        Nary resolvant = null;
        ArrayList<Expression> literalsClause1 = this.getLiteralsFromClause(clause1);
        ArrayList<Expression> literalsClause2 = this.getLiteralsFromClause(clause2);
        for (Expression literal1 : literalsClause1) {
            for (Expression literal2 : literalsClause2) {
                if (!this.areOppositeLiterals(literal1, literal2)) continue;
                if (resolvant != null) {
                    return null;
                }
                Or or = this.createResolvant(literalsClause1, literalsClause2, literal1, literal2);
                resolvant = or;
            }
        }
        if (resolvant != null && resolvant.getOperands().size() > literalsClause1.size() && resolvant.getOperands().size() > literalsClause2.size()) {
            resolvant = null;
        }
        return resolvant;
    }

    private Or createResolvant(ArrayList<Expression> literalsClause1, ArrayList<Expression> literalsClause2, Expression literal1, Expression literal2) {
        Expression literalCopy;
        Or or = (Or)EcoreUtil.create((EClass)FormulesPackage.Literals.OR);
        for (Expression literal : literalsClause1) {
            if (EcoreUtil.equals((EObject)literal, (EObject)literal1)) continue;
            literalCopy = (Expression)EcoreUtil.copy((EObject)literal);
            or.getOperands().add((Object)literalCopy);
            this.literalToRuleMap.put(literalCopy, this.literalToRuleMap.get(literal));
        }
        for (Expression literal : literalsClause2) {
            if (EcoreUtil.equals((EObject)literal, (EObject)literal2) || this.isExpressionInList((List<Expression>)or.getOperands(), literal)) continue;
            literalCopy = (Expression)EcoreUtil.copy((EObject)literal);
            or.getOperands().add((Object)literalCopy);
            this.literalToRuleMap.put(literalCopy, this.literalToRuleMap.get(literal));
        }
        return or;
    }

    private boolean areOppositeLiterals(Expression literal1, Expression literal2) {
        Expression oppositeLiteral1 = null;
        if (literal1 instanceof Not) {
            oppositeLiteral1 = ((Not)literal1).getOperand();
        } else {
            Not not = (Not)EcoreUtil.create((EClass)FormulesPackage.Literals.NOT);
            not.setOperand((Expression)EcoreUtil.copy((EObject)literal1));
            oppositeLiteral1 = not;
        }
        return EcoreUtil.equals((EObject)literal2, (EObject)oppositeLiteral1);
    }

    private void logContradictionError(Expression clause1, Expression clause2) {
        List<String> rules = this.findRulesWithError(clause1, clause2);
        StringBuilder sb = new StringBuilder("Les contr\u00f4les ");
        int size = rules.size();
        int i = 0;
        while (i < size) {
            sb.append(rules.get(i));
            if (i < size - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(" induisent une contradiction. Les clauses contradictoires sont ");
        sb.append(this.getStringExpression(clause1)).append(" et ").append(this.getStringExpression(clause2));
        this.validationInfos.add(MetacontrolValidationInfo.error(sb.toString(), new ArrayList<String>(rules), new ArrayList<String>(Arrays.asList(this.getStringExpression(clause1), this.getStringExpression(clause2)))));
    }

    private List<String> findRulesWithError(Expression clause1, Expression clause2) {
        GenericRule rule;
        ArrayList<String> rules = new ArrayList<String>();
        for (Expression literal : this.getLiteralsFromClause(clause1)) {
            rule = this.literalToRuleMap.get(literal);
            if (rules.contains(rule.getFullId())) continue;
            rules.add(rule.getFullId());
        }
        for (Expression literal : this.getLiteralsFromClause(clause2)) {
            rule = this.literalToRuleMap.get(literal);
            if (rules.contains(rule.getFullId())) continue;
            rules.add(rule.getFullId());
        }
        return rules;
    }

    private void logConstrainstError(Expression clause1, Expression clause2, String contraint) {
        List<String> rules = this.findRulesWithError(clause1, clause2);
        StringBuilder sb = new StringBuilder("Les contr\u00f4les ");
        int size = rules.size();
        int i = 0;
        while (i < size) {
            sb.append(rules.get(i));
            if (i < size - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(" induisent une contrainte " + contraint + ". Les clauses contradictoires sont ");
        sb.append(this.getStringExpression(clause1)).append(" et ").append(this.getStringExpression(clause2));
        this.validationInfos.add(MetacontrolValidationInfo.error(sb.toString(), new ArrayList<String>(rules), new ArrayList<String>(Arrays.asList(this.getStringExpression(clause1), this.getStringExpression(clause2)))));
    }

    private boolean isExpressionInList(List<Expression> expressions, Expression expRef) {
        for (Expression exp : expressions) {
            if (!this.areClausesDuplicate(exp, expRef)) continue;
            return true;
        }
        return false;
    }

    private boolean doesResolvantExist(List<Expression> clauses, List<Expression> newResolvants, Or computedResolvant) {
        return this.isExpressionInList(this.clauseKnowledge, computedResolvant) || this.isExpressionInList(clauses, computedResolvant) || this.isExpressionInList(newResolvants, computedResolvant);
    }
}

