/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.formules.util;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.dsl.formules.Add;
import fr.cnav.saturne.dsl.formules.AlphaNum;
import fr.cnav.saturne.dsl.formules.And;
import fr.cnav.saturne.dsl.formules.Binary;
import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Call;
import fr.cnav.saturne.dsl.formules.Child;
import fr.cnav.saturne.dsl.formules.Children;
import fr.cnav.saturne.dsl.formules.Date;
import fr.cnav.saturne.dsl.formules.Diff;
import fr.cnav.saturne.dsl.formules.Div;
import fr.cnav.saturne.dsl.formules.Equals;
import fr.cnav.saturne.dsl.formules.Equiv;
import fr.cnav.saturne.dsl.formules.Error;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FormulesPackage;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.Greater;
import fr.cnav.saturne.dsl.formules.GreaterEqual;
import fr.cnav.saturne.dsl.formules.Imply;
import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.Lower;
import fr.cnav.saturne.dsl.formules.LowerEqual;
import fr.cnav.saturne.dsl.formules.Mult;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.NodeExpression;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.Num;
import fr.cnav.saturne.dsl.formules.Or;
import fr.cnav.saturne.dsl.formules.Parent;
import fr.cnav.saturne.dsl.formules.PathExpression;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.Quantifier;
import fr.cnav.saturne.dsl.formules.SingleChild;
import fr.cnav.saturne.dsl.formules.Sub;
import fr.cnav.saturne.dsl.formules.Unary;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import fr.cnav.saturne.dsl.types.adapter.ITypingEnvironment;
import fr.cnav.saturne.utils.DSLErrorUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class FormulesValidator
extends EObjectValidator {
    public static final String MODEL_ACCESSOR = "MODEL_ACCESSOR";
    public static final String TYPING_ENVIRONMENT = "TYPING_ENVIRONMENT";
    public static final String RULE = "RULE";
    public static final String DSL = "DSL";
    private static final String RUB = "rub";
    private static final String ROOT = "root";
    public static final FormulesValidator INSTANCE = new FormulesValidator();
    public static final String DIAGNOSTIC_SOURCE = "fr.cnav.saturne.dsl.formules";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return FormulesPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateExpression((Expression)value, diagnostics, context);
            }
            case 1: {
                return this.validateCall((Call)value, diagnostics, context);
            }
            case 2: {
                return this.validateNary((Nary)value, diagnostics, context);
            }
            case 3: {
                return this.validateBinary((Binary)value, diagnostics, context);
            }
            case 4: {
                return this.validateUnary((Unary)value, diagnostics, context);
            }
            case 5: {
                return this.validateOr((Or)value, diagnostics, context);
            }
            case 6: {
                return this.validateAnd((And)value, diagnostics, context);
            }
            case 7: {
                return this.validateNot((Not)value, diagnostics, context);
            }
            case 8: {
                return this.validateImply((Imply)value, diagnostics, context);
            }
            case 9: {
                return this.validateEquiv((Equiv)value, diagnostics, context);
            }
            case 10: {
                return this.validateLowerEqual((LowerEqual)value, diagnostics, context);
            }
            case 11: {
                return this.validateGreaterEqual((GreaterEqual)value, diagnostics, context);
            }
            case 12: {
                return this.validateLower((Lower)value, diagnostics, context);
            }
            case 13: {
                return this.validateGreater((Greater)value, diagnostics, context);
            }
            case 14: {
                return this.validateDiff((Diff)value, diagnostics, context);
            }
            case 15: {
                return this.validateEquals((Equals)value, diagnostics, context);
            }
            case 16: {
                return this.validateIn((In)value, diagnostics, context);
            }
            case 17: {
                return this.validateAdd((Add)value, diagnostics, context);
            }
            case 18: {
                return this.validateSub((Sub)value, diagnostics, context);
            }
            case 19: {
                return this.validateMult((Mult)value, diagnostics, context);
            }
            case 20: {
                return this.validateDiv((Div)value, diagnostics, context);
            }
            case 21: {
                return this.validateFunctionCall((FunctionCall)value, diagnostics, context);
            }
            case 22: {
                return this.validateVarRef((VarRef)value, diagnostics, context);
            }
            case 23: {
                return this.validateQuantified((Quantified)value, diagnostics, context);
            }
            case 24: {
                return this.validateIteratorVariable((IteratorVariable)value, diagnostics, context);
            }
            case 25: {
                return this.validateBinding((Binding)value, diagnostics, context);
            }
            case 26: {
                return this.validateLet((Let)value, diagnostics, context);
            }
            case 27: {
                return this.validateFieldRef((FieldRef)value, diagnostics, context);
            }
            case 28: {
                return this.validateLiteral((Literal)value, diagnostics, context);
            }
            case 29: {
                return this.validateAlphaNum((AlphaNum)value, diagnostics, context);
            }
            case 30: {
                return this.validateDate((Date)value, diagnostics, context);
            }
            case 31: {
                return this.validateNum((Num)value, diagnostics, context);
            }
            case 32: {
                return this.validateValueList((ValueList)value, diagnostics, context);
            }
            case 33: {
                return this.validateError((Error)value, diagnostics, context);
            }
            case 34: {
                return this.validatePathExpression((PathExpression)value, diagnostics, context);
            }
            case 35: {
                return this.validateNodeExpression((NodeExpression)value, diagnostics, context);
            }
            case 36: {
                return this.validateParent((Parent)value, diagnostics, context);
            }
            case 37: {
                return this.validateChild((Child)value, diagnostics, context);
            }
            case 38: {
                return this.validateChildren((Children)value, diagnostics, context);
            }
            case 39: {
                return this.validateSingleChild((SingleChild)value, diagnostics, context);
            }
            case 40: {
                return this.validateQuantifier((Quantifier)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateExpression(Expression expression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(expression, diagnostics, context);
    }

    public boolean validateCall(Call call, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(call, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(call, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(call, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(call, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(call, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(call, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(call, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(call, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(call, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCall_ValidateCallMethod(call, diagnostics, context);
        }
        return result;
    }

    public boolean validateCall_ValidateCallMethod(Call call, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isCallValid = true;
        String errorMessage = null;
        ITypingEnvironment env = (ITypingEnvironment)context.get(TYPING_ENVIRONMENT);
        if (env == null) {
            return isCallValid;
        }
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(call);
        adapter.setTypingEnvironment(env);
        Type type = adapter.getType();
        if (type == Type.UNDEFINED) {
            errorMessage = "DSL typing error: " + adapter.getErrorMsg();
            isCallValid = false;
        }
        if (!isCallValid && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
        }
        return isCallValid;
    }

    public boolean validateNary(Nary nary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(nary, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(nary, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(nary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(nary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(nary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(nary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(nary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(nary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(nary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNary_ValidateType(nary, diagnostics, context);
        }
        return result;
    }

    public boolean validateNary_ValidateType(Nary nary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isNaryValid = true;
        String errorMessage = null;
        ITypingEnvironment env = (ITypingEnvironment)context.get(TYPING_ENVIRONMENT);
        if (env == null) {
            return isNaryValid;
        }
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(nary);
        adapter.setTypingEnvironment(env);
        Type type = adapter.getType();
        if (type == Type.UNDEFINED && adapter.getErrorMsg() != null && !adapter.getErrorMsg().contains("FieldRef couldn't be found in the models")) {
            errorMessage = "DSL typing error: " + adapter.getErrorMsg();
            isNaryValid = false;
        }
        if (!isNaryValid && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
        }
        return isNaryValid;
    }

    public boolean validateBinary(Binary binary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(binary, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(binary, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(binary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(binary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(binary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(binary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(binary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(binary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(binary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinary_ValidateType(binary, diagnostics, context);
        }
        return result;
    }

    public boolean validateBinary_ValidateType(Binary binary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isBinaryValid = true;
        String errorMessage = null;
        ITypingEnvironment env = (ITypingEnvironment)context.get(TYPING_ENVIRONMENT);
        if (env == null) {
            return isBinaryValid;
        }
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(binary);
        adapter.setTypingEnvironment(env);
        Type type = adapter.getType();
        if (type == Type.UNDEFINED && adapter.getErrorMsg() != null && !adapter.getErrorMsg().contains("FieldRef couldn't be found in the models")) {
            errorMessage = " DSL typing error: " + adapter.getErrorMsg();
            isBinaryValid = false;
        }
        if (!isBinaryValid && diagnostics != null) {
            DSLErrorUtil dslErrorUtil = new DSLErrorUtil();
            EObject dslContent = (EObject)context.get(RULE);
            if (dslContent != null) {
                errorMessage = String.valueOf(dslErrorUtil.getIntroDslErrorMsg(FormulesValidator.getObjectLabel((EObject)dslContent, context))) + errorMessage;
            }
            String binaryOperator = this.getBinaryOperator(binary);
            String dslExpression = (String)context.get(DSL);
            if (dslExpression != null && binaryOperator != null) {
                if (dslExpression.split(binaryOperator).length != 2) {
                    binaryOperator = null;
                }
                errorMessage = String.valueOf(errorMessage) + dslErrorUtil.getDslWithErrorMarkAroundFirstString(binaryOperator, dslExpression);
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
        }
        return isBinaryValid;
    }

    private String getBinaryOperator(Binary binary) {
        String binaryOperator = null;
        if (binary instanceof Imply) {
            binaryOperator = "=>";
        } else if (binary instanceof Equiv) {
            binaryOperator = "<=>";
        } else if (binary instanceof Lower) {
            binaryOperator = "<";
        } else if (binary instanceof LowerEqual) {
            binaryOperator = "<=";
        } else if (binary instanceof Greater) {
            binaryOperator = ">";
        } else if (binary instanceof GreaterEqual) {
            binaryOperator = ">=";
        } else if (binary instanceof Diff) {
            binaryOperator = "!=";
        } else if (binary instanceof Equals) {
            binaryOperator = "=";
        }
        return binaryOperator;
    }

    public boolean validateUnary(Unary unary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(unary, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(unary, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(unary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(unary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(unary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(unary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(unary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(unary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(unary, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnary_ValidateType(unary, diagnostics, context);
        }
        return result;
    }

    public boolean validateUnary_ValidateType(Unary unary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isUnaryValid = true;
        String errorMessage = null;
        ITypingEnvironment env = (ITypingEnvironment)context.get(TYPING_ENVIRONMENT);
        if (env == null) {
            return isUnaryValid;
        }
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(unary);
        adapter.setTypingEnvironment(env);
        Type type = adapter.getType();
        if (type == Type.UNDEFINED && adapter.getErrorMsg() != null && !adapter.getErrorMsg().contains("FieldRef couldn't be found in the models")) {
            errorMessage = "DSL typing error: " + adapter.getErrorMsg();
            isUnaryValid = false;
        }
        if (!isUnaryValid && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
        }
        return isUnaryValid;
    }

    public boolean validateOr(Or or, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(or, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(or, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(or, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNary_ValidateType(or, diagnostics, context);
        }
        return result;
    }

    public boolean validateAnd(And and, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(and, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(and, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(and, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNary_ValidateType(and, diagnostics, context);
        }
        return result;
    }

    public boolean validateNot(Not not, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(not, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(not, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(not, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnary_ValidateType(not, diagnostics, context);
        }
        return result;
    }

    public boolean validateImply(Imply imply, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(imply, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(imply, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(imply, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinary_ValidateType(imply, diagnostics, context);
        }
        return result;
    }

    public boolean validateEquiv(Equiv equiv, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(equiv, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(equiv, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(equiv, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(equiv, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(equiv, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(equiv, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(equiv, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(equiv, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(equiv, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinary_ValidateType(equiv, diagnostics, context);
        }
        return result;
    }

    public boolean validateLowerEqual(LowerEqual lowerEqual, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(lowerEqual, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(lowerEqual, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(lowerEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(lowerEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(lowerEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(lowerEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(lowerEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(lowerEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(lowerEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinary_ValidateType(lowerEqual, diagnostics, context);
        }
        return result;
    }

    public boolean validateGreaterEqual(GreaterEqual greaterEqual, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(greaterEqual, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(greaterEqual, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(greaterEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(greaterEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(greaterEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(greaterEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(greaterEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(greaterEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(greaterEqual, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinary_ValidateType(greaterEqual, diagnostics, context);
        }
        return result;
    }

    public boolean validateLower(Lower lower, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(lower, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(lower, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(lower, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(lower, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(lower, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(lower, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(lower, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(lower, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(lower, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinary_ValidateType(lower, diagnostics, context);
        }
        return result;
    }

    public boolean validateGreater(Greater greater, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(greater, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(greater, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(greater, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(greater, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(greater, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(greater, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(greater, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(greater, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(greater, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinary_ValidateType(greater, diagnostics, context);
        }
        return result;
    }

    public boolean validateDiff(Diff diff, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(diff, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(diff, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(diff, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(diff, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(diff, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(diff, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(diff, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(diff, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(diff, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinary_ValidateType(diff, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDiff_ValidateEnumReference(diff, diagnostics, context);
        }
        return result;
    }

    public boolean validateDiff_ValidateEnumReference(Diff diff, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String valueToCheck;
        EnumDataType enumDatatype;
        Expression rightOp;
        FieldRef fieldRef;
        String fieldId;
        Field field;
        boolean isEnumValid = true;
        String errorMessage = null;
        ModelAccessor modelAccessor = (ModelAccessor)context.get(MODEL_ACCESSOR);
        Expression leftOp = diff.getLeftOp();
        if (leftOp instanceof FieldRef && modelAccessor != null && (field = modelAccessor.getField(fieldId = (fieldRef = (FieldRef)leftOp).getName())) != null && field.getDataType() instanceof EnumDataType && (rightOp = diff.getRightOp()) instanceof AlphaNum && !this.isInEnumValueList(enumDatatype = (EnumDataType)field.getDataType(), valueToCheck = ((AlphaNum)rightOp).getValue())) {
            errorMessage = "DSL typing error: The field " + fieldId + " is compare to a bad enumValue : " + valueToCheck + ".";
            isEnumValid = false;
        }
        if (!isEnumValid && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
        }
        return isEnumValid;
    }

    public boolean validateEquals(Equals equals, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(equals, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(equals, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinary_ValidateType(equals, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEquals_ValidateEnumReference(equals, diagnostics, context);
        }
        return result;
    }

    public boolean validateEquals_ValidateEnumReference(Equals equals, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String valueToCheck;
        EnumDataType enumDatatype;
        Expression rightOp;
        FieldRef fieldRef;
        String fieldId;
        Field field;
        boolean isEnumValid = true;
        String errorMessage = null;
        ModelAccessor modelAccessor = (ModelAccessor)context.get(MODEL_ACCESSOR);
        Expression leftOp = equals.getLeftOp();
        if (leftOp instanceof FieldRef && modelAccessor != null && (field = modelAccessor.getField(fieldId = (fieldRef = (FieldRef)leftOp).getName())) != null && field.getDataType() instanceof EnumDataType && (rightOp = equals.getRightOp()) instanceof AlphaNum && !this.isInEnumValueList(enumDatatype = (EnumDataType)field.getDataType(), valueToCheck = ((AlphaNum)rightOp).getValue())) {
            errorMessage = "DSL typing error: The field " + fieldId + " is compare to a bad enumValue : " + valueToCheck + ".";
            isEnumValid = false;
        }
        if (!isEnumValid && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
        }
        return isEnumValid;
    }

    public boolean validateIn(In in, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(in, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(in, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(in, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(in, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(in, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(in, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(in, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(in, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(in, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIn_ValidateEnumReference(in, diagnostics, context);
        }
        return result;
    }

    public boolean validateIn_ValidateEnumReference(In in, DiagnosticChain diagnostics, Map<Object, Object> context) {
        FieldRef fieldRef;
        String fieldId;
        Field field;
        boolean isEnumValid = true;
        String errorMessage = null;
        ModelAccessor modelAccessor = (ModelAccessor)context.get(MODEL_ACCESSOR);
        Expression leftOp = in.getLeftOp();
        if (leftOp instanceof FieldRef && modelAccessor != null && (field = modelAccessor.getField(fieldId = (fieldRef = (FieldRef)leftOp).getName())) != null && field.getDataType() instanceof EnumDataType) {
            ValueList valueList = in.getRightOp();
            EnumDataType enumDatatype = (EnumDataType)field.getDataType();
            for (Literal value : valueList.getValues()) {
                String valueToCheck = value.getValue();
                if (this.isInEnumValueList(enumDatatype, valueToCheck)) continue;
                errorMessage = "DSL typing error: The field " + fieldId + " is compare to a bad enumValue : " + valueToCheck + ".";
                isEnumValid = false;
            }
        }
        if (!isEnumValid && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
        }
        return isEnumValid;
    }

    public boolean validateAdd(Add add, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(add, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(add, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNary_ValidateType(add, diagnostics, context);
        }
        return result;
    }

    public boolean validateSub(Sub sub, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sub, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sub, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sub, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sub, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sub, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sub, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sub, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sub, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sub, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNary_ValidateType(sub, diagnostics, context);
        }
        return result;
    }

    public boolean validateMult(Mult mult, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(mult, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(mult, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(mult, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(mult, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(mult, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(mult, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(mult, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(mult, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(mult, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNary_ValidateType(mult, diagnostics, context);
        }
        return result;
    }

    public boolean validateDiv(Div div, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(div, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(div, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(div, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(div, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(div, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(div, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(div, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(div, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(div, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNary_ValidateType(div, diagnostics, context);
        }
        return result;
    }

    public boolean validateFunctionCall(FunctionCall functionCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(functionCall, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(functionCall, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(functionCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(functionCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(functionCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(functionCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(functionCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(functionCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(functionCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCall_ValidateCallMethod(functionCall, diagnostics, context);
        }
        return result;
    }

    public boolean validateVarRef(VarRef varRef, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(varRef, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(varRef, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(varRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(varRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(varRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(varRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(varRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(varRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(varRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateVarRef_ValidateAllVariablesDeclared(varRef, diagnostics, context);
        }
        return result;
    }

    public boolean validateVarRef_ValidateAllVariablesDeclared(VarRef varRef, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isVarRefValid = false;
        String varName = varRef.getVarName();
        if (varName.equals(ROOT) || varName.equals(RUB)) {
            isVarRefValid = true;
        }
        if (!isVarRefValid) {
            isVarRefValid = this.searchDeclaration(varRef, varName);
        }
        if (!isVarRefValid) {
            ITypingEnvironment env = (ITypingEnvironment)context.get(TYPING_ENVIRONMENT);
            if (env == null) {
                isVarRefValid = false;
            }
            DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(varRef);
            adapter.setTypingEnvironment(env);
            Type type = adapter.getType();
            isVarRefValid = type != Type.UNDEFINED;
        }
        if (!isVarRefValid && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "DSL typing error: The variable " + varName + " is not declared.", new Object[]{context.get(RULE)}));
        }
        return isVarRefValid;
    }

    public boolean validateQuantified(Quantified quantified, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(quantified, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(quantified, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(quantified, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(quantified, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(quantified, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(quantified, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(quantified, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(quantified, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(quantified, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateQuantified_ValidateUniqueVariableNamesQualifier(quantified, diagnostics, context);
        }
        return result;
    }

    public boolean validateQuantified_ValidateUniqueVariableNamesQualifier(Quantified quantified, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isQuantifierValid = true;
        String errorMessage = null;
        ArrayList<String> varNameList = new ArrayList<String>();
        for (IteratorVariable iteratorVariable : quantified.getVariables()) {
            if (varNameList.contains(iteratorVariable.getVarName())) {
                isQuantifierValid = false;
                errorMessage = "DSL typing error: The variable " + iteratorVariable.getVarName() + " isn't unique in current control.";
                continue;
            }
            varNameList.add(iteratorVariable.getVarName());
        }
        TreeIterator treeIterator = quantified.getExpression().eAllContents();
        while (treeIterator.hasNext()) {
            Binding binding;
            EObject curEObj = (EObject)treeIterator.next();
            if (curEObj instanceof IteratorVariable) {
                IteratorVariable iteratorVariable = (IteratorVariable)curEObj;
                if (!varNameList.contains(iteratorVariable.getVarName())) continue;
                isQuantifierValid = false;
                errorMessage = "DSL typing error: The variable " + iteratorVariable.getVarName() + " isn't unique in current control.";
                continue;
            }
            if (!(curEObj instanceof Binding) || !varNameList.contains((binding = (Binding)curEObj).getVarName())) continue;
            isQuantifierValid = false;
            errorMessage = "DSL typing error: The variable " + binding.getVarName() + " isn't unique in current control.";
        }
        if (!isQuantifierValid && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
        }
        return isQuantifierValid;
    }

    public boolean validateIteratorVariable(IteratorVariable iteratorVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(iteratorVariable, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(iteratorVariable, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(iteratorVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(iteratorVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(iteratorVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(iteratorVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(iteratorVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(iteratorVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(iteratorVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIteratorVariable_ValidateNoExpliciteVariablesDeclared(iteratorVariable, diagnostics, context);
        }
        return result;
    }

    public boolean validateIteratorVariable_ValidateNoExpliciteVariablesDeclared(IteratorVariable iteratorVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String varName = iteratorVariable.getVarName();
        if (ROOT.equals(varName) || RUB.equals(varName)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "DSL typing error: It's not allowed to use implicite variable " + varName + ".", new Object[]{context.get(RULE)}));
            }
            return false;
        }
        return true;
    }

    public boolean validateBinding(Binding binding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(binding, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(binding, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(binding, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBinding_ValidateNoExpliciteVariablesDeclared(binding, diagnostics, context);
        }
        return result;
    }

    public boolean validateBinding_ValidateNoExpliciteVariablesDeclared(Binding binding, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String varName = binding.getVarName();
        if (ROOT.equals(varName) || RUB.equals(varName)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "DSL typing error: It's not allowed to use implicite variable " + varName + ".", new Object[]{context.get(RULE)}));
            }
            return false;
        }
        return true;
    }

    public boolean validateLet(Let let, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(let, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(let, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(let, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(let, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(let, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(let, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(let, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(let, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(let, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLet_ValidateUniqueVariableNamesLet(let, diagnostics, context);
        }
        return result;
    }

    public boolean validateLet_ValidateUniqueVariableNamesLet(Let let, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isLetValid = true;
        String errorMessage = null;
        ArrayList<String> varNameList = new ArrayList<String>();
        for (Binding binding : let.getBindings()) {
            if (varNameList.contains(binding.getVarName())) {
                isLetValid = false;
                errorMessage = "DSL typing error: The variable " + binding.getVarName() + " isn't unique in current control.";
                continue;
            }
            varNameList.add(binding.getVarName());
        }
        TreeIterator treeIterator = let.getIn().eAllContents();
        while (treeIterator.hasNext()) {
            Binding binding;
            EObject curEObj = (EObject)treeIterator.next();
            if (curEObj instanceof IteratorVariable) {
                IteratorVariable iteratorVariable = (IteratorVariable)curEObj;
                if (!varNameList.contains(iteratorVariable.getVarName())) continue;
                isLetValid = false;
                errorMessage = "DSL typing error: The variable " + iteratorVariable.getVarName() + " isn't unique in current control.";
                continue;
            }
            if (!(curEObj instanceof Binding) || !varNameList.contains((binding = (Binding)curEObj).getVarName())) continue;
            isLetValid = false;
            errorMessage = "DSL typing error: The variable " + binding.getVarName() + " isn't unique in current control.";
        }
        if (!isLetValid && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
        }
        return isLetValid;
    }

    public boolean validateFieldRef(FieldRef fieldRef, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(fieldRef, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(fieldRef, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(fieldRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(fieldRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(fieldRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(fieldRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(fieldRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(fieldRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(fieldRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFieldRef_ValidateFieldRefExists(fieldRef, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFieldRef_ValidateContextVariableExists(fieldRef, diagnostics, context);
        }
        return result;
    }

    public boolean validateFieldRef_ValidateFieldRefExists(FieldRef fieldRef, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean elementExist;
        String errorMessage = null;
        ModelAccessor modelAccessor = (ModelAccessor)context.get(MODEL_ACCESSOR);
        String fieldId = fieldRef.getName();
        Field field = modelAccessor.getField(fieldId);
        Block block = modelAccessor.getBlock(fieldId);
        boolean bl = elementExist = field != null || block != null;
        if (!elementExist) {
            DSLErrorUtil dslErrorUtil = new DSLErrorUtil();
            EObject dslContent = (EObject)context.get(RULE);
            errorMessage = dslErrorUtil.getIntroDslErrorMsg(FormulesValidator.getObjectLabel((EObject)dslContent, context));
            errorMessage = String.valueOf(errorMessage) + " DSL typing error: FieldRef couldn't be found in the models: " + fieldId;
            String msgDslWithErrorMark = dslErrorUtil.getDslWithErrorMarkAroundFirstString(fieldId, (String)context.get(DSL));
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, String.valueOf(errorMessage) + msgDslWithErrorMark, new Object[]{context.get(RULE)}));
            }
        }
        return elementExist;
    }

    public boolean validateFieldRef_ValidateContextVariableExists(FieldRef fieldRef, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean variableDeclared;
        String contextVariable = fieldRef.getContextVariable();
        if (!(contextVariable == null || ROOT.equals(contextVariable) || RUB.equals(contextVariable) || (variableDeclared = this.searchDeclaration(fieldRef, contextVariable)))) {
            String errorMessage = "DSL typing error: FieldRef references an unknow context variable: " + contextVariable;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, errorMessage, new Object[]{context.get(RULE)}));
                return false;
            }
        }
        return true;
    }

    public boolean validateLiteral(Literal literal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(literal, diagnostics, context);
    }

    public boolean validateAlphaNum(AlphaNum alphaNum, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(alphaNum, diagnostics, context);
    }

    public boolean validateDate(Date date, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(date, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(date, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(date, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(date, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(date, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(date, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(date, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(date, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(date, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDate_ValidateDateLitteral(date, diagnostics, context);
        }
        return result;
    }

    public boolean validateDate_ValidateDateLitteral(Date date, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isDateValid;
        block2: {
            isDateValid = true;
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
            sdf.setLenient(false);
            try {
                sdf.parse(date.getValue().substring(0, 8));
            }
            catch (ParseException parseException) {
                isDateValid = false;
                if (diagnostics == null) break block2;
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "DSL typing error: Date invalide dans un contr\u00f4le : " + date.getValue(), new Object[]{context.get(RULE)}));
            }
        }
        return isDateValid;
    }

    public boolean validateNum(Num num, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(num, diagnostics, context);
    }

    public boolean validateValueList(ValueList valueList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(valueList, diagnostics, context);
    }

    public boolean validateError(Error error, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(error, diagnostics, context);
    }

    public boolean validatePathExpression(PathExpression pathExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(pathExpression, diagnostics, context);
    }

    public boolean validateNodeExpression(NodeExpression nodeExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(nodeExpression, diagnostics, context);
    }

    public boolean validateParent(Parent parent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(parent, diagnostics, context);
    }

    public boolean validateChild(Child child, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(child, diagnostics, context);
    }

    public boolean validateChildren(Children children, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(children, diagnostics, context);
    }

    public boolean validateSingleChild(SingleChild singleChild, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(singleChild, diagnostics, context);
    }

    public boolean validateQuantifier(Quantifier quantifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }

    private boolean searchDeclaration(EObject eObject, String varRefName) {
        boolean isInDeclaration = true;
        if (eObject instanceof Quantified) {
            Quantified quantified = (Quantified)eObject;
            for (IteratorVariable iteratorVariable : quantified.getVariables()) {
                if (!iteratorVariable.getVarName().equals(varRefName)) continue;
                return true;
            }
        } else if (eObject instanceof Let) {
            Let let = (Let)eObject;
            for (Binding binding : let.getBindings()) {
                if (!binding.getVarName().equals(varRefName)) continue;
                return true;
            }
        }
        if (eObject.eContainer() == null) {
            return false;
        }
        isInDeclaration = this.searchDeclaration(eObject.eContainer(), varRefName);
        return isInDeclaration;
    }

    private boolean isInEnumValueList(EnumDataType enumDatatype, String valueToCheck) {
        for (Value value : enumDatatype.getValues()) {
            String valueId = value.getId();
            if (valueId == null || !valueId.equals(valueToCheck)) continue;
            return true;
        }
        return false;
    }
}

