/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.DataSourceSetDescription;
import fr.cnav.saturne.api.model.access.DataTypeSetDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.IdQualifiedElementDescription;
import fr.cnav.saturne.api.model.access.MessageDescription;
import fr.cnav.saturne.api.model.access.ReportConfigurationDescription;
import fr.cnav.saturne.api.model.access.RuleSetDescription;
import fr.cnav.saturne.api.model.access.RulesConfigurationDescription;
import fr.cnav.saturne.api.model.access.StandardMapUtils;
import java.util.ArrayList;
import java.util.List;

public class StandardDescription
implements IdQualifiedElementDescription {
    private Standard standard;
    private RulesConfigurationDescription configurations;
    private List<DeclarationDescription> declarations;
    private MessageDescription message;
    private ReportConfigurationDescription reportConfiguration;
    private RuleSetDescription rules;
    private DataTypeSetDescription dataTypes;
    private DataSourceSetDescription dataSources;

    public StandardDescription(Standard theStandard) {
        this.standard = theStandard;
        StandardMapUtils standardMapUtils = new StandardMapUtils();
        if (this.standard.getConfigurations() != null) {
            this.configurations = new RulesConfigurationDescription(this.standard.getConfigurations());
        }
        if (this.standard.getDataSources() != null) {
            this.dataSources = new DataSourceSetDescription(this.standard.getDataSources());
        }
        if (this.standard.getDataTypes() != null) {
            this.dataTypes = new DataTypeSetDescription(this.standard.getDataTypes(), standardMapUtils);
        }
        if (this.standard.getMessage() != null) {
            this.message = new MessageDescription(this.standard.getMessage(), (IdQualifiedElementDescription)this, standardMapUtils);
        }
        if (this.standard.getRules() != null) {
            this.rules = new RuleSetDescription(this.standard.getRules(), standardMapUtils);
        }
        this.declarations = new ArrayList<DeclarationDescription>();
        for (Declaration declaration : this.standard.getDeclarations()) {
            this.declarations.add(new DeclarationDescription(declaration, standardMapUtils));
        }
        if (this.standard.getReportConfiguration() != null) {
            this.reportConfiguration = new ReportConfigurationDescription(this.standard.getReportConfiguration(), standardMapUtils);
        }
    }

    public RulesConfigurationDescription getConfigurations() {
        return this.configurations;
    }

    public String getLongName() {
        return this.standard.getLongName();
    }

    public String getVersion() {
        return this.standard.getVersion();
    }

    public String getRevision() {
        return this.standard.getRevision();
    }

    public String getMessagesEncoding() {
        return this.standard.getMessagesEncoding();
    }

    public String getAllowedCharactersRegex() {
        return this.standard.getAllowedCharactersRegex();
    }

    public String getNameSpace() {
        return this.standard.getNameSpace();
    }

    public String getNamespacePrefix() {
        return this.standard.getNamespacePrefix();
    }

    public String getAllowedBlockRegex() {
        return this.standard.getAllowedBlockRegex();
    }

    public String getAllowedFieldRegex() {
        return this.standard.getAllowedFieldRegex();
    }

    public List<DeclarationDescription> getDeclarations() {
        return this.declarations;
    }

    public MessageDescription getMessage() {
        return this.message;
    }

    public ReportConfigurationDescription getReportConfiguration() {
        return this.reportConfiguration;
    }

    public String getDateFormat() {
        return this.standard.getDateFormat();
    }

    public RuleSetDescription getRules() {
        return this.rules;
    }

    public DataTypeSetDescription getDataTypes() {
        return this.dataTypes;
    }

    public DataSourceSetDescription getDataSources() {
        return this.dataSources;
    }

    @Override
    public String getName() {
        return this.standard.getName();
    }

    @Override
    public String getDescription() {
        return this.standard.getDescription();
    }

    @Override
    public String getComment() {
        return this.standard.getComment();
    }

    @Override
    public String getId() {
        return this.standard.getId();
    }

    @Override
    public String getFullQualifiedId() {
        return this.standard.getFullQualifiedId();
    }
}

