/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RuleCriticity implements Enumerator
{
    BLOCKING(1, "Blocking", "Blocking"),
    NOT_BLOCKING(2, "NotBlocking", "NotBlocking"),
    INACTIVE(3, "Inactive", "Inactive");

    public static final int BLOCKING_VALUE = 1;
    public static final int NOT_BLOCKING_VALUE = 2;
    public static final int INACTIVE_VALUE = 3;
    private static final RuleCriticity[] VALUES_ARRAY;
    public static final List<RuleCriticity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RuleCriticity[]{BLOCKING, NOT_BLOCKING, INACTIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RuleCriticity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleCriticity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleCriticity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleCriticity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleCriticity get(int value) {
        switch (value) {
            case 1: {
                return BLOCKING;
            }
            case 2: {
                return NOT_BLOCKING;
            }
            case 3: {
                return INACTIVE;
            }
        }
        return null;
    }

    private RuleCriticity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

