/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.util.SaturneResourceFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ModelLoader {
    public static final String MAIN_FILE_EXTENSION = "saturne";
    private static final String NATURE_ERROR_MESSAGE = "The specified resource doens't contain a Standard";
    private Standard standard;

    public ModelLoader(URL url) throws IOException, URISyntaxException {
        ResourceSet rs = this.createResourceSet();
        Resource resource = this.loadModel(rs, url);
        this.initializeModel(resource);
    }

    public ModelLoader(ResourceSet rs, URL url) throws IOException, URISyntaxException {
        this.initDummySaturnePackage();
        Resource resource = this.loadModel(rs, url);
        this.initializeModel(resource);
    }

    public ModelLoader(URI uri) throws IOException, URISyntaxException {
        ResourceSet rs = this.createResourceSet();
        Resource resource = this.loadModel(rs, uri);
        this.initializeModel(resource);
    }

    public ModelLoader(File modelFile) throws IOException {
        ResourceSet rs = this.createResourceSet();
        Resource resource = this.loadModel(rs, modelFile);
        this.initializeModel(resource);
    }

    public ModelLoader(String resourceName) throws IOException {
        Resource resource;
        ResourceSet rs = this.createResourceSet();
        try {
            URL url = this.getClass().getResource(resourceName);
            resource = this.loadModel(rs, url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("unknown problem", e);
        }
        this.initializeModel(resource);
    }

    private void initializeModel(Resource resource) {
        if (resource.getContents().size() > 0) {
            EObject content = (EObject)resource.getContents().get(0);
            if (content instanceof Standard) {
                this.standard = (Standard)content;
                this.touch(this.standard);
            } else {
                throw new IllegalArgumentException(NATURE_ERROR_MESSAGE);
            }
        }
    }

    private void touch(Standard theStandard) {
        for (Declaration decl : theStandard.getDeclarations()) {
            decl.getKeyValues().keySet();
            decl.getFieldRefinements().keySet();
            decl.getBlockRefinements().keySet();
        }
        TreeIterator eAllContents = theStandard.eAllContents();
        while (eAllContents.hasNext()) {
            eAllContents.next();
        }
    }

    private ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(MAIN_FILE_EXTENSION, new SaturneResourceFactoryImpl());
        this.initDummySaturnePackage();
        return resourceSet;
    }

    private void initDummySaturnePackage() {
    }

    private Resource loadModel(ResourceSet rs, File file) throws IOException {
        Resource resource = rs.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
        resource.load(Collections.EMPTY_MAP);
        return resource;
    }

    private Resource loadModel(ResourceSet rs, URL url) throws IOException, URISyntaxException {
        URI uri = URI.createURI((String)url.toURI().toString());
        Resource resource = rs.getResource(uri, true);
        return resource;
    }

    private Resource loadModel(ResourceSet rs, URI uri) throws IOException, URISyntaxException {
        Resource resource = rs.getResource(uri, true);
        return resource;
    }

    public List<GenericRule> getRuleList() {
        ArrayList<GenericRule> rules = new ArrayList<GenericRule>();
        this.collectRules(this.standard.getMessage().getHeaderBlock(), rules);
        this.collectRules(this.standard.getMessage().getFooterBlock(), rules);
        return rules;
    }

    private void collectRules(Block block, List<GenericRule> rules) {
        for (Field field : block.getChildrenFields()) {
            rules.addAll((Collection<GenericRule>)this.standard.getRules().getRulesForField(field));
        }
    }

    public List<DataType> getDataTypeList() {
        return this.standard.getDataTypes().getDatatypes();
    }

    public Standard getStandard() {
        return this.standard;
    }
}

